/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tport;

import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.tport.BufferedImageEx;
import com.ge.med.terra.tap.util.tport.TPortAnnot;
import com.ge.med.terra.tap.util.tport.TPortScene;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MedicalImageIcon
implements Icon,
Serializable {
    int[] rgb = new int[65536];
    boolean highValClip = true;
    int old_max;
    int old_min;
    private int[] colorMap = null;
    int dim;
    private boolean doubleBuffered;
    BufferedImageEx bi;

    public MedicalImageIcon(BufferedImage b, int maxDim) {
        double scalefactor = 1.0;
        if (maxDim < b.getWidth() || maxDim < b.getHeight()) {
            scalefactor = Math.max(b.getWidth() / maxDim, b.getHeight() / maxDim);
        }
        this.bi = new BufferedImageEx();
        this.bi.setBufferedImage(BufferedImageEx.scale(scalefactor, b));
        this.dim = maxDim;
    }

    @Override
    public void paintIcon(Component co, Graphics gr, int x, int y) {
        int iHeight;
        double normy;
        int iWidth;
        double normx;
        int size;
        boolean lock = false;
        Graphics2D g2 = null;
        Object mainG = null;
        boolean hasChildren = false;
        long[] t = new long[10];
        int c = 0;
        boolean paintCount = false;
        Color selectColor = Color.green;
        Dimension _d = new Dimension();
        AffineTransform _tx = new AffineTransform();
        boolean orig_w_max = false;
        boolean orig_w_min = false;
        double orig_zoom = 0.0;
        double orig_panX = 0.0;
        double orig_panY = 0.0;
        boolean showWL = true;
        boolean inWL = false;
        Object r_hint = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
        TPortScene s = new TPortScene();
        BufferedImage oldimgSet = null;
        BufferedImage finalimage = null;
        BufferedImage img = this.bi.getBufferedImage();
        t[c] = System.currentTimeMillis();
        co.getSize(_d);
        int n = size = _d.width < _d.height ? _d.width : _d.height;
        if (this.isDoubleBuffered()) {
            gr.setColor(Color.black);
            gr.fillRect(0, 0, _d.width, _d.height);
        }
        double norm = (normx = (double)_d.width / (double)(iWidth = img.getWidth())) > (normy = (double)_d.height / (double)(iHeight = img.getHeight())) ? normy : normx;
        g2 = (Graphics2D)gr.create();
        this.fillRGB(s);
        _tx.setToIdentity();
        _tx.translate(_d.width / 2, _d.height / 2);
        _tx.translate(s.pan_x * (double)_d.width, s.pan_y * (double)_d.height);
        _tx.scale(norm, norm);
        _tx.rotate(s.rotate * Math.PI / 180.0);
        _tx.scale(s.zoom, s.zoom);
        _tx.translate(-iWidth / 2, -iHeight / 2);
        g2.transform(_tx);
        if (img.getColorModel().getPixelSize() == 16) {
            if (this.old_max != s.window_max || this.old_min != s.window_min || oldimgSet != img) {
                IndexColorModel cm = new IndexColorModel(16, 65536, this.rgb, 0, false, -1, 1);
                finalimage = new BufferedImage(cm, img.getRaster(), false, null);
                this.old_max = s.window_max;
                this.old_min = s.window_min;
                oldimgSet = img;
            }
        } else {
            finalimage = img;
        }
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, r_hint);
        if (this.isDoubleBuffered()) {
            Image offScreen = co.createImage(co.getWidth(), co.getHeight());
            Graphics2D goff = (Graphics2D)offScreen.getGraphics();
            goff.fillRect(0, 0, co.getWidth(), co.getHeight());
            goff.setTransform(_tx);
            goff.setRenderingHint(RenderingHints.KEY_INTERPOLATION, r_hint);
            goff.drawImage((Image)finalimage, 0, 0, null);
            gr.drawImage(offScreen, 0, 0, co.getWidth(), co.getHeight(), null);
        } else {
            g2.drawImage((Image)finalimage, 0, 0, null);
        }
        if (showWL && inWL) {
            int width = s.window_max - s.window_min;
            int level = (s.window_max + s.window_min) / 2;
            TPortAnnot.annotDraw(gr, 10, _d.height / 2 - 7, "W:" + width + "L:" + level);
        }
    }

    @Override
    public int getIconWidth() {
        return this.bi.getBufferedImage().getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.bi.getBufferedImage().getHeight();
    }

    private void fillRGB(TPortScene s) {
        int i;
        if (this.colorMap != null) {
            this.fillRGBcmap(s);
            return;
        }
        if (s.window_min < 0) {
            s.window_min = 0;
        }
        if (s.window_max < 0) {
            s.window_max = 0;
        }
        for (i = 0; i < s.window_min; ++i) {
            this.rgb[i] = 0;
        }
        for (i = s.window_min; i < s.window_max; ++i) {
            this.rgb[i] = 65793 * (255 * (i - s.window_min) / (s.window_max - s.window_min));
        }
        for (i = s.window_max; i < 32768; ++i) {
            this.rgb[i] = 0xFFFFFF;
        }
        if (this.highValClip) {
            for (i = 32768; i < 65536; ++i) {
                this.rgb[i] = 0;
            }
        } else {
            for (i = 32768; i < 65536; ++i) {
                this.rgb[i] = 0xFFFFFF;
            }
        }
    }

    private void fillRGBcmap(TPortScene s) {
        int i;
        if (s.window_min < 0) {
            s.window_min = 0;
        }
        if (s.window_max < 0) {
            s.window_max = 0;
        }
        for (i = 0; i < s.window_min; ++i) {
            this.rgb[i] = 0;
        }
        for (i = s.window_min; i < s.window_max; ++i) {
            this.rgb[i] = this.colorMap[255 * (i - s.window_min) / (s.window_max - s.window_min)];
        }
        for (i = s.window_max; i < 32768; ++i) {
            this.rgb[i] = this.colorMap[255];
        }
        if (this.highValClip) {
            for (i = 32768; i < 65536; ++i) {
                this.rgb[i] = this.colorMap[0];
            }
        } else {
            for (i = 32768; i < 65536; ++i) {
                this.rgb[i] = this.colorMap[255];
            }
        }
    }

    public void showIcon() {
        JFrame f = new JFrame("Thumbnail");
        JLabel l = new JLabel(this);
        f.getContentPane().add(l);
        f.setDefaultCloseOperation(3);
        f.setSize(this.getIconWidth(), this.getIconHeight());
        f.setVisible(true);
    }

    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static void main(String[] args) {
        DMSession dm = new DMSession("file", null, new String[]{"\\\\Gspnet\\gspnet\\images\\dicom97\\dicom\\gems\\ct\\im85"});
        BufferedImage im1 = dm.getChildren()[0].getPixelData()[0];
        BufferedImageEx.showImage(im1, "Original");
        MedicalImageIcon mi = new MedicalImageIcon(im1, 75);
        mi.showIcon();
    }
}

