/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.tgraph;

import com.ge.med.terra.tap.util.tgraph.TGraphCursor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.Beans;
import java.util.Vector;
import javax.swing.JPanel;

public class TGraph
extends JPanel {
    double xAxisMajorTickSpacing = 0.1;
    double xAxisMinorTickSpacing = 0.05;
    double yAxisMajorTickSpacing = 0.1;
    double yAxisMinorTickSpacing = 0.05;
    double yAxisMin = 0.0;
    double yAxisMax = 1.0;
    double xAxisMin = 0.0;
    double xAxisMax = 1.0;
    boolean xAxisShow = true;
    boolean yAxisShow = true;
    final int graphNorthOffset = 20;
    final int graphSouthOffset = 20;
    final int graphEastOffset = 20;
    final int graphWestOffset = 20;
    final int majorTickLen = 4;
    int graphMode = 0;
    public final int CURVE_GRAPH = 0;
    public final int BAR_GRAPH = 1;
    public final int SCATTER_GRAPH = 2;
    private int barShift = 10;
    private Color showPointColor = Color.yellow;
    private boolean showPoints = false;
    private boolean autoResetAxis = true;
    Point2D[] pts;
    Point2D[] pts2;
    int[] xPoints;
    int[] yPoints;
    Vector cursorList = new Vector();
    long[] times = new long[10];
    int tcount = 0;
    AffineTransform at = new AffineTransform();
    boolean isInverted;
    double yThreshHold = 0.0;
    Color aboveColor = Color.green;
    Color belowColor = Color.red;
    private String[] labels;
    private boolean showTip = false;

    public void setPoints(Point2D[] p) {
        this.pts = p;
        if (this.pts2 == null || this.pts2.length != this.pts.length) {
            this.pts2 = new Point2D[this.pts.length];
        }
        if (this.xPoints == null || this.xPoints.length != this.pts.length) {
            this.xPoints = new int[p.length];
        }
        if (this.yPoints == null || this.yPoints.length != this.pts.length) {
            this.yPoints = new int[p.length];
        }
        if (this.autoResetAxis) {
            this.recalcAxis();
        }
        this.recalcPoints();
        if (this.getParent() != null) {
            this.getParent().repaint(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public void setPoints(double[] x, double[] y) {
        Point2D[] p = new Point2D[y.length];
        for (int i = 0; i < y.length; ++i) {
            p[i] = new Point2D.Double(x[i], y[i]);
        }
        this.setPoints(p);
    }

    @Override
    public void paint(Graphics g) {
        long t1 = System.currentTimeMillis();
        Graphics2D g2 = (Graphics2D)g;
        this.plotAxis(g);
        this.paintGraph(g);
        this.paintChildren(g);
        this.paintCursors(g);
        t1 = System.currentTimeMillis() - t1;
        this.times[this.tcount++] = t1;
        this.tcount %= this.times.length;
        if (this.tcount == 0) {
            int sum = 0;
            for (int i = 0; i < this.times.length; ++i) {
                sum = (int)((long)sum + this.times[i]);
            }
            double avg = (double)sum / (double)this.times.length;
            System.out.println("avg = " + avg);
        }
    }

    private void paintGraph(Graphics g) {
        Graphics g2 = g.create();
        g2.setClip(20, 20, this.getWidth() - 20 - 20, this.getHeight() - 20 - 20);
        g2.setColor(Color.black);
        if (this.xPoints != null) {
            switch (this.graphMode) {
                case 0: {
                    g.drawPolyline(this.xPoints, this.yPoints, this.yPoints.length);
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.yPoints.length; ++i) {
                        g.setColor(this.pts[i].getY() > this.yThreshHold ? this.aboveColor : this.belowColor);
                        g.fillRect(this.xPoints[i] - 3, this.yPoints[i] - 3, 6, 6);
                    }
                    break;
                }
                case 1: {
                    g.setColor(Color.gray);
                    for (int i = 0; i < this.yPoints.length; ++i) {
                        g.setColor(this.pts[i].getY() > this.yThreshHold ? this.aboveColor : this.belowColor);
                        g.fillRect(this.barShift + this.xPoints[i] - 6, this.yPoints[i], 12, this.getHeight() - 20 - this.yPoints[i]);
                    }
                    break;
                }
            }
        }
    }

    private void paintPoints(int point, Graphics g, boolean mark) {
        if (this.xPoints != null) {
            switch (this.graphMode) {
                case 0: {
                    g.drawRect(this.xPoints[point] - 2, this.yPoints[point] - 2, 4, 4);
                    break;
                }
                case 2: {
                    Color c;
                    Color color = c = this.pts[point].getY() > this.yThreshHold ? this.aboveColor : this.belowColor;
                    if (mark) {
                        c = c.brighter();
                    }
                    g.setColor(c);
                    g.fillRect(this.xPoints[point] - 3, this.yPoints[point] - 3, 6, 6);
                    break;
                }
                case 1: {
                    Color c;
                    Color color = c = this.pts[point].getY() > this.yThreshHold ? this.aboveColor : this.belowColor;
                    if (mark) {
                        c = c.brighter();
                    }
                    g.setColor(c);
                    g.fillRect(this.barShift + this.xPoints[point] - 6, this.yPoints[point], 12, this.getHeight() - 20 - this.yPoints[point]);
                }
            }
        }
    }

    private void recalcPoints() {
        if (this.yPoints == null) {
            return;
        }
        double xscale = (double)(this.getWidth() - 20 - 20) / (this.xAxisMax - this.xAxisMin);
        double xoffset = 20.0 - this.xAxisMin * xscale;
        double yscale = (double)(-(this.getHeight() - 20 - 20)) / (this.yAxisMax - this.yAxisMin);
        double yoffset = (double)(this.getHeight() - 20) - this.yAxisMin * yscale;
        this.at.setToIdentity();
        this.at.setToTranslation(xoffset, yoffset);
        this.at.scale(xscale, yscale);
        this.at.transform(this.pts, 0, this.pts2, 0, this.pts.length);
        for (int i = 0; i < this.pts.length; ++i) {
            this.xPoints[i] = (int)this.pts2[i].getX();
            this.yPoints[i] = (int)this.pts2[i].getY();
        }
    }

    public void recalcAxis() {
        this.yAxisMin = this.yAxisMax = this.pts[0].getY();
        this.xAxisMin = this.xAxisMax = this.pts[0].getX();
        for (int i = 0; i < this.pts.length; ++i) {
            if (this.yAxisMin > this.pts[i].getY()) {
                this.yAxisMin = this.pts[i].getY();
            } else if (this.yAxisMax < this.pts[i].getY()) {
                this.yAxisMax = this.pts[i].getY();
            }
            if (this.xAxisMin > this.pts[i].getX()) {
                this.xAxisMin = this.pts[i].getX();
                continue;
            }
            if (!(this.xAxisMax < this.pts[i].getX())) continue;
            this.xAxisMax = this.pts[i].getX();
        }
        this.yAxisMajorTickSpacing = (this.yAxisMax - this.yAxisMin) / 5.0;
        this.xAxisMajorTickSpacing = (this.xAxisMax - this.xAxisMin) / 5.0;
    }

    private void plotAxis(Graphics g) {
        this.plotYAxis(g);
        this.plotXAxis(g);
    }

    private void plotYAxis(Graphics g) {
        g.drawRect(20, 20, 1, this.getHeight() - 20 - 20);
        double step = (this.yAxisMax - this.yAxisMin) / this.yAxisMajorTickSpacing;
        if (step > 0.0) {
            double tickDist = (double)(this.getHeight() - 20 - 20) / step;
            double ticky = this.getHeight() - 20;
            for (double y = this.yAxisMin; y <= this.yAxisMax; y += this.yAxisMajorTickSpacing) {
                g.drawRect(16, (int)ticky, 4, 1);
                ticky -= tickDist;
            }
        }
    }

    private void plotXAxis(Graphics g) {
        g.drawRect(20, this.getHeight() - 20, this.getWidth() - 20 - 20, 1);
        double step = (this.xAxisMax - this.xAxisMin) / this.xAxisMajorTickSpacing;
        if (step > 0.0) {
            int ypos = this.getHeight() - 20;
            double tickDist = (double)(this.getWidth() - 20 - 20) / step;
            double tickx = 20.0;
            for (double x = this.xAxisMin; x <= this.xAxisMax; x += this.xAxisMajorTickSpacing) {
                g.drawRect((int)tickx, ypos, 1, 4);
                tickx += tickDist;
            }
        }
    }

    public void addCursor(TGraphCursor c) {
        this.cursorList.add(c);
        this.addMouseListener(c);
        this.addMouseMotionListener(c);
    }

    public void paintCursors(Graphics g) {
        for (TGraphCursor c : this.cursorList) {
            c.paint(g, this);
        }
    }

    public void setXPoints(double[] x) {
        Point2D[] p = this.pts == null ? new Point2D[x.length] : new Point2D[x.length < this.pts.length ? this.pts.length : x.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new Point2D.Double(x.length > i ? x[i] : 0.0, this.pts == null || this.pts.length >= i ? 0.0 : this.pts[i].getY());
        }
        this.setPoints(p);
    }

    public double[] getXPoints() {
        double[] x = new double[this.pts.length];
        for (int i = 0; i < this.pts.length; ++i) {
            x[i] = this.pts[i].getX();
        }
        return x;
    }

    public void setYPoints(double[] y) {
        Point2D[] p = this.pts == null ? new Point2D[y.length] : new Point2D[y.length < this.pts.length ? this.pts.length : y.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = new Point2D.Double(this.pts == null || this.pts.length >= i ? 0.0 : this.pts[i].getX(), y.length > i ? y[i] : 0.0);
        }
        this.setPoints(p);
    }

    public double[] getYPoints() {
        double[] y = new double[this.pts.length];
        for (int i = 0; i < this.pts.length; ++i) {
            y[i] = this.pts[i].getY();
        }
        return y;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean b) {
        boolean oldValue = this.isInverted;
        this.isInverted = b;
    }

    public void setGraphMode(int mode) {
        this.graphMode = mode;
        this.repaint();
    }

    public int getGraphMode() {
        return this.graphMode;
    }

    public double getxAxisMajorTickSpacing() {
        return this.xAxisMajorTickSpacing;
    }

    public void setxAxisMajorTickSpacing(double n) {
        this.xAxisMajorTickSpacing = n;
        this.reset_axis();
    }

    public double getxAxisMinorTickSpacing() {
        return this.xAxisMinorTickSpacing;
    }

    public void setxAxisMinorTickSpacing(double n) {
        this.xAxisMinorTickSpacing = n;
        this.reset_axis();
    }

    public double getyAxisMajorTickSpacing() {
        return this.yAxisMajorTickSpacing;
    }

    public void setyAxisMajorTickSpacing(double n) {
        this.yAxisMajorTickSpacing = n;
        this.reset_axis();
    }

    public double getyAxisMinorTickSpacing() {
        return this.yAxisMinorTickSpacing;
    }

    public void setyAxisMinorTickSpacing(double n) {
        this.yAxisMinorTickSpacing = n;
        this.reset_axis();
    }

    public double getyAxisMin() {
        return this.yAxisMin;
    }

    public void setyAxisMin(double n) {
        this.yAxisMin = n;
        this.reset_axis();
    }

    public double getyAxisMax() {
        return this.yAxisMax;
    }

    public void setyAxisMax(double n) {
        this.yAxisMax = n;
        this.reset_axis();
    }

    public double getxAxisMin() {
        return this.xAxisMin;
    }

    public void setxAxisMin(double n) {
        this.xAxisMin = n;
        this.reset_axis();
    }

    public double getxAxisMax() {
        return this.xAxisMax;
    }

    public void setxAxisMax(double n) {
        this.xAxisMax = n;
        this.reset_axis();
    }

    public boolean isxAxisShow() {
        return this.xAxisShow;
    }

    public void setxAxisShow(boolean show) {
        this.xAxisShow = show;
        this.reset_axis();
    }

    public boolean isyAxisShow() {
        return this.yAxisShow;
    }

    public void setyAxisShow(boolean show) {
        this.yAxisShow = show;
        this.reset_axis();
    }

    public double getThreshHold() {
        return this.yThreshHold;
    }

    public void setThreshHold(double value) {
        this.yThreshHold = value;
        this.reset_axis();
    }

    public void setThreshAboveColor(Color ac) {
        this.aboveColor = ac;
    }

    public Color getThreshAboveColor() {
        return this.aboveColor;
    }

    public void setThreshBelowColor(Color bc) {
        this.belowColor = bc;
    }

    public Color getThreshBelowColor() {
        return this.belowColor;
    }

    public void setShowPointColor(Color bc) {
        this.showPointColor = bc;
    }

    public Color getShowPointColor() {
        return this.showPointColor;
    }

    public void setShowPoints(boolean bc) {
        this.showPoints = bc;
    }

    public boolean isShowPoints() {
        return this.showPoints;
    }

    public void setAutoResetAxis(boolean reset) {
        this.autoResetAxis = reset;
    }

    public boolean isAutoResetAxis() {
        return this.autoResetAxis;
    }

    public void setPointLabels(String[] labels) {
        this.labels = labels;
    }

    public String[] getPointLabels() {
        return this.labels;
    }

    private void reset_axis() {
    }

    public TGraph() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Beans.isDesignTime()) {
            double[] x = new double[100];
            double[] y = new double[100];
            for (int i = 0; i < x.length; ++i) {
                x[i] = i;
                y[i] = Math.sin(x[i] / 10.0);
            }
            System.err.println("setting points");
            this.setPoints(x, y);
        }
    }

    private void jbInit() throws Exception {
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TGraph.this.graphMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TGraph.this.graphMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TGraph.this.graphMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                TGraph.this.graphMouseDragged(e);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TGraph.this.this_componentResized(e);
            }
        });
        this.setLayout(null);
    }

    void this_componentResized(ComponentEvent e) {
        this.recalcPoints();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        Object e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    private void jbInit2() throws Exception {
    }

    void graphMouseMoved(MouseEvent e) {
        if (!this.showPoints) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < this.pts.length; ++i) {
            int x = this.xPoints[i] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e.getX() - x) >= 10) continue;
            if (!(this.graphMode != 1 && Math.abs(e.getY() - this.yPoints[i]) >= 10 || this.showTip)) {
                String str = this.graphMode == 1 ? "(" + this.pts[i].getY() + ")" : "(" + this.pts[i].getX() + "," + this.pts[i].getY() + ")";
                Graphics g = this.getGraphics();
                g.setColor(this.showPointColor);
                g.drawString(str, e.getX(), e.getY());
                this.showTip = true;
            }
            found = true;
        }
        if (!found) {
            this.getParent().repaint();
            this.showTip = false;
        }
    }

    void graphMousePressed(MouseEvent e) {
        for (int i = 0; i < this.pts.length; ++i) {
            int x = this.xPoints[i] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e.getX() - x) >= 10 || this.graphMode != 1 && Math.abs(e.getY() - this.yPoints[i]) >= 10) continue;
            this.paintPoints(i, this.getGraphics(), true);
        }
    }

    void graphMouseReleased(MouseEvent e) {
        for (int i = 0; i < this.pts.length; ++i) {
            int x = this.xPoints[i] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e.getX() - x) >= 10 || this.graphMode != 1 && Math.abs(e.getY() - this.yPoints[i]) >= 10) continue;
            this.fireActionPerformed(new ActionEvent(this, i, e.toString(), e.getModifiers()));
        }
        this.getParent().repaint();
    }

    void graphMouseDragged(MouseEvent e) {
        for (int i = 0; i < this.pts.length; ++i) {
            int x = this.xPoints[i] + (this.graphMode == 1 ? this.barShift : 0);
            if (Math.abs(e.getX() - x) >= 10 || this.graphMode != 1 && Math.abs(e.getY() - this.yPoints[i]) >= 10) continue;
            this.paintPoints(i, this.getGraphics(), true);
        }
    }
}

