/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import java.io.IOException;
import java.net.Socket;

class scuExample {
    public static final int VERIFY_OK = 0;
    public static final int VERIFY_NOT_OK = 1;
    private String host;
    private int port;
    private String called;
    private String calling;

    public scuExample(String host, int port, String called, String calling) {
        this.host = host;
        this.port = port;
        this.called = called;
        this.calling = calling;
    }

    public int verify() throws IOException, DicomException, IllegalValueException, UnknownUIDException {
        Socket s = new Socket(this.host, this.port);
        Association as = new Association(s.getInputStream(), s.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        int[] tsids = new int[]{8193};
        request.addPresentationContext(4097, tsids);
        as.sendAssociateRequest(request);
        Response response = as.receiveAssociateResponse();
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, 4097);
            if (result == 3) {
                System.out.println("abstract syntax not supported");
                return 1;
            }
            if (result == 4) {
                System.out.println("transfer syntaxes not supported");
                return 1;
            }
            if (result == 1) {
                System.out.println("user rejection of presentation context");
                return 1;
            }
            if (result == 2) {
                System.out.println("presentation context refused, no reason given");
                return 1;
            }
            if (result == 0) {
                System.out.println("association accepted");
            }
            return this.doEcho(as);
        }
        if (response instanceof Reject) {
            System.out.println("association rejected: " + response);
            return 1;
        }
        if (response instanceof Abort) {
            System.out.println("association aborted: " + response);
            return 1;
        }
        System.out.println("unknown error");
        return 1;
    }

    public int query() throws IOException, DicomException, IllegalValueException, UnknownUIDException {
        Socket s = new Socket(this.host, this.port);
        Association as = new Association(s.getInputStream(), s.getOutputStream());
        Request request = new Request();
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        int[] tsids = new int[]{8193};
        request.addPresentationContext(4135, tsids);
        as.sendAssociateRequest(request);
        Response response = as.receiveAssociateResponse();
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, 4135);
            if (result == 3) {
                System.out.println("abstract syntax not supported");
                return 1;
            }
            if (result == 4) {
                System.out.println("transfer syntaxes not supported");
                return 1;
            }
            if (result == 1) {
                System.out.println("user rejection of presentation context");
                return 1;
            }
            if (result == 2) {
                System.out.println("presentation context refused, no reason given");
                return 1;
            }
            if (result == 0) {
                System.out.println("association accepted");
            }
            return this.doFind(as);
        }
        if (response instanceof Reject) {
            System.out.println("association rejected: " + response);
            return 1;
        }
        if (response instanceof Abort) {
            System.out.println("association aborted: " + response);
            return 1;
        }
        System.out.println("unknown error");
        return 1;
    }

    public int doFind(Association as) {
        try {
            DicomObject req = this.createFindRequest();
            DicomObject dataSet = new DicomObject();
            dataSet.set(78, "STUDY");
            as.send(4135, req, dataSet);
            System.out.println("After send");
            DicomObject res = as.receiveCommand();
            System.out.println("After recieve");
            int commandfield = res.getI(3);
            if (commandfield != 32800) {
                System.out.println("No C-FIND RESPONSE command field : " + Integer.toHexString(commandfield));
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            } else {
                System.out.println("command field good!");
            }
            int messageId = res.getI(5);
            System.out.println("Message ID= " + messageId);
            int dataSetType = res.getI(8);
            System.out.println("DataSetType= " + Integer.toHexString(dataSetType));
            int status = res.getI(9);
            System.out.println("Status= " + Integer.toHexString(status));
            System.out.println("Offending Element= " + Integer.toHexString(res.getI(10)));
            System.out.println("Error Comment= " + Integer.toHexString(res.getI(11)));
            as.sendReleaseRequest();
            as.receiveReleaseResponse();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int doEcho(Association as) {
        try {
            int status;
            int messageid;
            String sopclass;
            DicomObject echoreq = this.createEchoRequest();
            as.send(4097, echoreq, null);
            DicomObject echores = as.receiveCommand();
            int commandfield = echores.getI(3);
            if (commandfield != 32816) {
                System.out.println("No C-ECHO RESPONSE command field : " + Integer.toHexString(commandfield));
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            }
            if ((sopclass = echores.getS(1)) != null && UID.getUIDEntry(sopclass).getConstant() != 4097) {
                System.out.println("Affected SOP Class UID in C-ECHO RESPONSE wrong: " + sopclass);
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            }
            if ((messageid = echores.getI(5)) != 0) {
                System.out.println("Message ID in C-ECHO RESPONSE wrong: " + messageid);
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            }
            if ((status = echores.getI(9)) != 0) {
                System.out.println("Status in C-ECHO RESPONSE wrong: " + status);
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            }
            as.sendReleaseRequest();
            as.receiveReleaseResponse();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public DicomObject createEchoRequest() throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(1, UID.getUIDEntry(4097).getValue());
        dicomset.set(3, new Integer(48));
        dicomset.set(4, new Integer(0));
        dicomset.set(8, new Integer(257));
        return dicomset;
    }

    public DicomObject createFindRequest() throws DicomException, IllegalValueException {
        DicomObject dicomset = new DicomObject();
        dicomset.set(1, UID.getUIDEntry(4135).getValue());
        dicomset.set(3, new Integer(32));
        dicomset.set(4, new Integer(9));
        dicomset.set(7, new Integer(0));
        dicomset.set(8, new Integer(258));
        return dicomset;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("usage: scuExample <host> <port> <called_title> <calling_title>");
            return;
        }
        try {
            scuExample verifyscu = new scuExample(args[0], Integer.parseInt(args[1]), args[2], args[3]);
            if (verifyscu.verify() == 0) {
                System.out.println("ping to " + args[0] + " ok");
            } else {
                System.out.println("ping to " + args[0] + " not ok");
            }
            if (verifyscu.query() == 0) {
                System.out.println("query to " + args[0] + " ok");
            } else {
                System.out.println("query to " + args[0] + " not ok");
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }
}

