/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.util.log.CheckTlt;
import com.ge.med.terra.tap.util.log.Logger;
import java.lang.reflect.Method;

public class TltAdapter {
    protected static boolean tltUp = false;
    private static final String TltMessage = "com.ge.med.tlt.TltMessage";
    private static final String TltFormattable = "com.ge.med.tlt.TltFormattable";

    public TltAdapter() {
        try {
            System.loadLibrary("Tltjni");
            CheckTlt t = new CheckTlt();
            t.start();
            while (t.isAlive()) {
            }
            t = null;
        }
        catch (UnsatisfiedLinkError e) {
            System.out.println("Unable to Load library Tltjni");
        }
    }

    public boolean isTltUp() {
        return tltUp;
    }

    public int send(int level, String msg) {
        String logLevel;
        int retVal = 1;
        switch (level) {
            case 0: {
                logLevel = "Error";
                break;
            }
            case 1: {
                logLevel = "Warning";
                break;
            }
            case 2: {
                logLevel = "Status";
                break;
            }
            case 3: {
                logLevel = "Debug";
                break;
            }
            default: {
                logLevel = "Unknown";
            }
        }
        Class<?> tltMessage = null;
        Class<?> tltFormattable = null;
        Method[] tltMessageMethods = null;
        Method[] tltFormattableMethods = null;
        int send = -1;
        int setField = -1;
        int getField = -1;
        try {
            int k;
            tltMessage = Class.forName(TltMessage);
            tltFormattable = Class.forName(TltFormattable);
            Object tltMessageObj = tltMessage.newInstance();
            Object tltFormattableObj = tltFormattable.newInstance();
            tltMessageMethods = tltMessage.getMethods();
            tltFormattableMethods = tltFormattable.getMethods();
            for (k = 0; k < tltMessageMethods.length; ++k) {
                if (tltMessageMethods[k].getName().equals("setField")) {
                    setField = k;
                }
                if (tltMessageMethods[k].getName().equals("getField")) {
                    getField = k;
                }
                if (!tltMessageMethods[k].getName().equals("send")) continue;
                send = k;
            }
            for (k = 0; k < tltFormattableMethods.length; ++k) {
                if (!tltFormattableMethods[k].getName().equals("setString")) continue;
                tltFormattableMethods[k].invoke(tltFormattableObj, logLevel);
            }
            if (getField != -1 && setField != -1) {
                String s = "eCategory";
                int i = tltMessage.getField("eCategory").getInt(tltMessageObj);
                tltMessageMethods[setField].invoke(tltMessageObj, new Integer(i), tltFormattableObj);
            } else {
                Logger.send("setField/getField not found in tltMessageObj");
            }
            if (send == -1) {
                throw new Exception();
            }
            tltMessageMethods[send].invoke(tltMessageObj, msg, new Integer(0));
        }
        catch (Exception ex) {
            tltUp = false;
            Logger.send("Tlt classes could not be instantiated");
            Logger.send(level, msg);
        }
        return retVal;
    }
}

