/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class TapHandler
extends Handler {
    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        Level logLevel = record.getLevel();
        if (logLevel == Level.INFO) {
            System.out.print(logLevel);
            System.out.print("       |".substring(logLevel.getName().length()));
            System.out.println(record.getMessage());
            return;
        }
        this.printline(record);
    }

    private void printline(LogRecord record) {
        long time = record.getMillis();
        String method = record.getSourceMethodName();
        int lineno = -1;
        Level logLevel = record.getLevel();
        String fileName = "?";
        StackTraceElement[] el = new Throwable().getStackTrace();
        for (int i = 0; i < el.length; ++i) {
            if (!el[i].getMethodName().equals(method)) continue;
            lineno = el[i].getLineNumber();
            fileName = el[i].getFileName();
            break;
        }
        StringBuffer s = new StringBuffer();
        s.append(logLevel);
        s.append("       |\"".substring(logLevel.getName().length()));
        s.append(record.getMessage());
        s.append("\"|");
        s.append(record.getSourceClassName());
        s.append(".");
        s.append(method);
        s.append("(");
        s.append(fileName);
        s.append(":");
        s.append(lineno);
        s.append(")[");
        s.append(record.getThreadID());
        s.append("/");
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd.HH:mm.ss.SSS");
        s.append(df.format(new Date(time)));
        s.append("]");
        System.out.println(s);
    }
}

