/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.log;

import com.ge.med.terra.tap.util.log.TltAdapter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Logger {
    private static int levelAllowed;
    private static String logFileName;
    private static String confFileName;
    private static boolean i18nLookup;
    private static boolean isInitialized;
    private static boolean useTlt;
    private static SimpleDateFormat format;
    private static TltAdapter tltAdapter;
    public static PrintStream out;

    protected void finalize() throws Throwable {
        Logger.doCleanup();
        super.finalize();
    }

    public static void doCleanup() {
        if (out != null) {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void doInit() {
        if (isInitialized) {
            return;
        }
        Properties p = new Properties();
        InputStream in = null;
        try {
            if (System.getProperty("TAP_LOG_CONF_FILE", "null").equals("null")) {
                in = Class.forName("com.ge.med.terra.tap.util.log.Logger").getResourceAsStream("taplog.cfg");
            } else {
                System.out.println("Using ... TAP_LOG_CONF_FILE=" + System.getProperty("TAP_LOG_CONF_FILE"));
                in = new FileInputStream(System.getProperty("TAP_LOG_CONF_FILE"));
            }
            p.load(in);
        }
        catch (Exception e) {
            System.out.println("Unable to read " + confFileName + " ... using defaults");
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException ioex) {}
            }
        }
        if (out != null) {
            out.close();
        }
        out = System.out;
        levelAllowed = Integer.parseInt(p.getProperty("levelAllowed", "3").trim());
        useTlt = p.getProperty("useTlt", "false").trim().equals("true");
        i18nLookup = p.getProperty("i18nLookup", "false").trim().equals("true");
        logFileName = p.getProperty("logFileName", null);
        try {
            if (useTlt) {
                tltAdapter = new TltAdapter();
                boolean bl = useTlt = tltAdapter.isTltUp();
            }
            if (logFileName != null) {
                System.out.println("logFileName= " + logFileName);
                out = new PrintStream(new FileOutputStream(logFileName, true), true);
            }
        }
        catch (Exception e) {
            isInitialized = true;
            Logger.send(1, "Unable to open log file: " + logFileName + ", logging messages to stdout");
        }
        isInitialized = true;
    }

    public static void setLevel(int level) {
        levelAllowed = level;
    }

    public static int getLevel() {
        return levelAllowed;
    }

    public static void setLogFile(String fname) {
        if (!fname.equals(logFileName)) {
            logFileName = fname;
            isInitialized = false;
            Logger.doInit();
        }
    }

    public static String getLogFile() {
        return logFileName;
    }

    public static void setConfFile(String fname) {
        if (confFileName == null || !confFileName.equals(fname)) {
            confFileName = fname;
            isInitialized = false;
            System.setProperty("TAP_LOG_CONF_FILE", confFileName);
            Logger.doInit();
        }
    }

    public static String getConfFile() {
        return confFileName;
    }

    public static void send() {
        StringWriter sw = new StringWriter();
        new Exception().printStackTrace(new PrintWriter(sw));
        String msg = sw.toString();
        StringTokenizer st = new StringTokenizer(msg, "\n");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            msg = st.nextToken();
        }
        int level = 2;
        Logger.send(level, msg);
    }

    public static void send(String msg) {
        int level = 2;
        Logger.send(level, msg);
    }

    public static void send(int level, String msg) {
        String logLevel;
        if (!isInitialized) {
            Logger.doInit();
        }
        if (level > levelAllowed) {
            return;
        }
        if (useTlt && tltAdapter != null && tltAdapter.isTltUp()) {
            tltAdapter.send(level, msg.trim());
            return;
        }
        String date = format.format(new Date());
        String str = msg.trim();
        switch (level) {
            case 0: {
                logLevel = "Error";
                break;
            }
            case 1: {
                logLevel = "Warning";
                break;
            }
            case 2: {
                logLevel = "Status";
                break;
            }
            case 3: {
                logLevel = "Debug";
                break;
            }
            default: {
                logLevel = "Unknown";
            }
        }
        if (i18nLookup) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle("com.ge.med.terra.tap.util.log.LogResource");
                str = rb.getString(str);
            }
            catch (Exception e) {
                Logger.send(1, str + " - Missing in LogResource");
            }
        }
        out.println(date + "\t" + logLevel + "\t" + str);
    }

    static {
        logFileName = null;
        isInitialized = false;
        format = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        out = null;
    }
}

