/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.er;

import com.ge.med.terra.tap.util.er.ErServer;
import com.ge.med.terra.tap.util.er.ErServerEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Vector;

public class ErClientProxy {
    DataInputStream is;
    DataOutputStream os;
    HashMap reg = new HashMap();
    ErServer server;

    public ErClientProxy(Socket s, ErServer server) {
        this.server = server;
        try {
            this.is = new DataInputStream(s.getInputStream());
            this.os = new DataOutputStream(s.getOutputStream());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                ErServerEvent event = new ErServerEvent();
                try {
                    block2: while (true) {
                        int eventCount;
                        if ((eventCount = ErClientProxy.this.is.readInt()) != 1) {
                            System.out.println("eventcount =" + eventCount);
                        }
                        int type = ErClientProxy.this.is.readInt();
                        int i = 0;
                        while (true) {
                            if (i >= eventCount) continue block2;
                            event.read(ErClientProxy.this.is);
                            ErClientProxy.this.processEvent(type, event, System.currentTimeMillis());
                            ++i;
                        }
                        break;
                    }
                }
                catch (IOException ex) {
                    ErClientProxy.this.removeMe();
                    return;
                }
            }
        };
        t.setName("socket");
        t.start();
    }

    private void removeMe() {
        this.server.clients.remove(this);
    }

    public void processEvent(int type, ErServerEvent event, long time) {
        switch (type) {
            case 13: {
                ListenFor l = new ListenFor(event.type, event.getBuffer(), time);
                this.reg.put(l.eventType, l);
                break;
            }
            case 14: {
                this.reg.remove(event.getType());
                break;
            }
            case 15: {
                this.server.dispatch(event.type, event, this, time);
                break;
            }
            default: {
                throw new RuntimeException("dont know the event =" + event.type);
            }
        }
    }

    public synchronized void send(String type, ErServerEvent s, long time) throws IOException {
        ListenFor l = (ListenFor)this.reg.get(type);
        if (l == null) {
            return;
        }
        if (s != null) {
            l.unsent.add(s);
            s.atach();
        }
        this.send(l, time);
    }

    public void wake() {
        long time = System.currentTimeMillis();
        for (ListenFor l : this.reg.values()) {
            if (time - l.last < (long)l.minTime) continue;
            try {
                this.send(l, time);
            }
            catch (IOException ex) {}
        }
    }

    private synchronized void send(ListenFor l, long time) throws IOException {
        if (time - l.last >= (long)l.minTime) {
            this.os.writeInt(l.unsent.size());
            while (l.unsent.size() > 0) {
                ErServerEvent se = (ErServerEvent)l.unsent.remove(0);
                se.write(this.os);
                se.detach();
            }
            l.last = time;
        } else {
            this.server.notifyLater(this, (long)l.minTime - (time - l.last));
        }
    }

    public static class ListenFor {
        String eventType;
        int minTime;
        long last;
        Vector unsent = new Vector();

        public ListenFor(String type, ByteBuffer b, long time) {
            this.eventType = type;
            this.minTime = b.getInt();
            this.last = time;
        }
    }
}

