/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.tag;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class TagValueList {
    public short[] group = new short[0];
    public short[] element = new short[0];
    public Object[] value = new Object[0];

    public TagValueList() {
    }

    public TagValueList(Vector v) {
        int len = v.size();
        this.group = new short[len];
        this.element = new short[len];
        this.value = new Object[len];
        Iterator i = v.iterator();
        int cnt = 0;
        while (i.hasNext()) {
            tag t = (tag)i.next();
            this.group[cnt] = t.group;
            this.element[cnt] = t.element;
            this.value[cnt] = null;
            ++cnt;
        }
    }

    public void add(short g, short e, Object v) {
        int len = this.group.length;
        short[] gr = new short[len + 1];
        short[] el = new short[len + 1];
        Object[] vl = new Object[len + 1];
        System.arraycopy(this.group, 0, gr, 0, len);
        System.arraycopy(this.element, 0, el, 0, len);
        System.arraycopy(this.value, 0, vl, 0, len);
        gr[len] = g;
        el[len] = e;
        vl[len] = v;
        this.group = gr;
        this.element = el;
        this.value = vl;
    }

    public int hashCode() {
        int sum = 0;
        for (int i = 0; i < this.group.length; ++i) {
            if (this.value[i] == null) continue;
            sum += this.value[i].toString().hashCode();
        }
        return sum;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TagValueList) {
            TagValueList other = (TagValueList)obj;
            if (other.hashCode() != this.hashCode()) {
                return false;
            }
            if (this.group.length != other.group.length) {
                return false;
            }
            for (int i = 0; i < this.group.length; ++i) {
                if (this.group[i] != other.group[i]) {
                    return false;
                }
                if (this.element[i] != other.element[i]) {
                    return false;
                }
                if (this.value[i] == other.value[i] || this.value[i] == null || this.value[i].equals(other.value[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void diff(TagValueList other) {
        if (other.hashCode() != this.hashCode()) {
            System.out.println("hash code diffrent " + this.hashCode() + "," + other.hashCode());
            System.out.println("\n" + this + "\n----\n" + other);
        }
        if (this.group.length != other.group.length) {
            System.out.println("table length diffrent");
            return;
        }
        for (int i = 0; i < this.group.length; ++i) {
            if (this.group[i] != other.group[i]) {
                return;
            }
            if (this.element[i] != other.element[i]) {
                return;
            }
            if (this.value[i] == other.value[i] || this.value[i].equals(other.value[i])) continue;
            return;
        }
        System.out.println("same");
    }

    public TagValueList(String str) {
        StringTokenizer st = new StringTokenizer(str, " ");
        while (st.hasMoreTokens()) {
            String tagString = st.nextToken();
            String eqString = st.nextToken();
            String valueString = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            String andString = st.nextToken();
        }
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < this.group.length; ++i) {
            str = str + "(" + Integer.toHexString(this.group[i]) + "," + Integer.toHexString(this.element[i]) + ") = ";
            str = str + this.value[i];
            str = str + (i + 1 == this.group.length ? "" : " AND ");
        }
        return str;
    }
}

