/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.SOPClass;
import com.archimed.dicom.UID;
import com.archimed.dicom.UIDEntry;
import com.ge.med.terra.tap.Tap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Properties;

public class SOPClassUtil
extends UID {
    public static HashMap jdtSOPs = new HashMap();
    public static HashMap jdtTSIDs = new HashMap();
    public static boolean debug = Tap.getProperty("tap.dm.SOP.debug", "false").equalsIgnoreCase("true");

    public static HashMap getFields(String cname, int maxval) {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        try {
            Class<?> c1 = Class.forName(cname);
            AccessibleObject[] fieldArr = c1.getFields();
            Field.setAccessible(fieldArr, true);
            if (debug) {
                System.out.println("class <" + c1 + "> fields:");
            }
            for (int i = 0; i < fieldArr.length; ++i) {
                AccessibleObject f = fieldArr[i];
                try {
                    int v = ((Field)f).getInt(c1);
                    if (v <= 0 || v >= maxval) continue;
                    if (debug) {
                        System.out.println("name:" + ((Field)f).getName() + " type:" + ((Field)f).getType() + " val:" + ((Field)f).getInt(c1));
                    }
                    fields.put(((Field)f).getName(), new Integer(((Field)f).getInt(c1)));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return fields;
    }

    public static void addCustomSOPClasses(Properties props) {
        if (props == null) {
            return;
        }
        String str = props.getProperty("tap.dm.newSOPClasses");
        if (str == null) {
            return;
        }
        int num = Integer.parseInt(str);
        UIDEntry[] entries = new UIDEntry[num];
        for (int i = 0; i < num; ++i) {
            str = props.getProperty("tap.dm.newSOPClass" + (i + 1));
            if (str == null) continue;
            String[] sop = str.split("\\,");
            if (sop.length != 3) {
                System.out.println("Error parsing <" + str + "> skipping ...");
                continue;
            }
            if (debug) {
                System.out.println("Adding: " + sop[0].trim() + " " + sop[1].trim() + " " + sop[2].trim());
            }
            entries[i] = new UIDEntry(0, sop[0].trim(), sop[1].trim(), sop[2].trim(), 1);
        }
        try {
            SOPClassUtil.addEntries(entries);
        }
        catch (Exception ex) {
            System.out.println("Failed adding SOPClasses!");
            ex.printStackTrace();
        }
    }

    public static synchronized void addEntries(UIDEntry[] earray) throws DicomException {
        int i;
        for (i = 0; i < earray.length; ++i) {
            if (earray[i].getType() == 1) continue;
            throw new DicomException("UIDEntry added should be of type SOPClass: " + earray[i].getName());
        }
        System.out.println("Adding " + earray.length + " entries");
        for (i = 0; i < earray.length; ++i) {
            SOPClass.addEntry(earray[i]);
        }
    }

    public static int[] parseSOPClasses(String sopstr) {
        int i;
        if (sopstr == null) {
            return null;
        }
        String[] sops = sopstr.split("\\,");
        int[] arr = new int[sops.length];
        for (i = 0; i < sops.length; ++i) {
            String sop = sops[i].trim();
            Integer icode = (Integer)jdtSOPs.get(sop);
            arr[i] = -1;
            if (icode != null) {
                arr[i] = icode;
            } else {
                try {
                    UIDEntry uid = UID.getUIDEntry(sop);
                    if (uid != null) {
                        arr[i] = uid.getConstant();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (arr[i] != -1) continue;
            System.out.println("Cannot find SOPClass: <" + sop + ">, skipping ..");
        }
        if (debug) {
            System.out.println(">>> " + sopstr + ":");
            for (i = 0; i < arr.length; ++i) {
                System.out.println("sops[i]" + sops[i].trim() + " :" + arr[i] + ", ");
            }
        }
        return arr;
    }

    public static void main(String[] args) {
        System.out.println("tsids:" + jdtSOPs.toString());
        int[] arr = SOPClassUtil.parseSOPClasses("ImplicitVRLittleEndian, ExplicitVRBigEndian, ExplicitVRLittleEndian");
    }

    static {
        int maxUIDs = Integer.MAX_VALUE;
        SOPClassUtil.addCustomSOPClasses(Tap.getProperties());
        HashMap tsmap = SOPClassUtil.getFields("com.archimed.dicom.TransferSyntax", maxUIDs);
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("maxUID: " + maxUIDs);
        }
        jdtTSIDs.putAll(tsmap);
        jdtSOPs.putAll(tsmap);
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.SOPClass", maxUIDs));
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.MetaSOPClass", maxUIDs));
        jdtSOPs.putAll(SOPClassUtil.getFields("com.archimed.dicom.SOPInstance", maxUIDs));
    }
}

