/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.jdbDicomDict;
import com.ge.med.terra.tap.util.dicom.tagValue;
import com.ge.med.terra.tap.util.dicom.tagValuePtr;
import com.ge.med.terra.tap.util.dicom.vr;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class MemParser
extends dicomParser {
    boolean little_endian;
    boolean explicitVR;
    boolean forceBigEndianImage = false;
    boolean syntaxLock;
    private int off;
    private int fileOff;
    boolean brokenGroup2;
    private byte[] data;
    private boolean done = false;
    private int bytesInData;
    String fileName = null;
    private String tag_8_5 = null;
    static jdbDicomDict dict = new jdbDicomDict();

    private final void resetflags() {
        this.little_endian = true;
        this.tag_8_5 = null;
        this.explicitVR = true;
        this.syntaxLock = false;
        this.off = 0;
        this.fileOff = 0;
        this.brokenGroup2 = false;
    }

    public MemParser() {
        this.resetflags();
    }

    public MemParser(FileInputStream is) throws FileNotFoundException {
        this.setFile(is);
    }

    public MemParser(String fn) throws FileNotFoundException {
        this.setFile(fn);
    }

    public MemParser(byte[] data) {
        this.setFile(data);
    }

    @Override
    public void setFile(String fn) throws FileNotFoundException {
        try {
            int act;
            File f = new File(fn);
            int len = (int)f.length();
            byte[] data = new byte[len];
            FileInputStream fileStr = new FileInputStream(fn);
            for (int read = 0; read < len; read += act) {
                act = fileStr.read(data, read, len - read);
                if (act >= 0) continue;
                fileStr.close();
                throw new RuntimeException("Could not read \"" + fn + "\"");
            }
            fileStr.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        this.setFile(this.data);
    }

    @Override
    public void clearFile() {
    }

    @Override
    public void setFile(InputStream is) throws FileNotFoundException {
        try {
            int read;
            byte[] buff = new byte[524288];
            int start = 0;
            int len = buff.length;
            while ((read = is.read(buff, start, len - start)) >= 0) {
                if ((start += read) != len) continue;
                byte[] newBuff = new byte[buff.length * 2];
                System.arraycopy(buff, 0, newBuff, 0, buff.length);
                buff = newBuff;
            }
            byte[] newBuff = new byte[len];
            System.arraycopy(buff, 0, newBuff, 0, buff.length);
            this.setFile(newBuff);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFile(byte[] data) {
        this.data = data;
        this.bytesInData = data.length;
        this.done = false;
        if (new String(data, 0, 4).equals("DICM")) {
            this.off = 4;
            this.fileOff = 4;
            return;
        }
        if (new String(data, 128, 4).equals("DICM")) {
            this.off = 132;
            this.fileOff = 132;
            return;
        }
        tagValue t = new tagValue();
        this.read(t);
        if (t.group == 0 && t.element == 0 && t.len == 4) {
            this.off = 0;
            this.fileOff = 0;
            this.explicitVR = false;
            if (t.group == 8) {
                this.syntaxLock = true;
            }
            return;
        }
        if (t.group == 8 && t.element < 255) {
            this.off = 0;
            this.fileOff = 0;
            if (t.group == 8) {
                this.syntaxLock = true;
            }
            return;
        }
        this.little_endian = !this.little_endian;
        this.read(t);
        if (t.group == 0 && t.element == 0 && t.len == 4 || t.group == 8 && t.element < 255) {
            this.off = 0;
            this.fileOff = 0;
            if (t.group == 8) {
                this.syntaxLock = true;
            }
            return;
        }
        throw new RuntimeException("not a DICOM file");
    }

    private void readtag(tagValue t) {
        t.fileOffset = this.fileOff;
        t.group = this.read16();
        t.element = this.read16();
    }

    private void guessReadTag(tagValue t) {
        t.fileOffset = this.fileOff;
        t.group = this.read16();
        t.element = this.read16();
        if (t.group > 256) {
            this.little_endian = !this.little_endian;
            this.off -= 4;
            this.fileOff -= 4;
            t.group = this.read16();
            t.element = this.read16();
        }
        if (t.group >= 8) {
            this.syntaxLock = true;
        }
    }

    private void readVR(tagValue t) {
        if ((this.explicitVR || t.group == 2) && !this.brokenGroup2) {
            t.vrep = this.readVR();
            if (t.group == 2 && t.element == 0 && t.vrep != 21836) {
                this.off -= 2;
                this.fileOff -= 2;
                t.vrep = 21836;
                this.brokenGroup2 = true;
                t.len = this.read32();
                return;
            }
            if (t.vrep == 0) {
                t.vrep = this.getVR(t.group, t.element);
            }
            if (t.vrep == 20290 || t.vrep == 20311 || t.vrep == 21329 || t.vrep == 21838) {
                this.off += 2;
                this.fileOff += 2;
                t.len = this.read32();
            } else if (t.vrep == 21844 || t.vrep == 20294) {
                this.read16();
                t.len = this.read32();
            } else {
                t.len = this.read16();
            }
            if (t.group == 8 && t.element == 5) {
                this.tag_8_5 = new String(this.data, this.off, t.len).trim();
                if (this.noI18N || this.tag_8_5.length() == 0 || this.tag_8_5.equals("ISO_IR 100") || this.tag_8_5.equals("ISO 2022 IR 100")) {
                    this.tag_8_5 = null;
                }
            }
            if (t.group == 2 && t.element == 16) {
                String str = new String(this.data, this.off, t.len).trim();
                if (str.equals("1.2.840.113619.5.2")) {
                    if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                        Tap.log.warning("odd transfer");
                    }
                    this.forceBigEndianImage = false;
                    this.explicitVR = false;
                }
                if (str.equals("1.2.840.10008.1.2")) {
                    this.explicitVR = false;
                } else if (str.equals("1.2.840.10008.1.2.2")) {
                    this.explicitVR = true;
                    this.little_endian = false;
                }
            }
        } else {
            t.vrep = this.getVR(t.group, t.element);
            t.len = this.read32();
            if (t.group == 8 && t.element == 5) {
                this.tag_8_5 = new String(this.data, this.off, t.len).trim();
                if (this.noI18N || this.tag_8_5.length() == 0 || this.tag_8_5.equals("ISO_IR 100") || this.tag_8_5.equals("ISO 2022 IR 100")) {
                    this.tag_8_5 = null;
                }
            }
            if (t.group == 2 && t.element == 16) {
                String str = new String(this.data, this.off, t.len).trim();
                if (str.equals("1.2.840.113619.5.2")) {
                    this.forceBigEndianImage = true;
                }
                if (str.equals("1.2.840.10008.1.2")) {
                    this.explicitVR = false;
                } else if (str.equals("1.2.840.10008.1.2.2")) {
                    this.explicitVR = true;
                    this.little_endian = false;
                }
            }
        }
    }

    private void readPtrValue(tagValuePtr t) {
        t.setOffset(this.fileOff);
        t.setLittleEndian(this.little_endian);
        if (t.vrep == 21329) {
            throw new Error("REFRENCE FOR SEQUENCES NOT SUPPORTED >" + t.group + "," + t.element);
        }
        if (t.group == 32736 && t.element == 16 && this.forceBigEndianImage) {
            t.setLittleEndian(false);
        }
        t.setExplicitVR(this.explicitVR);
        if (t.group != 32736 || t.element != 16) {
            this.off += t.len;
        }
        this.fileOff += t.len;
    }

    private void readValue(tagValue t) {
        if (t.vrep == 21329) {
            int seq_end = t.len != -1 ? this.fileOff + t.len : Integer.MAX_VALUE;
            ArrayList<Object[]> seq = new ArrayList<Object[]>(10);
            while (this.fileOff < seq_end) {
                int item_end;
                int seqGroup = this.read16();
                int seqElem = this.read16();
                int itemlen = this.read32();
                if (seqGroup == 65534 && seqElem == 57565) break;
                ArrayList<tagValue> item = new ArrayList<tagValue>(10);
                int n = item_end = itemlen != -1 ? this.fileOff + itemlen : Integer.MAX_VALUE;
                while (this.fileOff < item_end) {
                    tagValue st = new tagValue();
                    this.readtag(st);
                    if (st.group == 65534 && st.element == 57357) {
                        this.read32();
                        break;
                    }
                    this.readVR(st);
                    this.readValue(st);
                    item.add(st);
                    int old_off = this.fileOff;
                    if (this.fileOff == old_off) continue;
                    item_end -= old_off - this.fileOff;
                    seq_end -= old_off - this.fileOff;
                }
                seq.add(item.toArray());
            }
            t.value = seq.toArray();
            return;
        }
        if (t.len < this.data.length - this.off) {
            if (t.group == 32736 && t.element == 16 && this.forceBigEndianImage) {
                t.setData(this.data, this.off, false, this.explicitVR, this.tag_8_5);
            } else {
                t.setData(this.data, this.off, this.little_endian, this.explicitVR, this.tag_8_5);
            }
        } else {
            System.out.println("len big  (" + t.group + "," + t.element + ")[" + vr.toString(t.vrep) + "]" + t.len);
        }
        this.off += t.len;
        this.fileOff += t.len;
    }

    @Override
    public boolean hasMoreTags() {
        if (this.bytesInData - this.off < 1000) {
            System.out.println("bytesInData=" + this.bytesInData + " off" + this.off + " - = " + (this.bytesInData - this.off));
        }
        if (this.bytesInData - this.off == 0) {
            return false;
        }
        return !this.done;
    }

    private void skipValue(tagValue t) {
        if (t.vrep == 21329) {
            int seq_end = t.len != -1 ? this.fileOff + t.len : Integer.MAX_VALUE;
            tagValue st = new tagValue();
            block0: while (this.fileOff < seq_end) {
                int item_end;
                int seqGroup = this.read16();
                int seqElem = this.read16();
                int itemlen = this.read32();
                if (seqGroup == 65534 && seqElem == 57565) break;
                int n = item_end = itemlen != -1 ? this.fileOff + itemlen : Integer.MAX_VALUE;
                while (this.fileOff < item_end) {
                    this.readtag(st);
                    if (st.group == 65534 && st.element == 57357) {
                        this.read32();
                        continue block0;
                    }
                    this.readVR(st);
                    this.readValue(st);
                    int old_off = this.fileOff;
                    if (this.fileOff == old_off) continue;
                    item_end -= old_off - this.fileOff;
                    seq_end -= old_off - this.fileOff;
                }
            }
            return;
        }
        this.off += t.len;
        this.fileOff += t.len;
    }

    private void read(tagValue t) {
        if (this.syntaxLock) {
            this.readtag(t);
        } else {
            this.guessReadTag(t);
        }
        this.readVR(t);
        this.readValue(t);
    }

    @Override
    public tagValue[] getTags() {
        int maxTags = 200;
        tagValue[] tv = new tagValue[maxTags];
        int j = 0;
        while (this.hasMoreTags()) {
            if (j == maxTags) {
                tagValue[] ntv = new tagValue[maxTags += 100];
                System.arraycopy(tv, 0, ntv, 0, j);
                tv = ntv;
            }
            tv[j++] = this.skipNext();
        }
        tagValue[] rtv = new tagValue[j];
        System.arraycopy(tv, 0, rtv, 0, j);
        return rtv;
    }

    @Override
    public void fill(tagValue[] tags) {
        tagValue t = new tagValue();
        int fill = 0;
        for (int i = 0; i < tags.length; ++i) {
            tags[i].value = null;
        }
        while (fill < tags.length && this.hasMoreTags()) {
            if (this.syntaxLock) {
                this.readtag(t);
            } else {
                this.guessReadTag(t);
            }
            this.readVR(t);
            if (t.len > 20000000) {
                System.out.println("big >" + t + "  len=" + t.len);
            }
            boolean readit = false;
            while (fill < tags.length && tags[fill].group < t.group) {
                ++fill;
            }
            if (fill == tags.length) break;
            if (tags[fill].group == t.group) {
                while (fill < tags.length && tags[fill].group == t.group && tags[fill].element < t.element) {
                    ++fill;
                }
                if (fill == tags.length) break;
                if (tags[fill].element == t.element) {
                    tags[fill].len = t.len;
                    tags[fill].vrep = t.vrep;
                    readit = true;
                }
            }
            if (readit) {
                if (tags[fill] instanceof tagValuePtr) {
                    this.readPtrValue((tagValuePtr)tags[fill]);
                } else {
                    this.readValue(t);
                }
                tags[fill].value = t.value;
                tags[fill].fileOffset = t.fileOffset;
                continue;
            }
            this.skipValue(t);
        }
    }

    private int getVR(int g, int e) {
        return dict.getVR(g, e);
    }

    private final int readVR() {
        int t1 = this.data[this.off++] & 0xFF;
        int t2 = this.data[this.off++] & 0xFF;
        this.fileOff += 2;
        return t1 << 8 | t2;
    }

    private final int read16() {
        this.fileOff += 2;
        int res = this.little_endian ? this.data[this.off++] & 0xFF | (this.data[this.off++] & 0xFF) << 8 : (this.data[this.off++] & 0xFF) << 8 | this.data[this.off++] & 0xFF;
        return res;
    }

    private final int read32() {
        int t1 = this.data[this.off++] & 0xFF;
        int t2 = this.data[this.off++] & 0xFF;
        int t3 = this.data[this.off++] & 0xFF;
        int t4 = this.data[this.off++] & 0xFF;
        this.fileOff += 4;
        long acc = 0L;
        acc = this.little_endian ? (long)(t1 | t2 << 8 | t3 << 16 | t4 << 24) : (long)(t1 << 24 | t2 << 16 | t3 << 8 | t4);
        return (int)(acc & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public tagValue skipNext() {
        tagValue t = new tagValue();
        if (this.syntaxLock) {
            this.readtag(t);
        } else {
            this.guessReadTag(t);
        }
        this.readVR(t);
        this.skipValue(t);
        if (t.is(32736, 16)) {
            this.done = true;
        }
        return t;
    }

    @Override
    public tagValue readNext() {
        tagValue t = new tagValue();
        if (this.syntaxLock) {
            this.readtag(t);
        } else {
            this.guessReadTag(t);
        }
        this.readVR(t);
        this.readValue(t);
        if (t.is(32736, 16)) {
            this.done = true;
        }
        return t;
    }

    public void updatePart10InLine(int group, int element, byte[] value) throws IOException {
        tagValue tv = new tagValue(group, element);
        this.fill(new tagValue[]{tv});
        if (value == null) {
            throw new IllegalArgumentException("Error updating (0x" + Integer.toHexString(group) + ", 0x" + Integer.toHexString(element) + "): " + "No value specified!");
        }
        if (tv.vrep == 21329) {
            throw new IllegalArgumentException("Error updating (0x" + Integer.toHexString(group) + ", 0x" + Integer.toHexString(element) + "): " + "Given tag is a sequence; not supported!");
        }
        if (tv.len < value.length) {
            throw new IllegalArgumentException("Error updating (0x" + Integer.toHexString(group) + ", 0x" + Integer.toHexString(element) + "): " + "Given value bigger than original!");
        }
        long offset = tv.fileOffset;
        offset += 4L;
        if (this.explicitVR) {
            offset += 2L;
        }
        if (tv.vrep == 20290 || tv.vrep == 20311 || tv.vrep == 21329 || tv.vrep == 21844 || tv.vrep == 21838) {
            offset += 2L;
        }
        offset = this.explicitVR ? (offset += 2L) : (offset += 4L);
        RandomAccessFile file = new RandomAccessFile(this.fileName, "rw");
        file.seek(offset);
        file.write(value);
        if (tv.len > value.length) {
            byte[] zeros = new byte[tv.len - value.length];
            for (int i = 0; i < zeros.length; ++i) {
                zeros[i] = 0;
            }
            file.write(zeros);
        }
        file.close();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            return;
        }
        String[] str = args;
        System.out.println("PARSING:");
        for (int i = 0; i < str.length; ++i) {
            System.out.println("     " + str[i]);
        }
        try {
            int i;
            MemParser dp = new MemParser();
            int toRead = 500;
            tagValue[] tv = new tagValue[toRead];
            long t1 = System.currentTimeMillis();
            for (int i2 = 0; i2 < str.length; ++i2) {
                dp.setFile(str[i2]);
                int count = 0;
                while (dp.hasMoreTags()) {
                    tv[count] = dp.readNext();
                    ++count;
                }
                t1 = System.currentTimeMillis() - t1;
                System.out.println("-----------------");
                for (int j = 0; j < count; ++j) {
                    if (tv[j].vrep != 21329) {
                        System.out.println(tv[j]);
                        continue;
                    }
                    if (tv[j] == null) continue;
                    System.out.println(tv[j]);
                    MemParser.printSequence("", tv[j]);
                }
            }
            System.out.println("time to read = " + (double)t1 / 1000.0 + "sec");
            short[][] tags = new short[][]{{8, 22}, {16, 16}, {16, 32}, {16, 48}, {32, 13}};
            tagValue[] tget = new tagValue[tags.length];
            for (i = 0; i < tags.length; ++i) {
                tget[i] = new tagValue(tags[i][0], tags[i][1]);
            }
            t1 = System.currentTimeMillis();
            for (i = 0; i < str.length; ++i) {
                dp.setFile(str[i]);
                dp.fill(tget);
            }
            t1 = System.currentTimeMillis() - t1;
            for (i = 0; i < tget.length; ++i) {
                System.out.println(tget[i]);
            }
            System.out.println("part read time = " + (double)t1 / 1000.0);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public static void printSequence(String indent, tagValue tv) {
        Object[] sq = (Object[])tv.value;
        for (int i = 0; i < sq.length; ++i) {
            Object[] item = (Object[])sq[i];
            System.out.println("" + indent + i + "---------------");
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                System.out.println("" + indent + i + ">" + elem);
                if (elem.vrep != 21329) continue;
                MemParser.printSequence(indent + i + ".", elem);
            }
        }
        System.out.println("" + indent + "---------end seq------");
    }

    private final void dbg(String s) {
    }

    public static String formatPNtoScreen(String pn) {
        return MemParser.formatPNtoScreen(pn, false);
    }

    public static String formatPNtoScreen(String pn, boolean lastNameFirst) {
        int index;
        String name = pn;
        String[] names = new String[5];
        int count = 0;
        while (count < 5 && (index = name.indexOf(94)) != -1) {
            names[count++] = name.substring(0, index);
            names[count] = name.substring(index + 1);
            name = names[count];
        }
        if (lastNameFirst) {
            switch (count) {
                case 0: {
                    return pn;
                }
                case 1: {
                    return names[0] + " " + names[1];
                }
                case 2: {
                    return names[1] + " " + names[2] + " " + names[0];
                }
                case 3: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0];
                }
                case 4: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0] + " " + names[4];
                }
            }
        } else {
            switch (count) {
                case 0: {
                    return pn;
                }
                case 1: {
                    return names[1] + " " + names[0];
                }
                case 2: {
                    return names[1] + " " + names[2] + " " + names[0];
                }
                case 3: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0];
                }
                case 4: {
                    return names[3] + " " + names[1] + " " + names[2] + " " + names[0] + " " + names[4];
                }
            }
        }
        return pn;
    }

    public static jdbDicomDict getDictionary() {
        return dict;
    }
}

