/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.archimed.dicom.DDictBase;
import com.archimed.dicom.DDictEntry;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.Jdt;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.jdbDictElement;
import com.ge.med.terra.tap.util.dicom.tag;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;

public class JdtExtension {
    public static void updateJDT() {
        Jdt.setKeepPN(Tap.getProperty("tap.dm.jdt.setKeepPN", "true").equalsIgnoreCase("true"));
        Jdt.setDSAsString(true);
        Jdt.setWriteDefaultGroupLengths(false);
        Hashtable tapdd = dicomParser.dict.FieldMap;
        Enumeration v = tapdd.keys();
        tag t = null;
        while (v.hasMoreElements()) {
            int element;
            t = (tag)v.nextElement();
            jdbDictElement elem = (jdbDictElement)tapdd.get(t);
            int group = t.getGroup() & 0xFFFF;
            if (Integer.MAX_VALUE != DDictBase.lookupDDict(group, element = t.getElement() & 0xFFFF)) continue;
            try {
                DDictBase.addEntry(new DDictEntry(group, element, JdtExtension.tapToJdtVr(elem.vr), elem.tagName, elem.vm));
            }
            catch (DicomException e) {
                System.err.println("Error adding " + t);
            }
        }
        try {
            Enumeration e = DDictBase.ddictEntries();
            while (e.hasMoreElements()) {
                DDictEntry de = (DDictEntry)e.nextElement();
                if (de.getGroup() != 64 || de.getElement() != 37392 || de.getType() == 7) continue;
                Field f = DDictEntry.class.getDeclaredField("type");
                f.setAccessible(true);
                f.set(de, new Integer(7));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int tapToJdtVr(int tapVr) {
        switch (tapVr) {
            case 16709: {
                return 4;
            }
            case 16723: {
                return 17;
            }
            case 16724: {
                return 5;
            }
            case 17235: {
                return 9;
            }
            case 17473: {
                return 11;
            }
            case 17491: {
                return 16;
            }
            case 17492: {
                return 28;
            }
            case 17996: {
                return 26;
            }
            case 17988: {
                return 20;
            }
            case 18771: {
                return 15;
            }
            case 19535: {
                return 6;
            }
            case 19540: {
                return 18;
            }
            case 20290: {
                return 8;
            }
            case 20294: {
                return 29;
            }
            case 20311: {
                return 24;
            }
            case 20558: {
                return 14;
            }
            case 21320: {
                return 7;
            }
            case 21324: {
                return 19;
            }
            case 21329: {
                return 10;
            }
            case 21331: {
                return 23;
            }
            case 21332: {
                return 13;
            }
            case 21581: {
                return 12;
            }
            case 21833: {
                return 2;
            }
            case 21836: {
                return 1;
            }
            case 21838: {
                return 0;
            }
            case 21843: {
                return 3;
            }
            case 21844: {
                return 27;
            }
        }
        return 0;
    }
}

