/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.dicomInfoTableModel;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;

public class Diff
extends JPanel
implements Printable {
    private InputStream streamA;
    private InputStream streamB;
    private HashMap map = new HashMap();
    private JTable table = new JTable();
    private BorderLayout borderLayout1 = new BorderLayout();
    private dicomInfoTableModel model = new dicomInfoTableModel();
    private JScrollPane scroll = new JScrollPane();
    private Vector allData = new Vector();
    private boolean areDiff = true;
    private String[] headers = new String[]{"DIFF", "Tag", "Name", "Value", "Value2"};

    public Diff() {
        this.model.setColumnNames(this.headers);
        try {
            this.buildTagNames();
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFiles(String a, String b) {
        try {
            this.setFiles(new FileInputStream(a), new FileInputStream(b));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFiles(InputStream a, InputStream b) {
        this.streamA = a;
        this.streamB = b;
        this.parse();
        this.model.setData(this.allData);
    }

    public boolean areFilesDifferent() {
        return this.areDiff;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.table.setModel(this.model);
        this.scroll.getViewport().add(this.table);
        this.add((Component)this.scroll, "Center");
    }

    private void buildTagNames() {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("dicomDict.txt")));
            while (in.ready()) {
                String str = in.readLine();
                StringTokenizer tok = new StringTokenizer(str, ";");
                String group = tok.nextToken().toLowerCase();
                String element = tok.nextToken().toLowerCase();
                String tagName = tok.nextToken();
                this.map.put("(" + group + "," + element + ")", tagName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse() {
        try {
            this.areDiff = false;
            DiffLine[] delta = Diff.diff(this.streamA, this.streamB);
            this.allData.clear();
            Vector[] vect = new Vector[this.headers.length];
            for (int i = 0; i < vect.length; ++i) {
                vect[i] = new Vector();
                this.allData.add(vect[i]);
            }
            for (int k = 0; k < delta.length; ++k) {
                tagValue tv = delta[k].tva != null ? delta[k].tva : delta[k].tvb;
                String tag2 = tagValue.atToString(tv.group, tv.element);
                if (delta[k].state == 3) {
                    this.areDiff = true;
                    vect[0].add(delta[k].stateString());
                    vect[4].add(delta[k].tvb.value);
                } else {
                    vect[0].add(delta[k].stateString());
                    vect[4].add("");
                }
                vect[1].add(tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (tv.value != null && tv.value.getClass() == Object[].class) {
                    vect[3].add("Sequence");
                } else if (tv.value instanceof Object[]) {
                    Object[] o = (Object[])tv.value;
                    String str = "[" + o.length + "]";
                    for (int i = 0; i < 2; ++i) {
                        str = str + o[i].toString() + ",";
                    }
                    str = str + "...";
                    vect[3].add(str);
                } else {
                    vect[3].add(tv.value);
                }
                if (tv.value == null || tv.value.getClass() != Object[].class) continue;
                if (delta[k].tva == null) {
                    this.appendSeq(vect, (Object[])delta[k].tvb.value, "");
                    continue;
                }
                if (delta[k].tvb == null) {
                    this.appendSeq(vect, (Object[])delta[k].tva.value, "");
                    continue;
                }
                this.appendSeq(vect, (Object[])delta[k].tva.value, (Object[])delta[k].tvb.value, "");
            }
        }
        catch (Exception e) {
            this.areDiff = true;
            e.printStackTrace();
        }
    }

    private void appendSeq(Vector[] vect, Object[] seq, String indent) {
        indent = indent + ">";
        for (int i = 0; i < seq.length; ++i) {
            Object[] item = (Object[])seq[i];
            vect[0].add("");
            vect[1].add(indent + "ITEM");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                vect[0].add("");
                vect[1].add(indent + tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (elem.value instanceof Object[]) {
                    vect[3].add("Sequence");
                } else {
                    vect[3].add(elem.value);
                }
                vect[4].add("");
                if (elem.value == null || elem.value.getClass() != Object[].class) continue;
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add("");
        vect[1].add(indent + "ITEM END");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private void appendSeq(Vector[] vect, Object[] seq_a, Object[] seq_b, String indent) {
        indent = indent + ">";
        for (int i = 0; i < seq_a.length; ++i) {
            Object[] item = (Object[])seq_a[i];
            tagValue[] itemb = i < seq_b.length ? (Object[])seq_b[i] : new tagValue[20];
            vect[0].add("");
            vect[1].add(indent + "ITEM");
            vect[2].add("");
            vect[3].add("");
            vect[4].add("");
            for (int j = 0; j < item.length; ++j) {
                tagValue elem = (tagValue)item[j];
                tagValue elemb = itemb[j];
                String tag2 = tagValue.atToString(elem.group, elem.element);
                if (Diff.isSameObject(elem, elemb)) {
                    vect[0].add("SAME");
                } else {
                    vect[0].add("DIFF");
                }
                vect[1].add(indent + tag2);
                vect[2].add(this.looseQuotes((String)this.map.get(tag2)));
                if (elem.value instanceof Object[]) {
                    vect[3].add("Sequence");
                } else {
                    vect[3].add(elem.value);
                }
                vect[4].add("");
                if (elem.value.getClass() != Object[].class) continue;
                if (elemb != null) {
                    this.appendSeq(vect, (Object[])elem.value, (Object[])elemb.value, indent);
                    continue;
                }
                this.appendSeq(vect, (Object[])elem.value, indent);
            }
        }
        vect[0].add("");
        vect[1].add(indent + "ITEM END");
        vect[2].add("");
        vect[3].add("");
        vect[4].add("");
    }

    private String looseQuotes(String str) {
        if (str == null || str.trim().equals("")) {
            return null;
        }
        if (str.charAt(0) == '\"') {
            str = str.substring(1);
        }
        if (str.charAt(str.length() - 1) == '\"') {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    @Override
    public int print(Graphics g, PageFormat format, int page) {
        if (page > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(format.getImageableX(), format.getImageableY());
        double sx = format.getImageableWidth() / (double)this.getWidth();
        double sy = format.getImageableHeight() / (double)this.getHeight();
        if (sx > sy) {
            sx = sy;
        } else {
            sy = sx;
        }
        g2d.scale(sx, sy);
        this.printAll(g2d);
        return 0;
    }

    @Override
    public void print(Graphics g) {
        Color c = this.getBackground();
        this.setBackground(Color.white);
        this.paint(g);
        this.setBackground(c);
    }

    public static void main(String[] args) {
        final Diff diff1 = new Diff();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        JPanel p = new JPanel();
        f.getContentPane().add((Component)p, "North");
        final JTextField t1 = new JTextField("E:\\dev\\images\\ves\\s7\\i39.SCDC.1");
        JButton b = new JButton("Diff");
        final JTextField t2 = new JTextField("E:\\dev\\images\\ves\\s7\\i40.SCDC.2");
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                diff1.setFiles(t1.getText(), t2.getText());
                System.out.println("[" + t1.getText() + "] and [" + t2.getText() + "] are " + (diff1.areFilesDifferent() ? "different" : "the same"));
            }
        });
        p.add(new JLabel("A:"));
        p.add(t1);
        p.add(b);
        p.add(new JLabel("B:"));
        p.add(t2);
        f.getContentPane().add(diff1);
        f.pack();
        f.setVisible(true);
    }

    private static boolean isSameObject(tagValue tva, tagValue tvb) {
        if (tva == null && tvb == null) {
            return true;
        }
        if (tva == null && tvb != null) {
            return false;
        }
        if (tva != null && tvb == null) {
            return false;
        }
        if (tva.value == null && tvb.value == null) {
            return true;
        }
        if (tva.value == null || tvb.value == null) {
            return false;
        }
        if (tva.value != null && tva.value.equals(tvb.value)) {
            return true;
        }
        if (tva.value.getClass() == Object[].class) {
            if (tvb.value.getClass() == Object[].class) {
                return Diff.sameSequence((Object[])tva.value, (Object[])tvb.value);
            }
            return false;
        }
        if (tva.value instanceof Object[] && tvb.value instanceof Object[]) {
            for (int i = 0; i < ((Object[])tva.value).length; ++i) {
                if (((Object[])tva.value)[i].equals(((Object[])tvb.value)[i])) continue;
                return false;
            }
            return true;
        }
        if (tva.vrep == 20290 && tvb.vrep == 20290) {
            byte[] a = (byte[])tva.value;
            byte[] b = (byte[])tvb.value;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        if (tva.vrep == 20311 && tvb.vrep == 20311) {
            short[] a = (short[])tva.value;
            short[] b = (short[])tvb.value;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == b[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean sameSequence(Object[] a, Object[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            Object[] ia = (Object[])a[i];
            Object[] ib = (Object[])b[i];
            if (ia.length != ib.length) {
                return false;
            }
            for (int j = 0; j < ia.length; ++j) {
                tagValue tva = (tagValue)ia[j];
                tagValue tvb = (tagValue)ia[j];
                boolean objsame = Diff.isSameObject(tva, tvb);
                if (objsame) continue;
                return false;
            }
        }
        return true;
    }

    private static DiffLine[] diff(InputStream streamA, InputStream streamB) throws FileNotFoundException {
        dicomParser pa = new dicomParser();
        pa.setFile(streamA);
        dicomParser pb = new dicomParser();
        pb.setFile(streamB);
        Vector<DiffLine> v = new Vector<DiffLine>(100);
        boolean dida = true;
        boolean didb = true;
        tagValue tva = null;
        tagValue tvb = null;
        while (pa.hasMoreTags() || pb.hasMoreTags()) {
            if (!pa.hasMoreTags()) {
                tva = null;
            }
            if (!pb.hasMoreTags()) {
                tvb = null;
            }
            if (dida && pa.hasMoreTags()) {
                tva = pa.readNext();
            }
            if (didb && pb.hasMoreTags()) {
                tvb = pb.readNext();
            }
            int diff = 0;
            if (tva == null) {
                diff = 1000;
                if (tvb == null) {
                    break;
                }
            } else if (tvb == null) {
                diff = -1000;
            }
            if (diff == 0) {
                diff = tva.group - tvb.group;
            }
            if (diff == 0) {
                diff = tva.element - tvb.element;
            }
            dida = true;
            didb = true;
            if (diff == 0) {
                v.add(new DiffLine(tva, tvb));
                dida = true;
                didb = true;
            }
            if (diff > 0) {
                v.add(new DiffLine(null, tvb));
                dida = false;
            }
            if (diff >= 0) continue;
            v.add(new DiffLine(tva, null));
            didb = false;
        }
        pa.clearFile();
        pb.clearFile();
        DiffLine[] result = new DiffLine[v.size()];
        Iterator iter = v.iterator();
        int i = 0;
        while (iter.hasNext()) {
            result[i++] = (DiffLine)iter.next();
        }
        return result;
    }

    private static class DiffLine {
        int group;
        int element;
        int state;
        public static final int SAME = 0;
        public static final int IN_A = 1;
        public static final int IN_B = 2;
        public static final int DIFF = 3;
        tagValue tva;
        tagValue tvb;

        public String stateString() {
            switch (this.state) {
                case 0: {
                    return "SAME";
                }
                case 1: {
                    return "IN_A";
                }
                case 2: {
                    return "IN_B";
                }
                case 3: {
                    return "DIFF";
                }
            }
            return "????";
        }

        public String toString() {
            String str = "(" + Integer.toHexString(this.group) + "," + Integer.toHexString(this.element) + ")";
            switch (this.state) {
                case 0: {
                    return str + "[SAME]" + this.tva;
                }
                case 1: {
                    return str + "[IN_A]" + this.tva;
                }
                case 2: {
                    return str + "[IN_B]" + this.tvb;
                }
                case 3: {
                    return str + "[DIFF]" + this.tva + " VS " + this.tvb;
                }
            }
            return str;
        }

        public DiffLine(tagValue a, tagValue b) {
            this.tva = a;
            this.tvb = b;
            if (a == null) {
                this.group = b.group;
                this.element = b.element;
                this.state = 2;
                return;
            }
            if (b == null) {
                this.group = a.group;
                this.element = a.element;
                this.state = 1;
                return;
            }
            this.group = a.group;
            this.element = a.element;
            this.state = 3;
            if (Diff.isSameObject(a, b)) {
                this.state = 0;
            }
        }
    }
}

