/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.util.dicom.Diff;
import com.ge.med.terra.tap.util.dicom.dicomInfo;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.tport.TPort;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class DicomTool
extends JPanel {
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JButton load = new JButton();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel3 = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    JButton diff = new JButton();
    JButton info = new JButton();
    JButton idisplay = new JButton();
    JTabbedPane tab = new JTabbedPane();
    DefaultListModel dlm = new DefaultListModel();
    ImageIcon ico = new ImageIcon(new BufferedImage(10, 10, 5));
    Color veryLightGray = new Color(240, 240, 240);
    String lastDir = "D:\\dev\\dicom";
    JList jList1 = new JList();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton del = new JButton();

    public DicomTool() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.jList1.setCellRenderer(new myLCR());
    }

    public static void main(String[] args) {
        Serializable f;
        try {
            f = new Font("Arial Unicode MS", 0, 15);
            UIManager.getDefaults().put("TextField.font", f);
        }
        catch (Exception ex) {
            // empty catch block
        }
        f = new JFrame("DicomTool");
        DicomTool p = new DicomTool();
        ((JFrame)f).setContentPane(p);
        ((Window)f).setBounds(10, 10, 800, 600);
        ((JFrame)f).setDefaultCloseOperation(3);
        ((Window)f).setVisible(true);
    }

    private void jbInit() throws Exception {
        this.setInputVerifier(null);
        this.setLayout(this.borderLayout1);
        this.jPanel2.setLayout(this.borderLayout2);
        this.load.setToolTipText("select dicom files");
        this.load.setText("Load dicom file...");
        this.load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomTool.this.load_actionPerformed(e);
            }
        });
        this.jPanel1.setDebugGraphicsOptions(0);
        this.jPanel1.setLayout(this.borderLayout3);
        this.diff.setToolTipText("Take the defrence  between dicom file");
        this.diff.setText("Diff >");
        this.diff.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomTool.this.diff_actionPerformed(e);
            }
        });
        this.info.setToolTipText("Get listing of dicom tags");
        this.info.setText("Info >");
        this.info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomTool.this.info_actionPerformed(e);
            }
        });
        this.jPanel4.setPreferredSize(new Dimension(110, 33));
        this.jPanel4.setLayout(this.gridBagLayout1);
        this.idisplay.setToolTipText("Displays the selected file as image");
        this.idisplay.setText("Image >");
        this.idisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomTool.this.idisplay_actionPerformed(e);
            }
        });
        this.jScrollPane1.setPreferredSize(new Dimension(150, 130));
        this.jList1.setModel(this.dlm);
        this.del.setText("Delete Tab");
        this.del.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DicomTool.this.del_actionPerformed(e);
            }
        });
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.load, null);
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.jPanel1.add((Component)this.jPanel4, "East");
        this.jPanel4.add((Component)this.diff, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanel4.add((Component)this.info, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 10, 10), 0, 0));
        this.jPanel4.add((Component)this.idisplay, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 10, 0, 10), 0, 0));
        this.jPanel4.add((Component)this.del, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.tab, "Center");
    }

    void load_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser(this.lastDir);
        fc.setMultiSelectionEnabled(true);
        fc.setFileSelectionMode(2);
        fc.showOpenDialog((Component)e.getSource());
        File[] fs = fc.getSelectedFiles();
        if (fs != null && fs.length > 0) {
            this.lastDir = fs[0].getParent();
            for (int i = 0; i < fs.length; ++i) {
                this.dlm.addElement(new FileWrap(fs[i]));
            }
            this.jList1.repaint();
        }
    }

    void diff_actionPerformed(ActionEvent e) {
        Object[] list = this.jList1.getSelectedValues();
        if (list.length != 2) {
            return;
        }
        Diff d = new Diff();
        d.setFiles(((FileWrap)list[0]).file.getAbsolutePath(), ((FileWrap)list[1]).file.getAbsolutePath());
        this.tab.add(list[0].toString() + " vs " + list[1].toString(), d);
        this.tab.setSelectedIndex(this.tab.getComponentCount() - 1);
    }

    void info_actionPerformed(ActionEvent e) {
        Object[] list = this.jList1.getSelectedValues();
        if (list.length != 1) {
            return;
        }
        dicomInfo d = new dicomInfo();
        Font f = new Font("Arial Unicode MS", 0, 15);
        d.table.setFont(f);
        d.setFile(((FileWrap)list[0]).file.getAbsolutePath());
        this.tab.add(list[0].toString(), d);
        this.tab.setSelectedIndex(this.tab.getComponentCount() - 1);
    }

    void idisplay_actionPerformed(ActionEvent e) {
        Object[] list = this.jList1.getSelectedValues();
        ArrayList<BufferedImage> al = new ArrayList<BufferedImage>();
        JPanel p = new JPanel(new BorderLayout());
        final TPort port = new TPort();
        port.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                System.out.println(2 + e.getKeyChar());
                if (e.getKeyChar() == '\u0003') {
                    BufferedImage img = new BufferedImage(port.getWidth(), port.getHeight(), 1);
                    port.paint(img.getGraphics());
                    ImageTransferable tran = new ImageTransferable(img);
                    Clipboard c = Toolkit.getDefaultToolkit().getSystemClipboard();
                    c.setContents(tran, null);
                }
            }
        });
        p.add(port);
        final JScrollBar sb = new JScrollBar();
        sb.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                port.setFrame(sb.getValue());
            }
        });
        p.add((Component)sb, "East");
        dicomParser dp = new dicomParser();
        for (int i = 0; i < list.length; ++i) {
            FileWrap fw = (FileWrap)list[i];
            try {
                dp.setFile(fw.file.getAbsolutePath());
                BufferedImage[] imgs = dicomImageGen.getImages(dp, null);
                for (int k = 0; k < imgs.length; ++k) {
                    al.add(imgs[k]);
                }
                dp.clearFile();
                continue;
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
        sb.setBlockIncrement(1);
        sb.setValue(0);
        sb.setUnitIncrement(1);
        sb.setVisibleAmount(1);
        sb.setMaximum(al.size());
        port.setImages(al.toArray(new BufferedImage[al.size()]));
        this.tab.add(list[0].toString() + "...", p);
        this.tab.setIconAt(this.tab.getComponentCount() - 1, this.ico);
        this.tab.setSelectedIndex(this.tab.getComponentCount() - 1);
    }

    void del_actionPerformed(ActionEvent e) {
        this.tab.remove(this.tab.getSelectedIndex());
    }

    class ImageTransferable
    implements Transferable {
        Image myimage;

        public ImageTransferable(Image image) {
            this.myimage = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.myimage;
        }
    }

    class myLCR
    implements ListCellRenderer {
        myLCR() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            FileWrap c = (FileWrap)value;
            if (isSelected) {
                c.setOpaque(true);
                c.setBackground(Color.black);
                c.setForeground(Color.white);
            } else {
                c.setOpaque(true);
                c.setBackground((index & 1) == 0 ? Color.white : DicomTool.this.veryLightGray);
                c.setForeground(Color.black);
            }
            return c;
        }
    }

    class FileWrap
    extends JLabel {
        File file;
        String str;

        public FileWrap(File f) {
            this.file = f;
            File parentFile = this.file.getParentFile();
            if (null != parentFile) {
                this.str = parentFile.getName() + "/";
            }
            this.str = this.str + this.file.getName();
            this.setText(this.str);
            this.setToolTipText(this.file.getAbsolutePath());
        }

        @Override
        public String toString() {
            return this.str;
        }
    }
}

