/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public enum DicomCharSet {
    DEFAULT("", "Default repertoire", null, null, "US-ASCII"),
    ISO_IR_100("ISO_IR 100", "Latin alphabet No. 1", null, null, "ISO-8859-1"),
    ISO_IR_101("ISO_IR 101", "Latin alphabet No. 2", null, null, "ISO-8859-2"),
    ISO_IR_109("ISO_IR 109", "Latin alphabet No. 3", null, null, "ISO-8859-3"),
    ISO_IR_110("ISO_IR 110", "Latin alphabet No. 4", null, null, "ISO-8859-4"),
    ISO_IR_144("ISO_IR 144", "Cyrillic", null, null, "ISO-8859-5"),
    ISO_IR_127("ISO_IR 127", "Arabic", null, null, "ISO-8859-6"),
    ISO_IR_126("ISO_IR 126", "Greek", null, null, "ISO-8859-7"),
    ISO_IR_138("ISO_IR 138", "Hebrew", null, null, "ISO-8859-8"),
    ISO_IR_148("ISO_IR 148", "Latin alphabet No. 5", null, null, "ISO-8859-9"),
    ISO_IR_13("ISO_IR 13", "Japanese", null, null, "JIS_X0201"),
    ISO_IR_166("ISO_IR 166", "Thai", null, null, "TIS-620"),
    ISO_2022_IR_6("ISO 2022 IR 6", "Default repertoire (Code Extensions)", null, new byte[]{40, 66}, "US-ASCII"),
    ISO_2022_IR_100("ISO 2022 IR 100", "Latin alphabet No. 1 (Code Extensions)", new byte[]{45, 65}, new byte[]{40, 66}, "ISO-8859-1"),
    ISO_2022_IR_101("ISO 2022 IR 101", "Latin alphabet No. 2 (Code Extensions)", new byte[]{45, 66}, new byte[]{40, 66}, "ISO-8859-2"),
    ISO_2022_IR_109("ISO 2022 IR 109", "Latin alphabet No. 3 (Code Extensions)", new byte[]{45, 67}, new byte[]{40, 66}, "ISO-8859-3"),
    ISO_2022_IR_110("ISO 2022 IR 110", "Latin alphabet No. 4 (Code Extensions)", new byte[]{45, 68}, new byte[]{40, 66}, "ISO-8859-4"),
    ISO_2022_IR_144("ISO 2022 IR 144", "Cyrillic (Code Extensions)", new byte[]{45, 76}, new byte[]{40, 66}, "ISO-8859-5"),
    ISO_2022_IR_127("ISO 2022 IR 127", "Arabic (Code Extensions)", new byte[]{45, 71}, new byte[]{40, 66}, "ISO-8859-6"),
    ISO_2022_IR_126("ISO 2022 IR 126", "Greek (Code Extensions)", new byte[]{45, 70}, new byte[]{40, 66}, "ISO-8859-7"),
    ISO_2022_IR_138("ISO 2022 IR 138", "Hebrew (Code Extensions)", new byte[]{45, 72}, new byte[]{40, 66}, "ISO-8859-8"),
    ISO_2022_IR_148("ISO 2022 IR 148", "Latin alphabet No. 5 (Code Extensions)", new byte[]{45, 77}, new byte[]{40, 66}, "ISO-8859-9"),
    ISO_2022_IR_13("ISO 2022 IR 13", "Japanese (Code Extensions)", new byte[]{41, 73}, new byte[]{40, 74}, "JIS_X0201"),
    ISO_2022_IR_166("ISO 2022 IR 166", "Thai (Code Extensions)", new byte[]{45, 84}, new byte[]{40, 66}, "TIS-620"),
    ISO_2022_IR_87("ISO 2022 IR 87", "Japanese (JIS X 0208)", new byte[]{36, 66}, null, "x-JIS0208"),
    ISO_2022_IR_159("ISO 2022 IR 159", "Japanese (JIS X 0212)", new byte[]{36, 40, 68}, null, "JIS_X0212-1990"),
    ISO_2022_IR_149("ISO 2022 IR 149", "Korean (KS X 1001)", new byte[]{36, 41, 67}, null, "EUC-KR"),
    ISO_IR_192("ISO_IR 192", "Unicode in UTF-8", null, null, "UTF-8"),
    GB18030("GB18030", "Simplified Chinese, PRC standard", null, null, "GB18030");

    private String description;
    private String definedTerm;
    private byte[] escapeSequenceG1;
    private byte[] escapeSequenceG0;
    private String javaCharsetName;
    private static DicomCharSet[] DEFAULT_CHARSET;
    private static final Map<String, DicomCharSet> lookup;

    private DicomCharSet(String definedTerm, String description, byte[] escapeSequenceG1, byte[] escapeSequenceG0, String javaCharsetName) {
        if (null == definedTerm) {
            throw new IllegalArgumentException("DICOM defined term cannot be 'null'.");
        }
        this.description = description;
        this.definedTerm = definedTerm;
        this.escapeSequenceG1 = escapeSequenceG1;
        this.escapeSequenceG0 = escapeSequenceG0;
        this.javaCharsetName = javaCharsetName;
        try {
            if (!Charset.isSupported(javaCharsetName)) {
                Tap.log.log(Level.WARNING, "Charset " + definedTerm + " (" + javaCharsetName + ") not available, no decoding/encoding in this charset possible.");
            }
        }
        catch (IllegalCharsetNameException ex) {
            Tap.log.log(Level.WARNING, "Charset " + definedTerm + " (" + javaCharsetName + ") not available, no decoding/encoding in this charset possible. ", ex);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefinedTerm() {
        return this.definedTerm;
    }

    public void setDefinedTermAlias(String aliases) {
        if (null != aliases) {
            String[] names;
            for (String name : names = aliases.split(",")) {
                String alias = name.trim();
                Tap.log.log(Level.FINE, "Adding {0} alias to {1}", new Object[]{alias, this});
                lookup.put(alias, this);
            }
        }
    }

    public byte[] getEscapeSequenceG1() {
        return this.escapeSequenceG1;
    }

    public byte[] getEscapeSequenceG0() {
        return this.escapeSequenceG0;
    }

    public String getJavaCharsetName() {
        return this.javaCharsetName;
    }

    public Charset getJavaCharset() {
        return Charset.forName(this.javaCharsetName);
    }

    public static DicomCharSet get(String definedTerm) {
        return lookup.get(definedTerm);
    }

    public static DicomCharSet get(byte[] escapeSequence) {
        for (DicomCharSet dicomCharset : DicomCharSet.values()) {
            if (Arrays.equals(escapeSequence, dicomCharset.escapeSequenceG1)) {
                return dicomCharset;
            }
            if (!Arrays.equals(escapeSequence, dicomCharset.escapeSequenceG0)) continue;
            return dicomCharset;
        }
        return null;
    }

    public static DicomCharSet[] getDefaultCharSet() {
        return DEFAULT_CHARSET;
    }

    public static void setDefaultCharSet(String definedTerm) {
        if (null == definedTerm || "".equals(definedTerm)) {
            DicomCharSet.setDefaultCharSet((DicomCharSet)null);
        } else {
            try {
                DicomCharSet dicomCharset = DicomCharSet.valueOf(definedTerm);
                DicomCharSet.setDefaultCharSet(dicomCharset);
            }
            catch (IllegalArgumentException iaex) {
                Tap.log.log(Level.WARNING, "Invalid DICOM defined term [{0}]. Default not changed.", definedTerm);
            }
        }
    }

    public static void setDefaultCharSet(DicomCharSet dicomCharset) {
        if (null == dicomCharset) {
            Tap.log.log(Level.FINE, "Setting default DICOM character repertoire [{0}]", (Object)DEFAULT);
            DicomCharSet.DEFAULT_CHARSET[0] = DEFAULT;
        } else {
            Tap.log.log(Level.FINE, "Changing default repertoire to [{0}]", (Object)dicomCharset);
            DicomCharSet.DEFAULT_CHARSET[0] = dicomCharset;
        }
    }

    public static String getTag85(DicomCharSet[] dicomCharsets) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < dicomCharsets.length; ++i) {
            if (i > 0) {
                sb.append("\\");
            }
            sb.append(dicomCharsets[i].getDefinedTerm());
        }
        return sb.toString();
    }

    public static DicomCharSet[] getDicomCharSets(String tag_8_5) {
        if (null == tag_8_5 || "".equals(tag_8_5)) {
            Tap.log.log(Level.FINE, "No character repertoire provided.  Using default.");
            return DEFAULT_CHARSET;
        }
        String[] definedTerms = tag_8_5.split("\\\\");
        DicomCharSet dicomCharset = DicomCharSet.get(definedTerms[0]);
        if (definedTerms.length > 1 && DicomCharSet.isMultiByte(dicomCharset)) {
            Tap.log.log(Level.WARNING, "DICOM defined term \"{0}\" must be the only value. Ignoring the rest.", definedTerms[0]);
            definedTerms = definedTerms[0].split("\\\\");
        }
        if (DicomCharSet.isMultiByteCodeExt(dicomCharset)) {
            Tap.log.log(Level.WARNING, "First value \"{0}\" cannot be a multi-byte character set. Using default for first value.", definedTerms[0]);
            definedTerms = ("\\" + tag_8_5).split("\\\\");
        }
        DicomCharSet[] charsets = new DicomCharSet[definedTerms.length];
        Tap.log.log(Level.FINE, "Found {0} character repertorie(s) in string \"{1}\"", new Object[]{String.valueOf(charsets.length), tag_8_5});
        for (int i = 0; i < definedTerms.length; ++i) {
            if ("".equals(definedTerms[i])) {
                charsets[i] = ISO_2022_IR_6;
                continue;
            }
            charsets[i] = DicomCharSet.get(definedTerms[i]);
            if (null != charsets[i]) continue;
            Tap.log.log(Level.WARNING, "Unknown DICOM defined term \"{0}\". Using default.", definedTerms[i]);
            return DEFAULT_CHARSET;
        }
        return charsets;
    }

    public static String[] getDefinedTerms(String tag_8_5) {
        DicomCharSet[] dicomCharsets = DicomCharSet.getDicomCharSets(tag_8_5);
        String[] definedTerms = new String[dicomCharsets.length];
        for (int i = 0; i < dicomCharsets.length; ++i) {
            definedTerms[i] = dicomCharsets[i].getDefinedTerm();
        }
        return definedTerms;
    }

    public static boolean isMultiByteCodeExt(DicomCharSet dicomCharset) {
        return ISO_2022_IR_87 == dicomCharset || ISO_2022_IR_159 == dicomCharset || ISO_2022_IR_149 == dicomCharset;
    }

    public static boolean isMultiByte(DicomCharSet dicomCharset) {
        return ISO_IR_192 == dicomCharset || GB18030 == dicomCharset;
    }

    public static String escToString(byte[] escapeSequence) {
        String msg = "ESC (";
        if (null == escapeSequence) {
            msg = msg + "none";
        } else {
            for (int i = 0; i < escapeSequence.length; ++i) {
                if (i > 0) {
                    msg = msg + " ";
                }
                msg = msg + Integer.toHexString(escapeSequence[i]);
            }
        }
        msg = msg + ")";
        return msg;
    }

    public static String dicomCharSetsToString(DicomCharSet[] dicomCharsets) {
        String sep = SimpleUtilities.getLineSeparator();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < dicomCharsets.length; ++i) {
            if (i > 0) {
                buf.append(sep);
            }
            buf.append("DICOM Character Set #");
            buf.append(i);
            buf.append(": ");
            buf.append((Object)dicomCharsets[i]);
        }
        return buf.toString();
    }

    public String toLongString() {
        String msg = this.description + ": DICOM (" + this.definedTerm + "), G1 " + DicomCharSet.escToString(this.escapeSequenceG1) + ", G0 " + DicomCharSet.escToString(this.escapeSequenceG0) + ", Java (" + this.javaCharsetName + ")";
        return msg;
    }

    public static void main(String[] args) {
        try {
            System.out.println("--- begin DICOM charset list ---");
            for (DicomCharSet dicomCharset : DicomCharSet.values()) {
                System.out.println((Object)dicomCharset);
            }
            System.out.println("--- end DICOM charset list ---");
            String[] tag85 = new String[]{null, "", "\\junkset", "junkset\\ISO_IR 100", "ISO 2022 IR 87", "ISO 2022 IR 87\\junk", "ISO 2022 IR 87\\ISO 2022 IR 127"};
            for (int i = 0; i < tag85.length; ++i) {
                System.out.println("Parsing tag (0008,0005): \"" + tag85[i] + "\"");
                System.out.println(DicomCharSet.dicomCharSetsToString(DicomCharSet.getDicomCharSets(tag85[i])));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        DEFAULT_CHARSET = new DicomCharSet[1];
        lookup = new HashMap<String, DicomCharSet>();
        DicomCharSet.setDefaultCharSet(Tap.getProperty("tap.dicom.charset.default"));
        for (DicomCharSet dicomCharset : DicomCharSet.values()) {
            lookup.put(dicomCharset.getDefinedTerm(), dicomCharset);
            String aliases = Tap.getProperty("tap.dicom.charset.alias." + dicomCharset.name());
            dicomCharset.setDefinedTermAlias(aliases);
        }
    }
}

