/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class DemoFindFile {
    public static tagValue[] buildTagsToFind() {
        short[][] tags = new short[][]{{40, 16}, {40, 17}};
        tagValue[] tv = new tagValue[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            tv[i] = new tagValue(tags[i][0], tags[i][1]);
        }
        return tv;
    }

    public static String[] getAllFiles(File file) {
        File[] f = file.listFiles();
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < f.length; ++i) {
            if (f[i].isDirectory()) {
                String[] a = DemoFindFile.getAllFiles(f[i]);
                for (int k = 0; k < a.length; ++k) {
                    al.add(a[k]);
                }
                continue;
            }
            al.add(f[i].getAbsolutePath());
        }
        String[] strings = new String[al.size()];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = (String)al.get(i);
        }
        return strings;
    }

    public static void main(String[] args) {
        int i;
        String[] str = null;
        int noDicom = 0;
        if (args.length != 1) {
            System.out.println("Missing top-level directory or file name to parse");
            return;
        }
        File f = new File(args[0]);
        str = f.isDirectory() ? DemoFindFile.getAllFiles(f) : new String[]{f.getAbsolutePath()};
        System.out.println("searching " + str.length + " files ...");
        dicomParser dp = new dicomParser();
        tagValue[] tget = DemoFindFile.buildTagsToFind();
        System.out.println("SAMPLE... " + tget.length + " tags");
        long t1 = System.currentTimeMillis();
        for (i = 0; i < str.length; ++i) {
            try {
                dp.setFile(str[i]);
                dp.fill(tget);
                dp.clearFile();
                Object v1 = tget[0].value;
                Object v2 = tget[1].value;
                if (!(v1 instanceof Integer) || !(v2 instanceof Integer) || (Integer)v1 != 128 || (Integer)v2 != 128) continue;
                System.out.println(str[i]);
                continue;
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) {
                    ++noDicom;
                    continue;
                }
                System.out.println("file = " + str[i] + "(" + i + "/" + str.length + ")");
                ex.printStackTrace();
            }
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("Non dicom file = " + noDicom);
        System.out.println("parse errors   = " + noDicom);
        System.out.println("parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (double)t1 / (1.0 * (double)str.length) + " ms/file");
        tget = DemoFindFile.buildTagsToFind();
        System.out.println("DB  KEYS... " + tget.length + " tags");
        t1 = System.currentTimeMillis();
        for (i = 0; i < str.length; ++i) {
            try {
                dp.setFile(str[i]);
                dp.fill(tget);
                dp.clearFile();
                continue;
            }
            catch (FileNotFoundException ex) {
                System.out.println("file = " + str[i]);
                ex.printStackTrace();
            }
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (double)t1 / (1.0 * (double)str.length) + " ms/file");
        System.exit(0);
        System.out.println("full");
        int count = 0;
        int inFileCount = 0;
        t1 = System.currentTimeMillis();
        int i2 = 0;
        tagValue tag2 = null;
        try {
            for (i2 = 0; i2 < str.length; ++i2) {
                try {
                    System.gc();
                    dp.setFile(str[i2]);
                    inFileCount = 0;
                    while (dp.hasMoreTags()) {
                        tag2 = dp.readNext();
                        ++count;
                        ++inFileCount;
                    }
                    dp.clearFile();
                    continue;
                }
                catch (FileNotFoundException ex) {
                    System.out.println("file = " + str[i2]);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            System.err.println("crashed in reading " + i2 + " file= \"" + str[i2] + "\"");
            System.err.println("tag " + inFileCount + " = " + tag2);
            ex.printStackTrace();
        }
        t1 = System.currentTimeMillis() - t1;
        System.out.println("full parsing " + str.length + " files in " + (double)t1 / 1000.0 + " avg = " + (float)((double)t1 / (1.0 * (double)str.length)) + " ms/file");
        System.out.println("parsed " + count + " tags");
    }
}

