/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.dicom;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQueryUtil;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;

public class CreateRis {
    public static int[][] RIS_TAGS = new int[][]{{8, 5}, {8, 80}, {8, 128}, {8, 129}, {8, 130}, {8, 144}, {8, 146}, {8, 148}, {8, 4224}, {8, 4228}, {8, 4368}, {8, 4384}, {8, 4389}, {16, 16}, {16, 32}, {16, 33}, {16, 48}, {16, 50}, {16, 64}, {16, 80}, {16, 4096}, {16, 4097}, {16, 4101}, {16, 4112}, {16, 4128}, {16, 4144}, {16, 4160}, {16, 4192}, {16, 4224}, {16, 4225}, {16, 4240}, {16, 8192}, {16, 8464}, {16, 8528}, {16, 8530}, {16, 8532}, {16, 8544}, {16, 8576}, {16, 8608}, {16, 8624}, {16, 8640}, {16, 8656}, {16, 8688}, {16, 16384}, {32, 13}, {50, 10}, {50, 4146}, {50, 4147}, {50, 4192}, {50, 4196}, {56, 4}, {56, 8}, {56, 16}, {56, 17}, {56, 22}, {56, 32}, {56, 33}, {56, 80}, {56, 768}, {56, 1024}, {56, 1280}, {56, 16384}, {64, 256}, {64, 4097}, {64, 4098}, {64, 4099}, {64, 4100}, {64, 4101}, {64, 4104}, {64, 4105}, {64, 4112}, {64, 5120}, {64, 8193}, {64, 8196}, {64, 8197}, {64, 8200}, {64, 8201}, {64, 8208}, {64, 8214}, {64, 8215}, {64, 9216}, {64, 12289}};
    private static final int[][] REQ_RIS_TAGS = new int[][]{{8, 80}, {16, 16}, {16, 32}, {32, 13}, {50, 4192}, {64, 256}, {64, 4097}};
    private static Random rnd = new Random();

    private static String generateID() {
        int val = rnd.nextInt(100000000);
        String id = Integer.toString(val);
        return id;
    }

    private static DMElement[] getNotNull(DMElement[] des) {
        ArrayList<DMElement> deList = new ArrayList<DMElement>(des.length);
        for (int i = 0; i < des.length; ++i) {
            if (null == des[i].value) continue;
            deList.add(des[i]);
        }
        System.out.println("Found " + deList.size() + " non-null data elements");
        return deList.toArray(new DMElement[deList.size()]);
    }

    private static void checkForRequiredTags(DicomData data) {
        Object value = data.getValue(64, 256);
        if (null == value) {
            Object[] newValues = new Object[]{CreateRis.generateID(), "Patient^Name", CreateRis.generateID(), UidGenerator.newInstanceUID(), "Requested Procedure Description", CreateRis.getScheduledProcedureStepSequence(), CreateRis.generateID()};
            for (int i = 0; i < REQ_RIS_TAGS.length; ++i) {
                value = data.getValue(REQ_RIS_TAGS[i][0], REQ_RIS_TAGS[i][1]);
                if (null != value) continue;
                System.out.println("Creating " + tagValue.atToString(REQ_RIS_TAGS[i][0], REQ_RIS_TAGS[i][1]));
                data.setValue(REQ_RIS_TAGS[i][0], REQ_RIS_TAGS[i][1], newValues[i]);
            }
        }
    }

    private static DicomData getScheduledProcedureStepSequence() {
        String modality = "MR";
        String aetitle = "CreatedAET";
        Date datetime = new Date();
        String date = DMQueryUtil.DA_FORMAT.format(datetime);
        String time = DMQueryUtil.TM_FORMAT.format(datetime) + ".000";
        String spsdesc = "Scheduled Procedure Step Description";
        String spsid = CreateRis.generateID();
        DicomData data = new DicomData();
        data.setValue(8, 96, modality);
        data.setValue(64, 1, aetitle);
        data.setValue(64, 2, date);
        data.setValue(64, 3, time);
        data.setValue(64, 7, spsdesc);
        data.setValue(64, 9, spsid);
        return data;
    }

    private static void prepareToFill(tagValue[] des) {
        for (int i = 0; i < des.length; ++i) {
            des[i].prepareToFill();
        }
    }

    public static tagValue findDataElement(tagValue[] des, int group, int element) {
        for (int i = 0; i < des.length; ++i) {
            if (!des[i].is(group, element)) continue;
            return des[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String dstpath;
        String srcpath;
        String sessionType;
        String[] type = new String[]{"file", "file", "file", "file", "file", "pesi", "pesi", "file"};
        String[] src = new String[]{"d:/data/test/i18n", "d:/data/test/i18n/Unicode/i8390.CTDC.185.german", "d:/data/test/ModalityWorklist/13584605", "d:/data/test/ModalityWorklist/79363449", "d:/data/Knee/PA000000/ST000000/SE000007/IM000001", "v:/hartford", "d:/data/test/pesi", "d:/data/test/pesi/p197/e197/s050/MemIssue.dcm"};
        String dst = "d:/data/test/ModalityWorklist";
        int index = 0;
        if (null != args && 1 < args.length) {
            sessionType = args[0];
            srcpath = args[1];
            dstpath = args[2];
        } else {
            sessionType = type[index];
            srcpath = src[index];
            dstpath = dst;
        }
        File destdir = new File(dstpath);
        tagValue[] des = new DMElement[RIS_TAGS.length];
        for (int i = 0; i < des.length; ++i) {
            des[i] = new DMElement(RIS_TAGS[i][0], RIS_TAGS[i][1]);
        }
        DMSession dms = new DMSession(new String[]{sessionType, srcpath});
        DMObject[] dmo = dms.getRelated("study");
        FileOutputStream fos = null;
        for (int i = 0; i < dmo.length; ++i) {
            try {
                dmo[i].getValues((DMElement[])des);
                System.out.println(i + " --------------");
                System.out.println(dmo[i].getComposites()[0].getFilePath() + " " + CreateRis.findDataElement(des, 16, 16));
                DMElement[] ret = CreateRis.getNotNull((DMElement[])des);
                DicomData dd = new DicomData();
                dd.setValues(ret);
                CreateRis.checkForRequiredTags(dd);
                dd.printDebugInfo(System.out);
                fos = new FileOutputStream(File.createTempFile("ris", ".dcm", destdir));
                dd.write(fos, false);
                CreateRis.prepareToFill(des);
                fos.close();
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            finally {
                if (null != fos) {
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (IOException ioex) {}
                }
            }
        }
    }
}

