/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.MhPing;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.util.clientServer.event.XmSessionEvent;
import com.ge.med.terra.tap.util.clientServer.event.XmSessionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.net.ServerSocketFactory;

public class XmServer {
    public static int DEFAULT_PORT = 7483;
    public static final float VERSION = 1.0f;
    public static final short MAX_N_CLIENTS = 30000;
    public static final int CLIENT_TIMEOUT = 20000;
    public static final int DELAY_BETWEEN_FAILURES = 100;
    public static final int MAX_NUM_RETRIES = 5;
    private static final byte SESSION_ACCEPTING = 0;
    private static final byte SESSION_NEW = 1;
    private static final byte SESSION_REUSED = 2;
    private Vector listeners = new Vector();
    private Hashtable<Short, XmSession> sessionMap = new Hashtable();
    private static short count = 0;
    private static XmServer last;
    private ServerSocket serverSocket = null;
    private Thread serverThread;

    public static XmSession[] getAllSessions() {
        return XmServer.last.sessionMap.values().toArray(new XmSession[XmServer.last.sessionMap.size()]);
    }

    public XmServer(int port) {
        String startupMsg;
        last = this;
        try {
            ServerSocket ss = null;
            String fac = System.getProperty("tap.server.factory");
            if (fac != null) {
                try {
                    ServerSocketFactory f = (ServerSocketFactory)Class.forName(fac).newInstance();
                    ss = f.createServerSocket(port);
                    Tap.log.log(Level.INFO, "tap.server.factory=\"{0}\"", fac);
                }
                catch (InstantiationException e) {
                    System.err.println("Could not initialize class \"" + fac + "\"");
                    e.printStackTrace();
                    System.exit(0);
                }
                catch (IllegalAccessException e) {
                    System.err.println("Could not access class \"" + fac + "\"");
                    e.printStackTrace();
                    System.exit(0);
                }
                catch (ClassNotFoundException e) {
                    System.err.println("Could not find class \"" + fac + "\"");
                    e.printStackTrace();
                    System.exit(0);
                }
            } else {
                ss = new ServerSocket(port);
            }
            this.setupAccept(ss);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String bport = System.getProperty("tap.server.backport");
        if (bport != null) {
            Tap.log.log(Level.INFO, "tap.server.backport=\"{0}\"", bport);
            try {
                ServerSocket ss;
                if (bport.indexOf(":") > 0) {
                    URI uri = new URI("//" + bport);
                    ss = new ServerSocket(uri.getPort(), 0, InetAddress.getByName(uri.getHost()));
                    this.setupAccept(ss);
                } else {
                    int pnum = Integer.decode(bport);
                    ss = new ServerSocket(pnum);
                    this.setupAccept(ss);
                }
            }
            catch (Exception e) {
                System.err.println("-Dtap.server.backport=<ip>:<port>");
                System.err.println(e);
                System.exit(0);
            }
        }
        if (null != (startupMsg = System.getProperty("tap.server.startmsg")) && 0 < startupMsg.length()) {
            System.out.println(startupMsg);
            System.out.flush();
        }
    }

    public synchronized ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    private synchronized void setServerSocket(ServerSocket ss) {
        this.serverSocket = ss;
    }

    public void setupAccept(final ServerSocket ss) {
        this.setServerSocket(ss);
        String serverMsg = this.getClass().getSimpleName() + ": Process ID=" + XmServer.getPid() + ", Listening on port=" + ss.getLocalPort();
        System.out.println(serverMsg);
        System.out.flush();
        Thread acceptThread = new Thread(){

            @Override
            public void run() {
                int numRetries = 0;
                while (true) {
                    Socket socket;
                    Tap.log.info("Accepting client connections...");
                    try {
                        socket = ss.accept();
                    }
                    catch (IOException ioe) {
                        if (ss.isClosed()) {
                            throw new RuntimeException("Socket closed", ioe);
                        }
                        Tap.log.log(Level.WARNING, "Failure accepting client connection; will wait and try again: ", ioe);
                        if (++numRetries == Integer.getInteger("tap.server.serversocket.connection.failure.retry.total", 5)) {
                            throw new RuntimeException("Server Socket Accept: Max number retries reached", ioe);
                        }
                        try {
                            Thread.sleep(Integer.getInteger("tap.server.serversocket.connection.failure.retry.delay", 100).intValue());
                        }
                        catch (InterruptedException ie) {
                            Tap.log.log(Level.WARNING, "Failure during delay before accepting next client connection: ", ie);
                        }
                        continue;
                    }
                    numRetries = 0;
                    try {
                        try {
                            socket.setTcpNoDelay(true);
                        }
                        catch (SocketException sex) {
                            // empty catch block
                        }
                        int sessionType = 0;
                        XmSession xms = null;
                        byte[] buf = new byte[32];
                        try {
                            int oldTimeout = socket.getSoTimeout();
                            socket.setSoTimeout(Integer.getInteger("tap.server.connection.timeout", 20000));
                            Utils.readFully(socket.getInputStream(), buf);
                            socket.setSoTimeout(oldTimeout);
                        }
                        catch (SocketTimeoutException se) {
                            Tap.log.log(Level.INFO, "Socket time out, no inputs from client: ", se);
                            continue;
                        }
                        float version2 = Utils.getFloat(buf, 0);
                        short id = Utils.getShort(buf, 4);
                        boolean compress = Utils.getBoolean(buf, 6);
                        int clientType = Utils.getInt(buf, 7);
                        if (!XmServer.logConnection((byte)sessionType, version2, id, compress, clientType, socket.getInetAddress())) {
                            Tap.log.log(Level.SEVERE, "Closing session id={0} connection", String.valueOf(id));
                            socket.close();
                        }
                        if (id > 0) {
                            xms = (XmSession)XmServer.this.sessionMap.remove(id);
                            if (xms != null) {
                                sessionType = 2;
                                xms.compressed = compress;
                                Utils.putShort(buf, 0, id);
                                socket.getOutputStream().write(buf);
                                xms.reconnect(socket);
                                XmServer.this.sessionMap.put(id, xms);
                            } else {
                                socket.close();
                            }
                        }
                        if (xms == null) {
                            sessionType = 1;
                            id = XmServer.this.getClientID();
                            Utils.putShort(buf, 0, id);
                            socket.getOutputStream().write(buf);
                            xms = new XmSession(compress, socket, id, clientType);
                            XmServer.this.sessionMap.put(id, xms);
                            xms.setServer(XmServer.this);
                        }
                        XmServer.logConnection((byte)sessionType, version2, id, compress, clientType, socket.getInetAddress());
                        if (1 != sessionType) continue;
                        XmServer.this.fireConnectedEvent(xms);
                        continue;
                    }
                    catch (Exception ex) {
                        Tap.log.log(Level.WARNING, "Unable to connect to client: ", ex);
                        continue;
                    }
                    break;
                }
            }
        };
        acceptThread.setName(serverMsg);
        acceptThread.start();
        this.serverThread = acceptThread;
    }

    public boolean isListening() {
        return this.serverThread.isAlive();
    }

    boolean removeSession(XmSession xms) {
        boolean rv = true;
        if (null == this.sessionMap.remove(xms.getId())) {
            rv = false;
        } else {
            xms.setServer(null);
            this.fireClosedEvent(xms);
        }
        return rv;
    }

    private short getClientID() {
        short id;
        do {
            id = count = (short)(count + 1);
            if (count <= 30000) continue;
            count = 0;
        } while (this.sessionMap.containsKey(id));
        return id;
    }

    private static boolean logConnection(byte sessionType, float version2, short id, boolean compress, int clientType, InetAddress address) {
        boolean match;
        String msg;
        switch (sessionType) {
            case 0: {
                msg = "accepting";
                break;
            }
            case 1: {
                msg = "connect";
                break;
            }
            case 2: {
                msg = "reconnect";
                break;
            }
            default: {
                msg = "unknown";
            }
        }
        DecimalFormat format = new DecimalFormat("#0.00");
        String clientVersion = format.format(version2);
        Object[] params = new Object[]{msg, clientVersion, String.valueOf(id), String.valueOf(compress), String.valueOf(clientType), address};
        Tap.log.log(Level.INFO, "{0}|client ver={1}|id={2}|compress={3}|client type={4}|add={5}", params);
        boolean bl = match = 1.0f == version2;
        if (!match) {
            String serverVersion = format.format(1.0);
            Tap.log.log(Level.WARNING, "Client Version={0} is incompatible with Server Version={1}", new Object[]{clientVersion, serverVersion});
        }
        return match;
    }

    public void addClientListener(XmSessionListener listener) {
        this.listeners.add(listener);
    }

    public void removeClientListener(XmSessionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireConnectedEvent(XmSession xms) {
        byte newState = 1;
        if (Tap.log.isLoggable(Level.INFO)) {
            String stateName = XmSessionEvent.getStateName((byte)newState);
            Tap.log.log(Level.INFO, "Notifying listeners that session id={0} has {1}", new Object[]{String.valueOf(xms.getId()), stateName});
        }
        XmSessionEvent event = new XmSessionEvent(xms, null, 0, newState);
        for (XmSessionListener listener : this.listeners) {
            try {
                listener.connected(event);
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Session id=" + xms.getId() + " connected notification for " + listener + " failed due to: ", ex);
            }
        }
    }

    public void fireClosedEvent(XmSession xms) {
        byte newState = 0;
        if (Tap.log.isLoggable(Level.INFO)) {
            String stateName = XmSessionEvent.getStateName((byte)newState);
            Tap.log.log(Level.INFO, "Notifying listeners that session id={0} has {1}", new Object[]{String.valueOf(xms.getId()), stateName});
        }
        XmSessionEvent event = new XmSessionEvent(xms, null, 1, newState);
        for (XmSessionListener listener : this.listeners) {
            try {
                listener.closed(event);
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Session id=" + xms.getId() + " closed notification for " + listener + " failed due to: ", ex);
            }
        }
    }

    public static int getPid() {
        return SimpleUtilities.getProcessID();
    }

    public void sendPingThread(final XmSession xms, final short pingType, final int millisec) {
        Thread t = new Thread(){

            @Override
            public void run() {
                int k = 0;
                while (xms.socket != null) {
                    xms.writeMessage(new MhPing(pingType, "ping " + ++k));
                    try {
                        Thread.sleep(millisec);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return;
            }
        };
        t.setName("ping server");
        t.start();
    }

    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("-help")) {
            System.out.println(XmServer.class.getSimpleName() + ": usage:");
            System.out.println("\t-Dtap.server.factory=fully.qualified.classname - to set the server socket factory");
            System.out.println("\t-Dtap.server.port=nnnn - to set the main port number to listen on");
            System.out.println("\t-Dtap.server.backport=nnnn - to set a secondary port number to listen to");
            System.out.println("\t-Dtap.server.startmsg=\"message\" - to set an optional message to print when the server is up and running");
            System.out.println("\t-Dtap.server.connection.timeout=tttt - to set amount of time in ms to wait for a client connection to succeed");
            System.out.println("\t-Dtap.server.serversocket.connection.failure.retry.delay=dddd - to set amount of time in ms to wait before attempting to reestablish a failed client connection");
            System.out.println("\t-Dtap.server.serversocket.connection.failure.retry.total=rrrr - to set number of times to retry for a failed client connection");
        } else {
            int port = Integer.getInteger("tap.server.port", DEFAULT_PORT);
            XmServer xmServer = new XmServer(port);
        }
    }
}

