/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.clientServer.Ftp;
import com.ge.med.terra.tap.util.clientServer.RemoteObjectManager;
import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Random;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.AbstractTableModel;

public class StatusPanel
extends JPanel {
    JTable tab = new JTable();
    StatsModel model = new StatsModel();
    JTable tab2 = new JTable(){

        @Override
        public String getToolTipText(MouseEvent e) {
            int row = this.rowAtPoint(e.getPoint());
            String stack = StatusPanel.this.tmodel2.getStackFor(row);
            return stack;
        }
    };
    ThreadStatsModel tmodel2 = new ThreadStatsModel();
    XmSession xms;
    JLabel totalOutTxt;
    JLabel totalInTxt;
    JLabel packetOutTxt;
    JLabel packetInTxt;
    JLabel outQueTxt;
    Timer timer;
    RuntimeMXBean mxbean = ManagementFactory.getRuntimeMXBean();
    private static JFrame frame = null;

    public void setRun(boolean run) {
        if (run) {
            if (this.xms != null) {
                this.timer.start();
            }
            this.tmodel2.start();
        } else {
            this.timer.stop();
            this.tmodel2.stop();
        }
    }

    void updateModel() {
        long[] lastOut;
        long[] lastIn;
        Object[][] cell;
        this.totalOutTxt.setText(Long.toString(this.xms.writeCounter));
        this.totalInTxt.setText(Long.toString(this.xms.readCounter));
        this.outQueTxt.setText(Integer.toString(this.xms.msgQue.size()));
        this.packetInTxt.setText(Integer.toString(this.xms.writeMsgCounter));
        this.packetOutTxt.setText(Integer.toString(this.xms.readMsgCounter));
        XmService[] s = this.xms.services;
        boolean newTable = true;
        if (this.model.cell != null && this.model.cell.length == s.length) {
            cell = this.model.cell;
            lastIn = this.model.lastIn;
            lastOut = this.model.lastOut;
            newTable = false;
        } else {
            cell = new Object[s.length][6];
            lastIn = new long[s.length];
            lastOut = new long[s.length];
            if (this.model.cell != null) {
                System.arraycopy(this.model.lastIn, 0, lastIn, 0, this.model.lastIn.length);
                System.arraycopy(this.model.lastOut, 0, lastOut, 0, this.model.lastOut.length);
            }
        }
        for (int i = 0; i < s.length; ++i) {
            long in = this.xms.inBytes[i];
            long out = this.xms.outBytes[i];
            if (s[i] != null) {
                cell[i][0] = s[i].getClass().getName().substring(11);
                if (in - lastIn[i] > 0L) {
                    cell[i][0] = "<html><font COLOR=\"#FF0000\">" + cell[i][0];
                }
                XmServiceStatus ss = s[i].getStatus();
                Object object = cell[i][1] = ss != null ? ss.caller.substring(11) : "----";
                if (in - lastIn[i] > 0L) {
                    cell[i][1] = "<html><font COLOR=\"#FF0000\">" + cell[i][1];
                }
            } else {
                cell[i][0] = "-";
                cell[i][1] = "-";
            }
            cell[i][2] = new Long(in);
            cell[i][3] = new Long(out);
            cell[i][4] = new Long(in - lastIn[i]);
            cell[i][5] = new Long(out - lastOut[i]);
            lastIn[i] = in;
            lastOut[i] = out;
        }
        if (newTable) {
            this.model.cell = cell;
            this.model.lastIn = lastIn;
            this.model.lastOut = lastOut;
            int cc = this.tab.getColumnCount();
            for (int i = 0; i < cc; ++i) {
                this.tab.getColumnModel().getColumn(i).setPreferredWidth(this.model.getPreferedWidth(i));
            }
            this.model.fireTableStructureChanged();
        } else {
            this.model.fireTableDataChanged();
        }
    }

    public StatusPanel() {
        this.init();
    }

    public StatusPanel(XmSession xms) {
        this.init();
        this.setSession(xms);
    }

    public void setSession(XmSession xms) {
        this.xms = xms;
    }

    public void init() {
        this.tab.setModel(this.model);
        this.tab2.setModel(this.tmodel2);
        this.tab2.getTableHeader().setPreferredSize(new Dimension(60, 40));
        int cc = this.tab2.getColumnCount();
        for (int i = 0; i < cc; ++i) {
            this.tab2.getColumnModel().getColumn(i).setPreferredWidth(this.tmodel2.getPreferedWidth(i));
        }
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new GridLayout(3, 4));
        JLabel l1 = new JLabel("   Run:");
        l1.setHorizontalTextPosition(4);
        topPanel.add(l1);
        final JCheckBox cb = new JCheckBox();
        topPanel.add(cb);
        JLabel outQueLabel = new JLabel("   Out Bound Que Size:");
        outQueLabel.setHorizontalTextPosition(4);
        topPanel.add(outQueLabel);
        this.outQueTxt = new JLabel();
        Font bold = this.outQueTxt.getFont().deriveFont(1);
        this.outQueTxt.setFont(bold);
        topPanel.add(this.outQueTxt);
        JLabel totalOutLabel = new JLabel("   Total Bytes Out:");
        totalOutLabel.setHorizontalTextPosition(4);
        topPanel.add(totalOutLabel);
        this.totalOutTxt = new JLabel();
        this.totalOutTxt.setFont(bold);
        topPanel.add(this.totalOutTxt);
        JLabel totalInLabel = new JLabel("   Total Bytes Out:");
        totalInLabel.setHorizontalTextPosition(4);
        topPanel.add(totalInLabel);
        this.totalInTxt = new JLabel();
        this.totalInTxt.setFont(bold);
        topPanel.add(this.totalInTxt);
        JLabel packetOutLabel = new JLabel("   Total packets Out:");
        packetOutLabel.setHorizontalTextPosition(4);
        topPanel.add(packetOutLabel);
        this.packetOutTxt = new JLabel();
        this.packetOutTxt.setFont(bold);
        topPanel.add(this.packetOutTxt);
        JLabel packetInLabel = new JLabel("   Total packets Out:");
        packetInLabel.setHorizontalTextPosition(4);
        topPanel.add(packetInLabel);
        this.packetInTxt = new JLabel();
        this.packetInTxt.setFont(bold);
        topPanel.add(this.packetInTxt);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.setRun(cb.isSelected());
            }
        });
        JScrollPane pan = new JScrollPane(this.tab);
        JScrollPane pan2 = new JScrollPane(this.tab2);
        JSplitPane sp = new JSplitPane(0);
        sp.add((Component)pan, "bottom");
        sp.add((Component)pan2, "top");
        sp.setDividerLocation(0.5);
        sp.setResizeWeight(0.5);
        this.setLayout(new BorderLayout());
        this.add((Component)topPanel, "North");
        this.add((Component)sp, "Center");
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StatusPanel.this.updateModel();
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                StatusPanel.this.check();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
                Tap.log.fine("stop");
                StatusPanel.this.check();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                Tap.log.fine("start");
                StatusPanel.this.check();
            }
        });
    }

    public void check() {
    }

    public void dispose() {
    }

    public static void createFrame(XmSession xms, String str) {
        frame = new JFrame(str + ":" + xms.getHostAddress());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width /= 3;
        d.height /= 3;
        frame.setBounds(d.height, d.height, d.width, d.height);
        StatusPanel p = new StatusPanel(xms);
        frame.setContentPane(p);
        frame.setDefaultCloseOperation(3);
        frame.validate();
        frame.setVisible(true);
    }

    public static void destroyFrame() {
        if (null != frame) {
            frame.dispose();
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("tank");
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        d.width /= 3;
        d.height /= 3;
        f.setBounds(d.height, d.height, d.width, d.height);
        final XmSession xms = SimpleUtilities.startServer();
        StatusPanel p = new StatusPanel(xms);
        f.setContentPane(p);
        f.validate();
        JButton b = new JButton("Exit");
        p.add((Component)b, "South");
        ActionListener act = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleUtilities.endServer(xms);
                SimpleUtilities.sleep(2000L);
                Thread[] t = new Thread[1000];
                ThreadGroup tg = Thread.currentThread().getThreadGroup();
                while (tg.getParent() != null) {
                    tg = tg.getParent();
                }
                tg.enumerate(t);
                for (int i = 0; i < t.length && t[i] != null; ++i) {
                    System.err.println("Thread: " + t[i]);
                }
                System.err.println("============================testFileTransfer======================================");
                System.err.flush();
                System.exit(0);
            }
        };
        b.addActionListener(act);
        f.setDefaultCloseOperation(0);
        f.setVisible(true);
        f.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                System.err.println(e);
            }
        });
        Thread t = new Thread(){

            @Override
            public void run() {
                StatusPanel.ssleep(1000);
                StatusPanel.testFileTransfer(xms);
                StatusPanel.ssleep(1000);
                RemoteObjectManager rom = new RemoteObjectManager(xms);
                for (int i = 0; i < 1000; ++i) {
                    StatusPanel.ssleep(500);
                    Object o = rom.callStaticRMethod(System.class.getName(), "currentTimeMillis", new Object[0]);
                    System.out.println(">" + o);
                }
            }
        };
        t.start();
    }

    private static void ssleep(int v) {
        try {
            Thread.sleep(v);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testFileTransfer(XmSession xms) {
        FileOutputStream fos = null;
        FileInputStream fis = null;
        try {
            File f = File.createTempFile("ftpTest", "txt");
            byte[] data = new byte[1024];
            Random r = new Random();
            r.nextBytes(data);
            fos = new FileOutputStream(f);
            for (int i = 0; i < 1024; ++i) {
                fos.write(data);
            }
            Ftp ftp = new Ftp(xms);
            ftp.putFile(f.getAbsolutePath(), f.getAbsolutePath() + "2");
            File f2 = new File(f.getAbsolutePath() + "2");
            if (f.length() != f2.length()) {
                throw new RuntimeException("file should be same length" + f.length() + " = " + f2.length());
            }
            byte[] data2 = new byte[data.length];
            fis = new FileInputStream(f2);
            for (int i = 0; i < 1024; ++i) {
                int n;
                for (int gotten = 0; gotten < data2.length; gotten += n) {
                    n = fis.read(data2, gotten, data2.length - gotten);
                    if (n >= 0) continue;
                    throw new IOException("error in reading file " + f2);
                }
                for (int j = 0; j < data2.length; ++j) {
                    if (data2[i] == data[i]) continue;
                    throw new RuntimeException("data should be the same" + data2[i] + " = " + data[i]);
                }
            }
            f2.delete();
            f.delete();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    class StatsModel
    extends AbstractTableModel {
        Object[][] cell;
        long[] lastIn;
        long[] lastOut;
        String[] names = new String[]{"name", "caller", "Total in", "Total Out", "delta in", "delta out"};
        final int[] width = new int[]{600, 600, 100, 100, 100, 100};

        StatsModel() {
        }

        public int getPreferedWidth(int col) {
            if (col < this.width.length) {
                return this.width[col];
            }
            return 100;
        }

        public Class getColumnClass(int columnIndex) {
            return this.cell[0][columnIndex].getClass();
        }

        @Override
        public int getColumnCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell[0].length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.names[columnIndex];
        }

        @Override
        public int getRowCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.cell[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    class ThreadStatsModel
    extends AbstractTableModel {
        ThreadMXBean b = ManagementFactory.getThreadMXBean();
        Object[][] cell = new Object[0][0];
        long[] all;
        HashMap old = new HashMap();
        Timer timer;
        final int[] width = new int[]{40, 300, 150, 100, 100, 100, 100, 100, 40, 100, 100, 40, 100, 40};
        String[] names = new String[]{"id", "name", "state", "CPU Time", "<html>delta<br>CPU", "User Time", "<html>delta<br>User", "<html>Block<br>Count", "<html>Block<br>Time", "Lock name", "<html>Lock owner<br>id", "Lock owner name", "<html>no<br>waits", "wait time"};

        public void start() {
            this.timer.start();
        }

        public void stop() {
            this.timer.stop();
        }

        public ThreadStatsModel() {
            this.timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ThreadStatsModel.this.update();
                }
            });
        }

        public int getPreferedWidth(int col) {
            if (col < this.width.length) {
                return this.width[col];
            }
            return 100;
        }

        public String getStackFor(int row) {
            if (this.all == null) {
                return "";
            }
            Tap.log.fine("call getStackFor");
            ThreadInfo inf = this.b.getThreadInfo(this.all[row], 100);
            StackTraceElement[] stack = inf.getStackTrace();
            String str = "<html>";
            for (int i = 0; i < stack.length; ++i) {
                str = str + stack[i].toString() + "<br>";
            }
            str = str + "</html>";
            return str;
        }

        public void update() {
            this.all = this.b.getAllThreadIds();
            this.cell = new Object[this.all.length][this.names.length];
            for (int i = 0; i < this.all.length; ++i) {
                long[] oldVal;
                int k = 0;
                Long id = new Long(this.all[i]);
                if (this.old.containsKey(id)) {
                    oldVal = (long[])this.old.get(id);
                } else {
                    oldVal = new long[2];
                    this.old.put(id, oldVal);
                }
                this.cell[i][k++] = id;
                ThreadInfo inf = this.b.getThreadInfo(this.all[i], 0);
                long cpu = this.b.getThreadCpuTime(this.all[i]);
                long dcpu = cpu - oldVal[0];
                oldVal[0] = cpu;
                long usr = this.b.getThreadUserTime(this.all[i]);
                long dusr = usr - oldVal[1];
                oldVal[1] = usr;
                this.cell[i][k++] = dcpu == 0L && dusr == 0L ? inf.getThreadName() : "<html><font COLOR=\"#FF0000\">" + inf.getThreadName();
                this.cell[i][k++] = inf.getThreadState().name();
                this.cell[i][k++] = new Long(cpu / 1000L);
                this.cell[i][k++] = new Long(dcpu / 1000L);
                this.cell[i][k++] = new Long(usr / 1000L);
                this.cell[i][k++] = new Long(dusr / 1000L);
                this.cell[i][k++] = new Long(inf.getBlockedCount());
                this.cell[i][k++] = new Long(inf.getBlockedTime());
                this.cell[i][k++] = inf.getLockName();
                this.cell[i][k++] = new Long(inf.getLockOwnerId());
                this.cell[i][k++] = inf.getLockOwnerName();
                this.cell[i][k++] = new Long(inf.getWaitedCount());
                this.cell[i][k++] = new Long(inf.getWaitedTime());
            }
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int columnIndex) {
            if (this.cell.length == 0) {
                return Object.class;
            }
            try {
                return this.cell[0][columnIndex].getClass();
            }
            catch (Exception e) {
                return Object.class;
            }
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.names[columnIndex];
        }

        @Override
        public int getRowCount() {
            if (this.cell == null) {
                return 0;
            }
            return this.cell.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.cell[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

