/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.clientServer.SyncManager;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;

public class RemoteObjectManager {
    XmOService xos = new XmOService();

    public RemoteObjectManager(XmSession xms) {
        xms.installHandle(this.xos);
    }

    public short getID() {
        return this.xos.getID();
    }

    public XmServiceStatus getStatus() {
        return this.xos.getStatus();
    }

    public boolean isClosed() {
        return this.xos.isClosed();
    }

    public void close() {
        this.xos.close();
    }

    public Object createProxyObject(Class interfaceClass, String className, Object[] constructorArguments) {
        final int id = this.createObject(className, constructorArguments);
        InvocationHandler handler = new InvocationHandler(){
            int oid;
            {
                this.oid = id;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return RemoteObjectManager.this.callRemoteMethod(this.oid, method.getName(), args);
            }
        };
        Class<?> proxyClass = Proxy.getProxyClass(interfaceClass.getClassLoader(), interfaceClass);
        try {
            return proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int createObject(Class c, Object[] arguments) {
        return this.createObject(c.getName(), arguments);
    }

    public int createObject(String className, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m = new Msg(1, tid, new Object[]{className, arguments});
        this.xos.sendMessage(m);
        Object k = this.xos.sman.waitForResponse(2001, tid);
        if (k instanceof Exception) {
            throw new RuntimeException((Exception)k);
        }
        return (Integer)k;
    }

    public Object callRemoteMethod(int ObjectId, String method, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m = new Msg(2, tid, new Object[]{new Integer(ObjectId), method, arguments});
        this.xos.sendMessage(m);
        Object o = this.xos.sman.waitForResponse(2002, tid);
        if ("null01".equals(o)) {
            return null;
        }
        if (o instanceof Exception) {
            throw new RuntimeException((Exception)o);
        }
        return o;
    }

    public Object callRemoteMethod(int ObjectId, String method, Object[] arguments, Class[] param) {
        int tid = this.xos.sman.newTid();
        Msg m = new Msg(2, tid, new Object[]{new Integer(ObjectId), method, arguments, param});
        this.xos.sendMessage(m);
        Object o = this.xos.sman.waitForResponse(2002, tid);
        if ("null01".equals(o)) {
            return null;
        }
        if (o instanceof Exception) {
            throw new RuntimeException((Exception)o);
        }
        return o;
    }

    public Object callStaticRMethod(String className, String method, Object[] arguments) {
        int tid = this.xos.sman.newTid();
        Msg m = new Msg(3, tid, new Object[]{className, method, arguments});
        this.xos.sendMessage(m);
        Object o = this.xos.sman.waitForResponse(2003, tid);
        if ("null01".equals(o)) {
            return null;
        }
        if (o instanceof Exception) {
            throw new RuntimeException((Exception)o);
        }
        return o;
    }

    public Object callStaticRMethod(String className, String method, Object[] arguments, Class[] param) {
        int tid = this.xos.sman.newTid();
        Msg m = new Msg(3, tid, new Object[]{className, method, arguments, param});
        this.xos.sendMessage(m);
        Object o = this.xos.sman.waitForResponse(2003, tid);
        if ("null01".equals(o)) {
            return null;
        }
        if (o instanceof Exception) {
            throw new RuntimeException((Exception)o);
        }
        return o;
    }

    static class MsgQue {
        Vector mQue = new Vector();
        boolean destroy = false;

        MsgQue() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addMsg(Msg msg) {
            Vector vector = this.mQue;
            synchronized (vector) {
                this.mQue.add(msg);
                this.mQue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            this.destroy = true;
            Vector vector = this.mQue;
            synchronized (vector) {
                this.mQue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Msg getMsg() {
            Vector vector = this.mQue;
            synchronized (vector) {
                while (this.mQue.isEmpty() && !this.destroy) {
                    try {
                        this.mQue.wait();
                    }
                    catch (InterruptedException e) {
                        if (!this.destroy) continue;
                        return null;
                    }
                }
                if (this.destroy) {
                    return null;
                }
                return (Msg)this.mQue.remove(0);
            }
        }
    }

    static class Msg {
        private int type;
        private int tid;
        private Object ldata;

        public Object getData() {
            return this.ldata;
        }

        public Msg(int type, int tid, Object data) {
            this.type = type;
            this.tid = tid;
            this.ldata = data;
        }

        public Msg() {
        }

        public Msg(byte[] buff) {
            ByteArrayInputStream bais = new ByteArrayInputStream(buff);
            try {
                ObjectInputStream o = new ObjectInputStream(bais);
                this.type = o.readInt();
                this.tid = o.readInt();
                this.ldata = o.readObject();
                if (this.ldata instanceof String && ((String)this.ldata).equals("null01")) {
                    this.ldata = null;
                }
            }
            catch (ClassNotFoundException ex1) {
                ex1.printStackTrace();
            }
            catch (IOException ex1) {
                ex1.printStackTrace();
            }
        }

        public final byte[] toByteArray() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeInt(this.type);
                oos.writeInt(this.tid);
                if (this.ldata == null) {
                    oos.writeObject("null01");
                } else {
                    oos.writeObject(this.ldata);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray();
        }
    }

    static class XmOService
    extends XmServiceAdapter {
        public static final int RSP = 2000;
        public static final int CREATE_OBJECT = 1;
        public static final int CALL_METHOD = 2;
        public static final int CALL_STATIC_METHOD = 3;
        private static int tcount = 1;
        XmServiceStatus status;
        XmSession xms;
        SyncManager sman = new SyncManager();
        boolean server = true;
        HashMap objTable = new HashMap();
        Vector out = new Vector();
        byte[] readBytes = new byte[4];
        MsgQue readQue = new MsgQue();
        private Object lock = new Object();

        public XmOService() {
            this.status = new XmServiceStatus();
            this.setupReaderThread();
        }

        @Override
        public void setParent(XmSession client) {
            this.xms = client;
            this.server = !client.isClient();
        }

        private void readAll(InputStream is, byte[] buff) throws IOException {
            int n;
            int off = 0;
            do {
                if ((n = is.read(buff, off, buff.length - off)) >= 0) continue;
                throw new RuntimeException("unable to read " + buff.length);
            } while ((off += n) < buff.length);
        }

        @Override
        public int readMessage(InputStream is) throws IOException {
            this.readAll(is, this.readBytes);
            int len = Utils.getInt(this.readBytes, 0);
            byte[] data = new byte[len];
            this.readAll(is, data);
            Msg m = new Msg(data);
            this.readQue.addMsg(m);
            return this.readBytes.length + len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isClosed() {
            Object object = this.lock;
            synchronized (object) {
                return null == this.xms.getHandle(this.getID());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.xms.uninstallHandle(this.getID());
            }
        }

        @Override
        public void connectionLost() {
            Tap.log.log(Level.INFO, "Connection lost with service type {0}", Short.toString(this.getID()));
            this.readQue.destroy();
        }

        public void setupReaderThread() {
            Thread t = new Thread(){

                @Override
                public void run() {
                    Msg m;
                    while ((m = XmOService.this.readQue.getMsg()) != null) {
                        if (m.type > 2000) {
                            XmOService.this.sman.sendResponse(m.type, m.tid, m.getData());
                            continue;
                        }
                        XmOService.this.processMessage(m);
                    }
                    return;
                }
            };
            t.setDaemon(true);
            t.setName("RemoteObjectManager:233");
            t.start();
        }

        public void processMessage(Msg m) {
            try {
                switch (m.type) {
                    case 1: {
                        Integer nid = new Integer(++tcount);
                        Object[] v = (Object[])m.getData();
                        Object[] args = (Object[])v[1];
                        String cname = (String)v[0];
                        Class[] ptype = args == null ? new Class[]{} : new Class[args.length];
                        for (int i = 0; i < ptype.length; ++i) {
                            ptype[i] = args[i].getClass();
                        }
                        Class<?> c = Class.forName(cname);
                        Object o = c.getConstructor(ptype).newInstance(args);
                        this.objTable.put(nid, o);
                        this.sendMessage(new Msg(2000 + m.type, m.tid, nid));
                        return;
                    }
                    case 2: {
                        Object[] v = (Object[])m.getData();
                        Integer objectID = (Integer)v[0];
                        String methodName = (String)v[1];
                        Object[] args = (Object[])v[2];
                        Method met = null;
                        Object o = this.objTable.get(objectID);
                        if (args != null) {
                            Class[] ptype;
                            if (v.length == 4) {
                                ptype = (Class[])v[3];
                            } else {
                                ptype = new Class[args.length];
                                for (int i = 0; i < ptype.length; ++i) {
                                    ptype[i] = args[i].getClass();
                                }
                            }
                            try {
                                met = o.getClass().getMethod(methodName, ptype);
                            }
                            catch (NoSuchMethodException e) {
                                Method[] methods = o.getClass().getMethods();
                                for (int i = 0; i < methods.length; ++i) {
                                    Class<?>[] c;
                                    if (!methodName.equals(methods[i].getName()) || (c = methods[i].getParameterTypes()).length != ptype.length) continue;
                                    met = methods[i];
                                }
                            }
                        } else {
                            met = o.getClass().getMethod(methodName, null);
                        }
                        Object ret = met.invoke(o, args);
                        this.sendMessage(new Msg(2000 + m.type, m.tid, ret));
                        return;
                    }
                    case 3: {
                        Object[] v = (Object[])m.getData();
                        String className = (String)v[0];
                        String methodName = (String)v[1];
                        Object[] args = (Object[])v[2];
                        Method met = null;
                        if (args != null) {
                            Class[] ptype;
                            if (v.length == 4) {
                                ptype = (Class[])v[3];
                            } else {
                                ptype = new Class[args.length];
                                for (int i = 0; i < ptype.length; ++i) {
                                    ptype[i] = args[i].getClass();
                                }
                            }
                            met = Class.forName(className).getMethod(methodName, ptype);
                        } else {
                            met = Class.forName(className).getMethod(methodName, null);
                        }
                        Object ret = met.invoke(null, args);
                        this.sendMessage(new Msg(2000 + m.type, m.tid, ret));
                        return;
                    }
                }
                this.sendMessage(new Msg(2000 + m.type, m.tid, new RuntimeException("unknown command")));
            }
            catch (Exception ex) {
                this.sendMessage(new Msg(2000 + m.type, m.tid, ex));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendMessage(Msg m) {
            Object object = this.lock;
            synchronized (object) {
                final byte[] msg = m.toByteArray();
                final byte[] lenBytes = new byte[4];
                Utils.putInt(lenBytes, 0, msg.length);
                XmServiceAdapter s = new XmServiceAdapter(){

                    @Override
                    public short getID() {
                        return XmOService.this.getID();
                    }

                    @Override
                    public int writeMessage(OutputStream os, short mid) throws IOException {
                        os.write(lenBytes);
                        os.write(msg);
                        return lenBytes.length + msg.length;
                    }
                };
                this.xms.writeMessage(s);
            }
        }

        public static int objectSize(Object o) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(o);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return baos.toByteArray().length;
        }

        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            return 0;
        }

        @Override
        public XmServiceStatus getStatus() {
            return this.status;
        }
    }
}

