/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.util.clientServer.XmService;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class MhConnectStats
implements XmService {
    private XmSession client;
    private byte[] buff = new byte[32768];
    private final boolean debug = false;
    private ByteBuffer bb = ByteBuffer.wrap(this.buff);
    private short type;
    private String stats;
    private static MhConnectStats theOne;

    public MhConnectStats() {
        theOne = this;
    }

    @Override
    public void setID(short type) {
        this.type = type;
    }

    @Override
    public short getID() {
        return this.type;
    }

    @Override
    public void setParent(XmSession client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStats(XmSession c) {
        if (theOne == null) {
            String msg = "Must create instance of " + MhConnectStats.class.getSimpleName() + " to initialize service";
            return msg;
        }
        MhConnectStats.theOne.stats = null;
        c.writeMessage(theOne);
        MhConnectStats mhConnectStats = theOne;
        synchronized (mhConnectStats) {
            while (MhConnectStats.theOne.stats == null) {
                try {
                    theOne.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return MhConnectStats.theOne.stats;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readMessage(InputStream is) throws IOException {
        int r;
        int amtread = 0;
        while ((amtread += (r = is.read(this.buff))) < this.buff.length) {
        }
        if (this.client.client) {
            long now = System.currentTimeMillis();
            this.bb.position(0);
            long orig = this.bb.getLong();
            float time = (float)(now - orig) / 1000.0f;
            this.stats = "sent " + this.buff.length + " in " + time + " ms = " + (float)this.buff.length / time / 1000.0f + " KB/s";
            MhConnectStats mhConnectStats = this;
            synchronized (mhConnectStats) {
                this.notifyAll();
            }
        } else {
            System.out.println("sending message");
            this.client.writeMessage(this);
        }
        return this.buff.length;
    }

    @Override
    public int writeMessage(OutputStream is, short mid) throws IOException {
        if (this.client.client) {
            this.bb.position(0);
            this.bb.putLong(System.currentTimeMillis());
        }
        is.write(this.buff);
        return this.buff.length;
    }

    @Override
    public void connectionLost() {
    }

    @Override
    public XmServiceStatus getStatus() {
        return null;
    }

    public static final void main(String[] args) {
        XmSession xms = new XmSession("localhost", 7483);
        MhConnectStats stats = new MhConnectStats();
        xms.installHandle(stats);
        System.out.println(MhConnectStats.getStats(xms));
        xms.close();
    }
}

