/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util.clientServer;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.clientServer.Utils;
import com.ge.med.terra.tap.util.clientServer.XmServiceAdapter;
import com.ge.med.terra.tap.util.clientServer.XmServiceStatus;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;

public class Ftp {
    FtpService ftps = new FtpService();
    public static int packetSize = 4096;
    XmSession xms;
    static long kps;

    public Ftp(XmSession xms) {
        this.xms = xms;
        xms.installHandle(this.ftps);
    }

    public void getFile(String src, String dest) {
        String str = "send\n" + src + "\n" + dest;
        final byte[] lenBuff = new byte[4];
        final byte[] dataBuff = Utils.objectToBytes(str);
        Utils.putInt(lenBuff, 0, dataBuff.length);
        this.xms.writeMessage(new XmServiceAdapter(){

            @Override
            public short getID() {
                return Ftp.this.ftps.getID();
            }

            @Override
            public int writeMessage(OutputStream os, short mid) throws IOException {
                os.write(lenBuff);
                os.write(dataBuff);
                return dataBuff.length + 4;
            }
        });
        try {
            this.ftps.waitForFile(dest);
        }
        catch (InterruptedException iex) {
            throw new CancellationException("Transfer for file [" + src + "] was interrupted.");
        }
    }

    public void putFile(String src, String dest) {
        try {
            FtpSend fs = new FtpSend(this.ftps, this.ftps.parent, src, dest);
            fs.prepareToWaitForFileSend(src);
            this.ftps.enQue(fs);
            fs.waitForPreparedFileSend(src);
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException("Source file [" + src + "] must exist.");
        }
        catch (InterruptedException iex) {
            throw new CancellationException("Transfer for file [" + src + "] was interrupted.");
        }
    }

    public static long getKps() {
        return kps;
    }

    static class PerfTimer {
        private static final double NANO_TO_SEC = 1.0E-9;
        private long last = System.nanoTime();

        PerfTimer() {
        }

        public void start() {
            this.last = System.nanoTime();
        }

        public double getTimeInSeconds() {
            long now = System.nanoTime();
            double ret = (double)(now - this.last) * 1.0E-9;
            this.last = System.nanoTime();
            return ret;
        }
    }

    static class FtpService
    extends XmServiceAdapter {
        XmSession parent;
        int len;
        FileChannel fc;
        RandomAccessFile raf;
        MappedByteBuffer mbb;
        byte[] lenBuff = new byte[4];
        byte[] readBuff = new byte[packetSize];
        String name;
        Vector sendQue = new Vector();
        boolean sending;
        long totalBytes;
        PerfTimer timer = new PerfTimer();
        HashSet waitingOn = new HashSet();

        FtpService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enQue(FtpSend f) {
            Vector vector = this.sendQue;
            synchronized (vector) {
                this.sendQue.add(f);
            }
            this.sendOne();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void sendOne() {
            if (this.sending) {
                return;
            }
            FtpSend f = null;
            Vector vector = this.sendQue;
            synchronized (vector) {
                if (!this.sendQue.isEmpty()) {
                    f = (FtpSend)this.sendQue.remove(0);
                }
            }
            if (f != null) {
                this.sending = true;
                f.send();
            }
        }

        @Override
        public void setParent(XmSession parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int readMessage(InputStream is) throws IOException {
            Utils.readFully(is, this.lenBuff);
            this.len = Utils.getInt(this.lenBuff, 0);
            Utils.readFully(is, this.readBuff, 0, this.len);
            if (this.mbb == null) {
                String s = (String)Utils.bytesToObject(this.readBuff);
                String[] sp = s.split("\n");
                if ("send".equals(sp[0])) {
                    FtpSend f = new FtpSend(this, this.parent, sp[1], sp[2]);
                    this.enQue(f);
                }
                if ("recv".equals(sp[0])) {
                    Tap.log.log(Level.FINER, "Activating full bandwidth mode for FTP");
                    this.parent.setFullBandwidth(true);
                    this.name = sp[1];
                    this.raf = new RandomAccessFile(this.name, "rw");
                    int flen = Integer.parseInt(sp[2]);
                    this.raf.setLength(flen);
                    this.fc = this.raf.getChannel();
                    this.mbb = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, flen);
                    this.totalBytes = 0L;
                    this.timer.start();
                }
            } else {
                this.mbb.put(this.readBuff, 0, this.len);
                this.totalBytes += (long)(this.len + 4);
                if (this.len != packetSize) {
                    double time = this.timer.getTimeInSeconds();
                    long value = (long)((double)this.totalBytes / time / 1024.0);
                    kps = kps == 0L ? value : (4L * kps + value) / 5L;
                    this.fc.close();
                    this.raf.close();
                    this.waitingOn.remove(this.name);
                    HashSet hashSet = this.waitingOn;
                    synchronized (hashSet) {
                        this.waitingOn.notifyAll();
                    }
                    this.mbb = null;
                    Tap.log.log(Level.FINER, "Deactivating full bandwidth mode for FTP");
                    this.parent.setFullBandwidth(false);
                }
            }
            return this.len + 4;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFile(String name) throws InterruptedException {
            this.waitingOn.add(name);
            HashSet hashSet = this.waitingOn;
            synchronized (hashSet) {
                while (this.waitingOn.contains(name)) {
                    this.waitingOn.wait(60000L);
                }
            }
        }
    }

    static class FtpSend
    extends XmServiceAdapter {
        XmServiceStatus status;
        int delta = Integer.MAX_VALUE;
        MappedByteBuffer mbb;
        RandomAccessFile raf;
        FileChannel fc;
        byte[] dataBuff = new byte[packetSize + 4];
        int len;
        short headMid = (short)-1;
        short currMid = (short)-1;
        short tailMid = (short)-1;
        int rewindCount = 0;
        XmSession xms;
        String recv;
        ArrayList midList;
        String name;
        FtpService ftps;
        HashSet sendFileSet = new HashSet();

        public FtpSend(FtpService ftps, XmSession xms, String send, String recv) throws IOException {
            this.status = new XmServiceStatus();
            this.ftps = ftps;
            this.recv = recv;
            this.xms = xms;
            this.name = send;
            this.raf = new RandomAccessFile(this.name, "r");
            this.len = (int)this.raf.length();
            this.fc = this.raf.getChannel();
            this.mbb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.len);
        }

        @Override
        public XmServiceStatus getStatus() {
            return this.status;
        }

        public void send() {
            this.xms.writeMessage(this);
        }

        @Override
        public short getID() {
            return this.ftps.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int writeMessage(OutputStream os, short mid) throws IOException {
            int index;
            if (this.recv != null) {
                String str = "recv\n" + this.recv + "\n" + this.len;
                this.midList = new ArrayList(Math.round(this.len / packetSize));
                byte[] data = Utils.objectToBytes(str);
                byte[] lenBuff = new byte[4];
                Utils.putInt(lenBuff, 0, data.length);
                os.write(lenBuff);
                os.write(data);
                this.recv = null;
                Utils.putInt(this.dataBuff, 0, packetSize);
                this.xms.writeMessage(this);
                return data.length + 4;
            }
            this.currMid = mid;
            if (this.headMid < 0) {
                this.headMid = this.currMid;
            }
            if (this.headMid <= this.tailMid && this.tailMid >= this.currMid && (index = this.midList.indexOf(new Short(this.currMid))) >= 0) {
                if (this.mbb == null) {
                    Utils.putInt(this.dataBuff, 0, packetSize);
                    this.ftps.sending = true;
                    this.raf = new RandomAccessFile(this.name, "r");
                    this.len = (int)this.raf.length();
                    this.fc = this.raf.getChannel();
                    this.mbb = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, this.len);
                }
                int pos = index * packetSize;
                this.mbb.position(pos);
                this.rewindCount += this.midList.size() - index;
                while (this.midList.size() != index) {
                    this.midList.remove(index);
                }
            }
            if (this.mbb.position() + packetSize <= this.len) {
                this.mbb.get(this.dataBuff, 4, packetSize);
                try {
                    os.write(this.dataBuff);
                }
                catch (IOException e) {
                    throw e;
                }
                finally {
                    this.midList.add(new Short(this.currMid));
                    this.tailMid = this.currMid;
                    if (this.rewindCount == 0) {
                        this.xms.writeMessage(this);
                    } else {
                        --this.rewindCount;
                    }
                }
                return this.dataBuff.length;
            }
            int left = this.len - this.mbb.position();
            Utils.putInt(this.dataBuff, 0, left);
            this.mbb.get(this.dataBuff, 4, left);
            os.write(this.dataBuff, 0, left + 4);
            this.ftps.sending = false;
            this.ftps.sendOne();
            this.raf.close();
            this.fc.close();
            this.mbb = null;
            HashSet hashSet = this.sendFileSet;
            synchronized (hashSet) {
                this.sendFileSet.remove(this.name);
                this.sendFileSet.notifyAll();
            }
            return left;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void prepareToWaitForFileSend(String name) {
            HashSet hashSet = this.sendFileSet;
            synchronized (hashSet) {
                this.sendFileSet.add(name);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitForPreparedFileSend(String name) throws InterruptedException {
            HashSet hashSet = this.sendFileSet;
            synchronized (hashSet) {
                while (this.sendFileSet.contains(name)) {
                    this.sendFileSet.wait(60000L);
                }
            }
        }
    }
}

