/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.util;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.SimpleUtilitiesBase;
import com.ge.med.terra.tap.util.clientServer.RemoteObjectManager;
import com.ge.med.terra.tap.util.clientServer.XmSession;
import com.ge.med.terra.tap.version;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;

public class SimpleUtilities
extends SimpleUtilitiesBase {
    private static Vector debugInfo = new Vector();

    public static void addDebugInfoNotify(Runnable r) {
        debugInfo.add(r);
    }

    public static void removeDebugInfoNotify(Runnable r) {
        debugInfo.remove(r);
    }

    public static void generateDebugInfo() {
        Iterator i = debugInfo.iterator();
        while (i.hasNext()) {
            ((Runnable)i.next()).run();
        }
    }

    public static String getLineSeparator() {
        String sep;
        try {
            sep = System.getProperty("line.separator");
        }
        catch (Exception ex) {
            sep = "\n";
        }
        return sep;
    }

    public static String getTempDir() {
        try {
            return System.getProperty("java.io.tmpdir");
        }
        catch (Exception e) {
            return "/tmp";
        }
    }

    public static String[] cmdArgsToSessionArgs(String[] args) {
        if (args.length == 1 && args[0].indexOf(",") > 0) {
            return SimpleUtilities.cmdArgsToSessionArgs(args[0].split("\\,"));
        }
        String[] ret = new String[args.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = args[i].equalsIgnoreCase("null") ? null : (args[i].startsWith("\"") && args[i].endsWith("\"") ? args[i].substring(1, args[i].length() - 1) : args[i]);
        }
        return ret;
    }

    public static void copyFile(String src, String dest) {
        try {
            FileInputStream fis = new FileInputStream(src);
            SimpleUtilities.copyFile(fis, dest);
            fis.close();
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to copy " + src + " to " + dest, e);
            Tap.log.throwing(SimpleUtilities.class.getName(), "copyFile", e);
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(InputStream src, String dest) {
        FileOutputStream fos = null;
        try {
            byte[] bbuff = new byte[32768];
            File newfile = new File(dest);
            if (!newfile.exists()) {
                newfile.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(dest);
            int len = 1;
            while (len != -1) {
                len = src.read(bbuff);
                if (len <= 0) continue;
                fos.write(bbuff, 0, len);
            }
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to copy to " + dest, e);
            Tap.log.throwing(SimpleUtilities.class.getName(), "copyFile", e);
            throw new RuntimeException(e);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static File[] getFilesRecursively(File rootDir) {
        ArrayList<File> arr = new ArrayList<File>();
        if (!rootDir.isDirectory()) {
            return new File[]{rootDir};
        }
        File[] list = rootDir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                File[] temp = SimpleUtilities.getFilesRecursively(list[i]);
                for (int x = 0; x < temp.length; ++x) {
                    arr.add(temp[x]);
                }
                continue;
            }
            arr.add(list[i]);
        }
        return arr.toArray(new File[0]);
    }

    public static File[] getFilesRecursively(String[] files) {
        File[] f = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            f[i] = new File(files[i]);
        }
        return SimpleUtilities.getFilesRecursively(f);
    }

    public static File[] getFilesRecursively(File[] files) {
        Vector<File> vect = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            vect.addAll(Arrays.asList(SimpleUtilities.getFilesRecursively(files[i])));
        }
        File[] actualFiles = new File[vect.size()];
        for (int i = 0; i < actualFiles.length; ++i) {
            actualFiles[i] = (File)vect.get(i);
        }
        return actualFiles;
    }

    public static Class<?> loadClassFromLoader(String className, ClassLoader cl) throws ClassNotFoundException {
        Class<?> c = null;
        c = cl == null ? Class.forName(className) : cl.loadClass(className);
        return c;
    }

    public static void byteSwap(byte[] b) {
        for (int i = 0; i < b.length - 1; i += 2) {
            byte temp = b[i + 1];
            b[i + 1] = b[i];
            b[i] = temp;
        }
    }

    public static byte[] shortToByte(short[] s) {
        return SimpleUtilities.shortToByte(s, true);
    }

    public static byte[] shortToByte(short[] s, boolean BE) {
        byte[] b = new byte[s.length * 2];
        if (BE) {
            for (int i = 0; i < s.length; ++i) {
                b[2 * i] = (byte)(s[i] & 0xFF);
                b[2 * i + 1] = (byte)(s[i] >> 8 & 0xFF);
            }
        } else {
            for (int i = 0; i < s.length; ++i) {
                b[2 * i] = (byte)(s[i] >> 8 & 0xFF);
                b[2 * i + 1] = (byte)(s[i] & 0xFF);
            }
        }
        return b;
    }

    public static short[] bytesToShort(byte[] b, boolean BE) {
        short[] s = new short[b.length / 2];
        if (BE) {
            for (int i = 0; i < s.length; ++i) {
                int tmp = i << 1;
                s[i] = (short)((b[tmp] & 0xFF) << 8 | b[tmp + 1] & 0xFF);
            }
        } else {
            for (int i = 0; i < s.length; ++i) {
                int tmp = i << 1;
                s[i] = (short)((b[tmp + 1] & 0xFF) << 8 | b[tmp] & 0xFF);
            }
        }
        return s;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean deleteFilesRecursively(File root) {
        boolean flag = true;
        File[] children = root.listFiles();
        if (children == null || children.length == 0) {
            flag = flag && root.delete();
            return flag;
        }
        for (int i = 0; i < children.length; ++i) {
            flag = flag && SimpleUtilities.deleteFilesRecursively(children[i]);
        }
        flag = flag && root.delete();
        return flag;
    }

    public static int getPID() throws IOException, NumberFormatException {
        return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
    }

    public static int getProcessID() {
        int pid = SimpleUtilities.getProcessIDFromName();
        if (0 == pid) {
            pid = SimpleUtilities.getProcessIDAndroid();
        }
        return pid;
    }

    public static int getProcessIDFromName() {
        String processName = "";
        try {
            Method method1 = Class.forName("java.lang.management.ManagementFactory").getMethod("getRuntimeMXBean", null);
            Method method2 = Class.forName("java.lang.management.RuntimeMXBean").getMethod("getName", null);
            Object bean = method1.invoke(null, (Object[])null);
            processName = (String)method2.invoke(bean, (Object[])null);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to determine JVM process ID: ", ex);
        }
        Pattern pattern = Pattern.compile("^([0-9]+)@.+$", 2);
        Matcher matcher = pattern.matcher(processName);
        int pid = 0;
        if (matcher.matches()) {
            pid = Integer.parseInt(matcher.group(1));
        }
        return pid;
    }

    public static int getProcessIDAndroid() {
        int pid = 0;
        try {
            Method method = Class.forName("android.os.Process").getMethod("myTid", null);
            pid = (Integer)method.invoke(null, (Object[])null);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to determine process ID: ", ex);
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileFromURL(URLConnection urlConn, File destFile) throws IOException, MalformedURLException {
        byte[] buff = new byte[32768];
        InputStream is = urlConn.getInputStream();
        try (FileOutputStream os = new FileOutputStream(destFile.getAbsolutePath());){
            int n;
            while ((n = is.read(buff)) >= 0) {
                ((OutputStream)os).write(buff, 0, n);
            }
        }
    }

    public static boolean runWithMoreMemory(int mem, String[] args, String[] jvmargs) {
        int i;
        if (args == null) {
            args = new String[]{};
        }
        if (jvmargs == null) {
            jvmargs = new String[]{};
        }
        String cp = System.getProperty("java.class.path");
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaw";
        Runtime run = Runtime.getRuntime();
        int max = (int)(run.maxMemory() / 0x100000L) + 1;
        if (max + 64 >= mem) {
            return false;
        }
        String classname = new Exception().getStackTrace()[1].getClassName();
        ArrayList<String> al = new ArrayList<String>(6 + args.length + jvmargs.length);
        al.add(java);
        al.add("-Xmx" + mem + "m");
        for (i = 0; i < jvmargs.length; ++i) {
            al.add(jvmargs[i]);
        }
        al.add("-cp");
        al.add(cp);
        for (i = 0; i < args.length; ++i) {
            al.add(args[i]);
        }
        al.add(classname);
        String[] str = al.toArray(new String[al.size()]);
        try {
            Process p = Runtime.getRuntime().exec(str);
            SimpleUtilities.map(System.err, p.getErrorStream(), true);
            SimpleUtilities.map(System.out, p.getInputStream(), true);
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to execute command: ", ex);
        }
        return true;
    }

    public static void callStaticInNewJVM(Method m, String[] args) {
        if (!Modifier.isStatic(m.getModifiers())) {
            throw new IllegalArgumentException(m + " must be static");
        }
        if (args == null) {
            args = new String[]{};
        }
        String[] allargs = new String[args.length + 2];
        allargs[0] = m.getDeclaringClass().getName();
        allargs[1] = m.getName();
        System.arraycopy(args, 0, allargs, 2, args.length);
        try {
            Process p = SimpleUtilities.callInNewJVM(new String[0], SimpleUtilities.class.getName(), allargs);
            SimpleUtilities.map(System.err, p.getErrorStream());
            SimpleUtilities.map(System.out, p.getInputStream());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void callInNewJVM(Method m) {
        String cp = System.getProperty("java.class.path");
        String[] args = new String[]{m.getClass().getName(), m.getName()};
        try {
            Process p = SimpleUtilities.callInNewJVM(cp, new String[0], SimpleUtilities.class.getName(), args);
            SimpleUtilities.map(System.err, p.getErrorStream(), true);
            p.waitFor();
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to run method in new JVM: ", e);
        }
    }

    public static void callInNewJVMAndWait(String classPath, String[] jvmArgs, String className, String[] cmdArgs) throws IOException, InterruptedException {
        Process p = SimpleUtilities.callInNewJVM(classPath, jvmArgs, className, cmdArgs);
        SimpleUtilities.map(System.err, p.getErrorStream());
        SimpleUtilities.map(System.out, p.getInputStream());
        p.waitFor();
    }

    public static Process callInNewJVM(String classPath, String[] jvmArgs, String className, String[] args) throws IOException {
        String[] cmdStr = SimpleUtilities.buildExecStrings(classPath, jvmArgs, className, args);
        return Runtime.getRuntime().exec(cmdStr);
    }

    public static Process callInNewJVM(String[] jvmArgs, String className, String[] args) throws IOException {
        String[] str = SimpleUtilities.buildExecStrings(jvmArgs, className, args);
        return Runtime.getRuntime().exec(str);
    }

    public static String[] buildExecStrings(String[] jvmArgs, String className, String[] args) {
        String cp = System.getProperty("java.class.path");
        return SimpleUtilities.buildExecStrings(cp, jvmArgs, className, args);
    }

    public static String[] buildExecStrings(String classPath, String[] jvmArgs, String className, String[] args) {
        int i;
        String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList<String> al = new ArrayList<String>();
        al.add(java);
        if (jvmArgs != null) {
            for (i = 0; i < jvmArgs.length; ++i) {
                al.add(jvmArgs[i]);
            }
        }
        if (System.getProperty("java.vm.name").contains("Server")) {
            al.add("-server");
        }
        al.add("-classpath");
        al.add(classPath);
        al.add(className);
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                al.add(args[i]);
            }
        }
        String[] cmdStr = al.toArray(new String[al.size()]);
        return cmdStr;
    }

    public static void map(OutputStream os, InputStream is) {
        SimpleUtilities.map(os, is, false);
    }

    public static void map(final OutputStream os, final InputStream is, final boolean exitOnBreak) {
        Thread t = new Thread(){

            @Override
            public void run() {
                byte[] buff = new byte[32768];
                try {
                    int n;
                    while ((n = is.read(buff)) >= 0) {
                        os.write(buff, 0, n);
                    }
                }
                catch (IOException ex) {
                    if (exitOnBreak) {
                        System.exit(0);
                    }
                    Tap.log.log(Level.WARNING, "Unable to read from the input stream: ", ex);
                }
            }
        };
        t.setName("SimpleUtilies:map(exitOnBreak=" + exitOnBreak + ")");
        t.start();
    }

    public static void main(String[] args) {
        Tap.setLogLevel(Level.WARNING);
        System.setOut(System.err);
        String className = args[0];
        String method = args[1];
        Object[] ret = new Object[1];
        try {
            Class<?> c = Class.forName(className);
            Method[] m = c.getMethods();
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getName().equals(method) || !Modifier.isStatic(m[i].getModifiers())) continue;
                if (m[i].getParameterTypes().length == 1) {
                    if (m[i].getParameterTypes()[0].equals(String[].class)) {
                        String[] newArgs = new String[args.length - 2];
                        System.arraycopy(args, 2, newArgs, 0, newArgs.length);
                        ret[0] = m[i].invoke(null, new Object[]{newArgs});
                    }
                    if (m[i].getParameterTypes()[0].equals(String.class)) {
                        ret[0] = m[i].invoke(null, args[2]);
                    }
                } else if (m[i].getParameterTypes().length == 0) {
                    ret[0] = m[i].invoke(null, new Object[0]);
                }
                break;
            }
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Error during execution of main(): ", e);
        }
    }

    public static Method getStaticMethod(String name) {
        Throwable t = new Throwable();
        try {
            Class<?> c = Class.forName(t.getStackTrace()[1].getClassName());
            return c.getMethod(name, null);
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to get static method: ", e);
            return null;
        }
    }

    public static String execReturnStr(String[] cmd) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            StreamToString is = new StreamToString(p.getInputStream());
            p.waitFor();
            return is.toString();
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to execute command: ", ex);
            return null;
        }
    }

    public static void launchWebBrowser(String theUrl) {
        String cmdLine = "start " + theUrl;
        cmdLine = "cmd.exe /c " + cmdLine;
        try {
            Process p = Runtime.getRuntime().exec(cmdLine);
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Unable to launch web browser: ", e);
        }
    }

    public static XmSession startServer() {
        try {
            SimpleUtilities.callStaticInNewJVM(SimpleUtilities.getStaticMethod("server_runServer"), null);
            SimpleUtilities.sleep(500L);
        }
        catch (RuntimeException e) {
            Tap.log.log(Level.WARNING, "Unable to start server in separate JVM: ", e);
        }
        XmSession xms = new XmSession("localhost", 7483);
        SimpleUtilities.sleep(1000L);
        return xms;
    }

    public static void endServer(XmSession xms) {
        RemoteObjectManager rom = new RemoteObjectManager(xms);
        rom.callStaticRMethod(SimpleUtilities.class.getName(), "server_exitInSecond", new Object[0], new Class[0]);
        xms.close();
        SimpleUtilities.sleep(1000L);
    }

    public static int server_exitInSecond() {
        Thread t = new Thread(){

            @Override
            public void run() {
                SimpleUtilities.sleep(1000L);
                System.exit(0);
                Tap.log.warning("JVM running server did not exit!");
            }
        };
        t.start();
        return 1;
    }

    public static void dumpSystemInfo() {
        SimpleUtilities.logSystemInfo(null);
    }

    public static void logSystemInfo(Logger logger) {
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer(1024);
        try {
            buffer.append(SimpleUtilities.tab("JVM Process ID") + " = " + SimpleUtilities.getProcessID() + LINE_SEPARATOR);
            Properties p = System.getProperties();
            Object[] keys = new String[p.size()];
            Enumeration<Object> e = p.keys();
            String[] remove = new String[]{"java.class.path", "file.separator", "java.library.path", "java.specification.name", "java.specification.vendor", "line.separator", "sun.boot.class.path"};
            HashSet<String> rset = new HashSet<String>(Arrays.asList(remove));
            int i = 0;
            while (e.hasMoreElements()) {
                keys[i++] = (String)e.nextElement();
            }
            Arrays.sort(keys);
            for (int j = 0; j < keys.length; ++j) {
                if (rset.contains(keys[j])) continue;
                String value = (String)p.get(keys[j]);
                buffer.append(SimpleUtilities.tab((String)keys[j]) + " = \"" + value + "\"" + LINE_SEPARATOR);
            }
            Runtime r = Runtime.getRuntime();
            int ncpu = r.availableProcessors();
            buffer.append(SimpleUtilities.tab("Number Of cores") + " = " + ncpu + LINE_SEPARATOR);
            long free = r.freeMemory();
            buffer.append(SimpleUtilities.tab("freeMemory") + " = " + (float)(free / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            long max = r.maxMemory();
            buffer.append(SimpleUtilities.tab("maxMemory") + " = " + (float)(max / 1024L) / 1024.0f + "MB" + LINE_SEPARATOR);
            InetAddress ip = InetAddress.getLocalHost();
            buffer.append(SimpleUtilities.tab("HostName") + " = " + ip.getCanonicalHostName() + LINE_SEPARATOR);
            buffer.append(SimpleUtilities.tab("HostAddress") + " = " + ip.getHostAddress() + LINE_SEPARATOR);
            buffer.append(SimpleUtilities.tab("Creation Time") + " = " + new Date(SimpleUtilities.getCreationTime()) + LINE_SEPARATOR);
            version v = version.getVersion();
            buffer.append(SimpleUtilities.tab("TAP version") + " = " + v.getVersionString() + LINE_SEPARATOR);
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            buffer.append(SimpleUtilities.tab("TAP build date") + " = " + df.parse(v.getBuildDate()) + LINE_SEPARATOR);
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Error while dumping system properties: ", e);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin System Information" + LINE_SEPARATOR);
            buffer.append("INFO: End System Information" + LINE_SEPARATOR);
        }
        if (null == logger) {
            System.out.print(buffer.toString());
        } else {
            logger.info(buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCreationTime() {
        String subFile = SimpleUtilities.class.getName().replace('.', File.separatorChar) + ".class";
        String s = System.getProperty("java.class.path");
        String[] sp = s.split(File.pathSeparator);
        for (int i = 0; i < sp.length; ++i) {
            File f = new File(sp[i]);
            if (f.isDirectory()) {
                File path = new File(f, subFile);
                if (!path.exists()) continue;
                return path.lastModified();
            }
            JarFile zf = null;
            try {
                long time;
                zf = new JarFile(f);
                ZipEntry ze = zf.getEntry(SimpleUtilities.class.getName().replace('.', '/') + ".class");
                if (null == ze) continue;
                long l = time = ze.getTime();
                return l;
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Unable to load JAR file " + f.getAbsolutePath(), ioex);
                continue;
            }
            finally {
                if (null != zf) {
                    try {
                        zf.close();
                    }
                    catch (IOException ioex) {}
                }
            }
        }
        return -1L;
    }

    private static String tab(String s) {
        int l = s.length() / 8;
        String tabs = "\t\t\t";
        if ("\t\t\t".length() > l) {
            return s + "\t\t\t".substring(l);
        }
        return s + "\t";
    }

    public static void listThreads(PrintStream out) {
        if (out == null) {
            out = System.out;
        }
        try {
            ThreadGroup g = Thread.currentThread().getThreadGroup();
            while (g.getParent() != null) {
                g = g.getParent();
            }
            Thread[] t = new Thread[1024];
            int len = g.enumerate(t, true);
            for (int i = 0; i < len; ++i) {
                out.println("[debug] [" + i + "]  " + t[i].getName() + " " + t[i]);
                StackTraceElement[] st = t[i].getStackTrace();
                for (int j = 0; j < st.length; ++j) {
                    out.println("[debug]  at " + st[j].getClassName() + "." + st[j].getMethodName() + "(" + st[j].getFileName() + ":" + st[j].getLineNumber() + ")");
                }
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Unable to list threads in given stream: ", ex);
        }
    }

    public static File creatRandomFile(String prefix, String suffix, int lengthKB, long seed) {
        FileOutputStream fos = null;
        try {
            File f = File.createTempFile(prefix, suffix);
            byte[] data = new byte[1024];
            Random r = new Random(seed);
            r.nextBytes(data);
            fos = new FileOutputStream(f);
            for (int i = 0; i < lengthKB; ++i) {
                fos.write(data);
            }
            File file = f;
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static void compareFiles(String file1, String file2) throws IOException {
        byte[] data1 = new byte[1024];
        byte[] data2 = new byte[1024];
        File fd1 = new File(file1);
        File fd2 = new File(file2);
        if (fd1.length() != fd2.length()) {
            System.out.println("file lengths differ " + fd1.length() + " != " + fd2.length());
        }
        FileInputStream fs1 = new FileInputStream(file1);
        FileInputStream fs2 = new FileInputStream(file2);
        try {
            long off = 0L;
            while (true) {
                int i;
                int r2;
                int r1;
                if ((r1 = fs1.read(data1)) != (r2 = fs2.read(data2))) {
                    return;
                }
                if (r1 == -1 || r2 == -1) {
                    return;
                }
                boolean same = true;
                for (i = 0; i < r1; ++i) {
                    if (data1[i] == data2[i]) continue;
                    same = false;
                }
                if (!same) {
                    String s;
                    System.out.println("bytes not the same starting at offset = " + off);
                    for (i = 0; i < r1; ++i) {
                        s = "0" + Integer.toHexString(data1[i]);
                        s = s.substring(s.length() - 2);
                        if (i % 4 == 0) {
                            s = " " + s;
                        }
                        System.out.print(s);
                    }
                    System.out.println();
                    for (i = 0; i < r1; ++i) {
                        s = "0" + Integer.toHexString(data2[i]);
                        s = s.substring(s.length() - 2);
                        if (i % 4 == 0) {
                            s = " " + s;
                        }
                        System.out.print(s);
                    }
                    System.out.println("\n");
                    return;
                }
                off += (long)r1;
            }
        }
        finally {
            fs1.close();
            fs2.close();
        }
    }

    public static void verifyRandomFile(String file, int lengthKB, long seed) {
        FileInputStream fis = null;
        try {
            byte[] data = new byte[1024];
            byte[] data2 = new byte[1024];
            Random r = new Random(seed);
            r.nextBytes(data);
            File f = new File(file);
            if (f.length() != (long)(lengthKB * 1024)) {
                throw new RuntimeException("file of wrong length");
            }
            fis = new FileInputStream(file);
            for (int i = 0; i < lengthKB; ++i) {
                int n;
                for (int gotten = 0; gotten < data2.length; gotten += n) {
                    n = fis.read(data2, gotten, data2.length - gotten);
                    if (n >= 0) continue;
                    throw new IOException("error in reading file ");
                }
                for (int j = 0; j < data2.length; ++j) {
                    if (data2[i] == data[i]) continue;
                    throw new RuntimeException("file of bytes starting at " + (i * 1024 + j));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {}
            }
        }
    }

    public static void loadSystemProperties(String baseName) {
        ResourceBundle systemProperties = ResourceBundle.getBundle(baseName);
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer();
        Enumeration<String> e = systemProperties.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (null != System.getProperty(key)) continue;
            String val = systemProperties.getString(key);
            buffer.append("\t" + key + " = \"" + val + "\"" + LINE_SEPARATOR);
            System.setProperty(key, val);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin Loaded System Properties" + LINE_SEPARATOR);
            buffer.append("INFO: End Loaded System Properties");
            Tap.log.info(buffer.toString());
        }
    }

    public static void loadSystemProperties(Properties properties) {
        String LINE_SEPARATOR = SimpleUtilities.getLineSeparator();
        StringBuffer buffer = new StringBuffer();
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (null != System.getProperty(key)) continue;
            String val = properties.getProperty(key);
            buffer.append("\t" + key + " = \"" + val + "\"" + LINE_SEPARATOR);
            System.setProperty(key, val);
        }
        if (0 < buffer.length()) {
            buffer.insert(0, "Begin Loaded System Properties" + LINE_SEPARATOR);
            buffer.append("INFO: End Loaded System Properties");
            Tap.log.info(buffer.toString());
        }
    }

    public static Properties getProperties(InputStream propstream, String property) {
        return SimpleUtilities.getProperties(propstream, property, false);
    }

    public static Properties getPropertiesCreate(InputStream propstream, String property) {
        return SimpleUtilities.getProperties(propstream, property, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(InputStream propstream, String property, boolean createFile) {
        Properties props = new Properties();
        FileInputStream cfgstream = null;
        FileOutputStream fos = null;
        try {
            String config;
            if (null != propstream) {
                props.load(propstream);
            }
            if ((config = System.getProperties().getProperty(property)) != null) {
                if (new File(config).exists()) {
                    cfgstream = new FileInputStream(config);
                    props.load(cfgstream);
                } else if (createFile) {
                    fos = new FileOutputStream(config);
                    props.store(fos, SimpleUtilities.class.getName());
                }
            }
        }
        catch (IOException ioex) {
            Tap.log.log(Level.WARNING, "Unable to load properties: ", ioex);
        }
        finally {
            if (null != cfgstream) {
                try {
                    cfgstream.close();
                }
                catch (IOException ioex) {}
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ioex) {}
            }
        }
        return props;
    }
}

