/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dmui.table;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peerutils.Util;
import com.ge.med.terra.tap.dmui.table.DmuFormatterAdapter;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.logging.Level;

public class DmuFormatDA
extends DmuFormatterAdapter {
    public static final SimpleDateFormat DA_FORMAT_PARSE = new SimpleDateFormat("yyyyMMdd");
    protected String tagStr = "(0x0010,0x0030)";
    protected Comparator<DMObject> datecomp = new Comparator<DMObject>(){

        @Override
        public int compare(DMObject dmo1, DMObject dmo2) {
            if (dmo1 == null) {
                return 1;
            }
            if (dmo2 == null) {
                return -1;
            }
            String s1 = DmuFormatDA.getDAValue(dmo1, DmuFormatDA.this.tagStr);
            String s2 = DmuFormatDA.getDAValue(dmo2, DmuFormatDA.this.tagStr);
            Date d1 = null;
            Date d2 = null;
            try {
                if (s1 != null) {
                    d1 = DA_FORMAT_PARSE.parse(s1);
                }
            }
            catch (ParseException ex) {
                Tap.log.log(Level.WARNING, "s1=" + s1, ex);
            }
            try {
                if (s2 != null) {
                    d2 = DA_FORMAT_PARSE.parse(s2);
                }
            }
            catch (ParseException ex) {
                Tap.log.log(Level.WARNING, "s2=" + s2, ex);
            }
            if (d1 == null) {
                if (d2 == null) {
                    return 0;
                }
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return d1.compareTo(d2);
        }
    };

    public DmuFormatDA() {
    }

    public DmuFormatDA(String str) {
        this.tagStr = str;
    }

    @Override
    public String getName() {
        return "DA Formatter";
    }

    @Override
    public int getPreferredWidth() {
        return 50;
    }

    @Override
    public Comparator<DMObject> getComparator() {
        return this.datecomp;
    }

    @Override
    public DMTag[] getNeededTags() {
        String[] tagStrs = Util.breakupString(this.tagStr);
        ArrayList<DMTag> tags = new ArrayList<DMTag>(tagStrs.length);
        for (int i = 0; i < tagStrs.length; ++i) {
            if ((i & 1) != 0) continue;
            tags.add(DMTag.parseTagString(tagStrs[i]));
        }
        return tags.toArray(new DMTag[tags.size()]);
    }

    public static String getDAValue(DMTagValueInterface tagValIF, String tagStr) {
        String value = (String)Util.getValue(tagValIF, tagStr);
        if (null != value) {
            value = value.replaceAll("\\.", "");
        }
        return value;
    }

    @Override
    public Object getValue(DMTagValueInterface tagValIF) {
        String daStr = "";
        String str = DmuFormatDA.getDAValue(tagValIF, this.tagStr);
        if (str != null) {
            try {
                Date date = DA_FORMAT_PARSE.parse(str);
                daStr = DateFormat.getDateInstance(1).format(date);
            }
            catch (ParseException ex) {
                daStr = str;
            }
        }
        return daStr;
    }

    @Override
    public String getToolTip(DMTagValueInterface tagValIF) {
        String exchangeFormat = null;
        if (null != tagValIF) {
            exchangeFormat = (String)Util.getValue(tagValIF, this.tagStr);
        }
        return exchangeFormat;
    }
}

