/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.volume.GSIDataUtil;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.List;
import java.util.Map;

public class MultiChannelDataSupport {
    public static final String SINGLE_CHANNEL_TYPE = "Single Channel";
    public static final String MULTI_CHANNEL_TYPE = "Multi Channel";
    public static final String SINGLE_CHANNEL_NAME = "Pixel Data";
    private ChannelInfo[] channels;
    private String multiChannelType;

    public MultiChannelDataSupport(DMTagValueInterface dmTagValue) {
        this.channels = GSIDataUtil.buildChannelInfo(dmTagValue);
        if (null == this.channels) {
            this.channels = new ChannelInfo[]{new ChannelInfo()};
            this.channels[0].channelName = SINGLE_CHANNEL_NAME;
        }
        this.multiChannelType = (String)GSIDataUtil.getGSIImageType(dmTagValue);
        if (null == this.multiChannelType) {
            this.multiChannelType = this.getNumChannels() > 1 ? MULTI_CHANNEL_TYPE : SINGLE_CHANNEL_TYPE;
        }
    }

    public ChannelInfo[] getChannels() {
        return this.channels;
    }

    public ChannelInfo getChannel(int channel) {
        return this.channels[channel];
    }

    public int getNumChannels() {
        return this.channels.length;
    }

    public String getMultiChannelType() {
        return this.multiChannelType;
    }

    public String getChannelName(int channel) {
        return this.channels[channel].channelName;
    }

    public Object getVSliceValue(int channel, int slice, int group, int element) {
        Map<String, DMTag> tagMap = this.channels[channel].tagMap;
        if (null == tagMap) {
            return this.channels[channel].slices[slice].dmc.getValue(group, element);
        }
        String tagQuery = tagValue.atToString(group, element);
        DMTag tag2 = tagMap.get(tagQuery);
        Object value = tag2 == null ? this.channels[channel].slices[slice].dmc.getValue(group, element) : this.channels[channel].slices[slice].dmc.getValue(tag2.getGroup(), tag2.getElement());
        return value;
    }

    public void getVSliceValues(int channel, int slice, DMElement[] dme) {
        this.channels[channel].slices[slice].dmc.getValues(dme);
    }

    public long getVSliceOffset(int channel, int slice) {
        return this.channels[channel].slices[slice].offset;
    }

    public String getVSlicePath(int channel, int slice) {
        return this.channels[channel].slices[slice].filename;
    }

    public List<DMTag> getMultiChannelTags() {
        return GSIDataUtil.getMultiChannelTags();
    }

    public DMElement loadChannelDataTag(int channel, DMElement[] tags, DMComposite comp) {
        DMElement channelDataTag;
        if (0 == channel) {
            channelDataTag = tags[tags.length - 1];
        } else {
            Map<String, DMTag> tagMap = this.channels[channel].tagMap;
            DMTag tag2 = tagMap.get(tagValue.atToString(32736, 16));
            channelDataTag = new DMElement(tag2.getGroup(), tag2.getElement());
            channelDataTag.setFillValue(false);
            comp.getValues(new DMElement[]{channelDataTag});
        }
        return channelDataTag;
    }

    public XjTagValue loadChannelDataTag(int channel, XjTagValue[] tags, XjDicomObject comp) {
        XjTagValue channelDataTag;
        if (0 == channel) {
            channelDataTag = tags[tags.length - 1];
        } else {
            Map<String, DMTag> tagMap = this.channels[channel].tagMap;
            DMTag tag2 = tagMap.get(tagValue.atToString(32736, 16));
            channelDataTag = new XjTagValue(tag2.getGroup(), tag2.getElement());
            channelDataTag.noValue = true;
            comp.getValues(new XjTagValue[]{channelDataTag});
        }
        return channelDataTag;
    }

    public static class ChannelInfo {
        public String channelName;
        public Map<String, DMTag> tagMap;
        public Slice[] slices;
    }

    public static class Slice {
        public double[] topLeft = new double[3];
        public DMComposite dmc;
        public int sliceNo;
        public String filename;
        public long offset;
    }
}

