/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.volume;

import com.ge.med.idc.XjDicomObject;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.volume.MultiChannelDataSupport;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class GSIDataUtil {
    public static final DMTag GSIImageType = new DMTag(83, 4211);
    public static final DMTag CPData = new DMTag(32736, 16);
    public static final DMTag CPMonoEnergy = new DMTag(83, 4213);
    public static final DMTag MD1Intercept = new DMTag(83, 4242);
    public static final DMTag MD1Slope = new DMTag(83, 4243);
    public static final DMTag MD1Data = new DMTag(83, 4245);
    public static final DMTag NM1Data = new DMTag(83, 4247);
    public static final DMTag MD2Intercept = new DMTag(83, 4248);
    public static final DMTag MD2Slope = new DMTag(83, 4249);
    public static final DMTag MD2Data = new DMTag(83, 4246);
    public static final DMTag NM2Data = new DMTag(83, 4250);
    public static final String CP = "Cover Page";
    public static final String MD1 = "Material Density 1 (water / iodine image)";
    public static final String MD2 = "Material Density 2 (iodine / water image)";
    public static final String NM1 = "Noise Map 1";
    public static final String NM2 = "Noise Map 2";
    public static final String MONOCHROMATIC_IMAGE_TYPE_A = "Monochromatic";
    public static final String MONOCHROMATIC_IMAGE_TYPE_B = "MONO";
    public static final String MATERIAL_DENSITY_IMAGE_TYPE = "Material Density";
    public static final String EFFECTIVE_Z_IMAGE_TYPE = "Effective-Z";
    public static final String COLOR_OVERLAY_IMAGE_TYPE = "Color Overlay";
    public static final String QC_IMAGE_TYPE = "QC";
    private static List<DMTag> mchannelTags = null;

    private GSIDataUtil() {
    }

    public static Object getGSIImageType(DMTagValueInterface dmTagValue) {
        return dmTagValue.getValue(GSIImageType);
    }

    public static Object getGSIImageType(XjDicomObject xjObject) {
        return xjObject.getValue(GSIImageType.getGroup(), GSIImageType.getElement());
    }

    public static boolean isGSI(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.getGSIImageType(dmTagValue) != null;
    }

    public static boolean isGSI(XjDicomObject xjObject) {
        return GSIDataUtil.getGSIImageType(xjObject) != null;
    }

    public static boolean isGSIImageType(DMTagValueInterface dmTagValue, String imageType) {
        Object imageTypeObj = GSIDataUtil.getGSIImageType(dmTagValue);
        return imageTypeObj instanceof String && ((String)imageTypeObj).equalsIgnoreCase(imageType);
    }

    public static boolean isGSIImageType(XjDicomObject xjObject, String imageType) {
        Object imageTypeObj = GSIDataUtil.getGSIImageType(xjObject);
        return imageTypeObj instanceof String && ((String)imageTypeObj).equalsIgnoreCase(imageType);
    }

    public static boolean isMonochromatic(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.isGSIImageType(dmTagValue, MONOCHROMATIC_IMAGE_TYPE_A) || GSIDataUtil.isGSIImageType(dmTagValue, MONOCHROMATIC_IMAGE_TYPE_B);
    }

    public static boolean isMonochromatic(XjDicomObject xjObject) {
        return GSIDataUtil.isGSIImageType(xjObject, MONOCHROMATIC_IMAGE_TYPE_A) || GSIDataUtil.isGSIImageType(xjObject, MONOCHROMATIC_IMAGE_TYPE_B);
    }

    public static boolean isGSIDataFile(DMTagValueInterface dmTagValue) {
        if (GSIDataUtil.isMonochromatic(dmTagValue)) {
            Object slope1 = dmTagValue.getValue(MD1Slope);
            Object slope2 = dmTagValue.getValue(MD2Slope);
            return slope1 != null && slope2 != null;
        }
        return false;
    }

    public static boolean isGSIDataFile(XjDicomObject xjObject) {
        if (GSIDataUtil.isMonochromatic(xjObject)) {
            Object slope1 = xjObject.getValue(MD1Slope.getGroup(), MD1Slope.getElement());
            Object slope2 = xjObject.getValue(MD2Slope.getGroup(), MD2Slope.getElement());
            return slope1 != null && slope2 != null;
        }
        return false;
    }

    public static boolean isMaterialDensity(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.isGSIImageType(dmTagValue, MATERIAL_DENSITY_IMAGE_TYPE);
    }

    public static boolean isMaterialDensity(XjDicomObject xjObject) {
        return GSIDataUtil.isGSIImageType(xjObject, MATERIAL_DENSITY_IMAGE_TYPE);
    }

    public static boolean isEffectiveZ(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.isGSIImageType(dmTagValue, EFFECTIVE_Z_IMAGE_TYPE);
    }

    public static boolean isEffectiveZ(XjDicomObject xjObject) {
        return GSIDataUtil.isGSIImageType(xjObject, EFFECTIVE_Z_IMAGE_TYPE);
    }

    public static boolean isColorOverlay(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.isGSIImageType(dmTagValue, COLOR_OVERLAY_IMAGE_TYPE);
    }

    public static boolean isColorOverlay(XjDicomObject xjObject) {
        return GSIDataUtil.isGSIImageType(xjObject, COLOR_OVERLAY_IMAGE_TYPE);
    }

    public static boolean isQC(DMTagValueInterface dmTagValue) {
        return GSIDataUtil.isGSIImageType(dmTagValue, QC_IMAGE_TYPE);
    }

    public static boolean isQC(XjDicomObject xjObject) {
        return GSIDataUtil.isGSIImageType(xjObject, QC_IMAGE_TYPE);
    }

    public static MultiChannelDataSupport.ChannelInfo[] buildChannelInfo(DMTagValueInterface dmTagValue) {
        MultiChannelDataSupport.ChannelInfo[] channels = null;
        if (GSIDataUtil.isGSI(dmTagValue)) {
            String rescaleInterceptKey = tagValue.atToString(40, 4178);
            DMTag rescaleInterceptTag = new DMTag(40, 4178);
            String rescaleSlopeKey = tagValue.atToString(40, 4179);
            DMTag rescaleSlopeTag = new DMTag(40, 4179);
            String channelDataKey = tagValue.atToString(32736, 16);
            if (GSIDataUtil.isGSIDataFile(dmTagValue)) {
                channels = new MultiChannelDataSupport.ChannelInfo[5];
                MultiChannelDataSupport.ChannelInfo channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = CP;
                HashMap<String, DMTag> tagMap = new HashMap<String, DMTag>(3);
                tagMap.put(rescaleInterceptKey, rescaleInterceptTag);
                tagMap.put(rescaleSlopeKey, rescaleSlopeTag);
                tagMap.put(channelDataKey, CPData);
                channelInfo.tagMap = tagMap;
                channels[0] = channelInfo;
                channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = MD1;
                tagMap = new HashMap(3);
                tagMap.put(rescaleInterceptKey, MD1Intercept);
                tagMap.put(rescaleSlopeKey, MD1Slope);
                tagMap.put(channelDataKey, MD1Data);
                channelInfo.tagMap = tagMap;
                channels[1] = channelInfo;
                channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = MD2;
                tagMap = new HashMap(3);
                tagMap.put(rescaleInterceptKey, MD2Intercept);
                tagMap.put(rescaleSlopeKey, MD2Slope);
                tagMap.put(channelDataKey, MD2Data);
                channelInfo.tagMap = tagMap;
                channels[2] = channelInfo;
                channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = NM1;
                tagMap = new HashMap(3);
                tagMap.put(rescaleInterceptKey, rescaleInterceptTag);
                tagMap.put(rescaleSlopeKey, rescaleSlopeTag);
                tagMap.put(channelDataKey, NM1Data);
                channelInfo.tagMap = tagMap;
                channels[3] = channelInfo;
                channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = NM2;
                tagMap = new HashMap(3);
                tagMap.put(rescaleInterceptKey, rescaleInterceptTag);
                tagMap.put(rescaleSlopeKey, rescaleSlopeTag);
                tagMap.put(channelDataKey, NM2Data);
                channelInfo.tagMap = tagMap;
                channels[4] = channelInfo;
            } else {
                channels = new MultiChannelDataSupport.ChannelInfo[1];
                MultiChannelDataSupport.ChannelInfo channelInfo = new MultiChannelDataSupport.ChannelInfo();
                channelInfo.channelName = CP;
                HashMap<String, DMTag> tagMap = new HashMap<String, DMTag>(3);
                tagMap.put(rescaleInterceptKey, rescaleInterceptTag);
                tagMap.put(rescaleSlopeKey, rescaleSlopeTag);
                tagMap.put(channelDataKey, CPData);
                channelInfo.tagMap = tagMap;
                channels[0] = channelInfo;
            }
        }
        return channels;
    }

    public static List<DMTag> getMultiChannelTags() {
        if (null == mchannelTags) {
            mchannelTags = new ArrayList<DMTag>(9);
            mchannelTags.add(GSIImageType);
            mchannelTags.add(CPMonoEnergy);
            mchannelTags.add(MD1Intercept);
            mchannelTags.add(MD1Slope);
            mchannelTags.add(MD1Data);
            mchannelTags.add(NM1Data);
            mchannelTags.add(MD2Intercept);
            mchannelTags.add(MD2Slope);
            mchannelTags.add(MD2Data);
            mchannelTags.add(NM2Data);
        }
        return mchannelTags;
    }
}

