/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.util.dicom.jdbCIOD;
import com.ge.med.terra.tap.util.dicom.jdbCIODs;
import com.ge.med.terra.tap.util.dicom.tag;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class TagTableModel
extends AbstractTableModel {
    Vector data = new Vector();
    Vector fdata = new Vector();
    jdbCIODs ciods = new jdbCIODs();
    public static final int ALL_TAGS = 0;
    public static final int PATIENT_TAGS = 2;
    public static final int NO_PRIVATE_TAGS = 1;
    public static final int SERIES_TAGS = 3;
    public static final int STUDY_TAGS = 4;
    String[] header = new String[]{"Tag", "Value", "VR", "Length", "Name"};
    int[] colSizes = new int[]{100, 400, 20, 20, 200};
    boolean showUnknown = true;
    protected Comparator comp = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((tag)o1, (tag)o2);
        }

        public int compare(tag n1, tag n2) {
            short g1 = n1.group;
            short g2 = n2.group;
            if (g1 > g2) {
                return 1;
            }
            if (g1 == g2) {
                short e1 = n1.element;
                short e2 = n2.element;
                if (e1 > e2) {
                    return 1;
                }
                if (e1 == e2) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };

    public int getColWidth(int index) {
        return this.colSizes[index];
    }

    public void filterThis(int index) {
        this.filterData(index);
    }

    public void setData(Vector data, int index) {
        this.data = data;
        this.filterData(index);
    }

    @Override
    public int getColumnCount() {
        return this.header.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.fdata != null && this.fdata.size() > 0) {
            return ((Vector)this.fdata.get(col)).get(row);
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        System.out.println("set value = old=" + this.getValueAt(rowIndex, columnIndex) + " new=" + aValue);
    }

    @Override
    public int getRowCount() {
        if (this.fdata != null && this.fdata.size() > 0) {
            return ((Vector)this.fdata.get(0)).size();
        }
        return 0;
    }

    public boolean isShowUnknown() {
        return this.showUnknown;
    }

    public void setShowUnknown(boolean showUnknown) {
        this.showUnknown = showUnknown;
        this.filterData(0);
    }

    private void filterData(int index) {
        if (index == 0) {
            this.fdata = this.data;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            return;
        }
        if (index == 1) {
            int i;
            Vector[] vectArr = new Vector[this.data.size()];
            Vector<Vector> newVect = new Vector<Vector>();
            for (i = 0; i < vectArr.length; ++i) {
                vectArr[i] = new Vector();
                newVect.add(vectArr[i]);
            }
            for (i = 0; i < ((Vector)this.data.get(0)).size(); ++i) {
                Object obj = ((Vector)this.data.get(0)).get(i);
                if (!(obj instanceof tag) || ((tag)obj).group % 2 != 0) continue;
                for (int j = 0; j < vectArr.length; ++j) {
                    vectArr[j].add(((Vector)this.data.get(j)).get(i));
                }
            }
            this.fdata = newVect;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        } else {
            int i;
            Vector tags;
            jdbCIOD ciod = (jdbCIOD)this.ciods.ciodList.get(0);
            if (index == 2) {
                tags = ciod.getIE("PATIENT").getTagList();
            } else if (index == 3) {
                tags = ciod.getIE("STUDY").getTagList();
            } else if (index == 4) {
                tags = ciod.getIE("SERIES").getTagList();
            } else {
                return;
            }
            tag[] tgs = new tag[tags.size()];
            for (int i2 = 0; i2 < tags.size(); ++i2) {
                tgs[i2] = (tag)tags.get(i2);
            }
            Arrays.sort(tgs, this.comp);
            Vector vt = (Vector)this.data.get(0);
            int j = 0;
            Vector[] vectArr = new Vector[this.data.size()];
            Vector<Vector> newVect = new Vector<Vector>();
            for (i = 0; i < vectArr.length; ++i) {
                vectArr[i] = new Vector();
                newVect.add(vectArr[i]);
            }
            block5: for (i = 0; i < tgs.length; ++i) {
                while (j < vt.size()) {
                    Object obj = vt.get(j);
                    if (obj instanceof tag) {
                        tag tgg = (tag)obj;
                        if (tgs[i].group == tgg.group) {
                            if (tgs[i].element == tgg.element) {
                                for (int k = 0; k < vectArr.length; ++k) {
                                    vectArr[k].add(((Vector)this.data.get(k)).get(j));
                                }
                                continue block5;
                            }
                            if (tgg.element > tgs[i].element) {
                                continue block5;
                            }
                        } else if (tgg.group > tgs[i].group) continue block5;
                    }
                    ++j;
                }
            }
            this.fdata = newVect;
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
        }
    }

    @Override
    public String getColumnName(int index) {
        return this.header[index];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }
}

