/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.tools;

import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import com.ge.med.terra.tap.util.dicom.UidGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Random;

public class DMAnon {
    String[] titles = new String[]{"Instance Creator UID", "UID", "SOP Instance UID", "UID", "Accession Number", "str", "Institution Name", "str", "Institution Address", "str", "Referring Physicians Name", "str", "Referring Physicians Address", "str", "Referring Physicians Telephone Numbers", "str", "Station Name", "str", "Study Description", "str", "Series Description", "str", "Institutional Department Name", "str", "Physician(s) of Record", "str", "Performing Physicians Name", "str", "Name of Physician(s) Reading Study", "str", "Operators Name", "str", "Admitting Diagnoses Description", "str", "Referenced SOP Instance UID", "str", "Derivation Description", "str", "Patients Name", "pn", "Patient ID", "str", "Patients Birth Date", "date", "Patients Birth Time", "time", "Patients Sex", "str", "Other Patient Ids", "str", "Other Patient Names", "pn", "Patients Age", "age", "Patients Size", "str", "Patients Weight", "str", "Medical Record Locator", "str", "Ethnic Group", "str", "Occupation", "str", "Additional Patients History", "str", "Patient Comments", "str", "Device Serial Number", "str", "Protocol Name", "str", "Study Instance UID", "UID", "Series Instance UID", "UID", "Study ID", "str", "Frame of Reference UID", "UID", "Synchronization Frame of Reference UID", "UID", "Image Comments", "str", "Request Attributes Sequence", "str", "UID", "UID", "Content Sequence", "str", "Storage Media File-set UID", "UID", "Referenced Frame of Reference UID", "UID", "Related Frame of Reference UID", "UID"};
    int[][] tags = new int[][]{{8, 20}, {8, 24}, {8, 80}, {8, 128}, {8, 129}, {8, 144}, {8, 146}, {8, 148}, {8, 4112}, {8, 4144}, {8, 4158}, {8, 4160}, {8, 4168}, {8, 4176}, {8, 4192}, {8, 4208}, {8, 4224}, {8, 4437}, {8, 8465}, {16, 16}, {16, 32}, {16, 48}, {16, 50}, {16, 64}, {16, 4096}, {16, 4097}, {16, 4112}, {16, 4128}, {16, 4144}, {16, 4240}, {16, 8544}, {16, 8576}, {16, 8624}, {16, 16384}, {24, 4096}, {24, 4144}, {32, 13}, {32, 14}, {32, 16}, {32, 82}, {32, 512}, {32, 16384}, {64, 629}, {64, 41252}, {64, 42800}, {136, 320}, {12294, 36}, {12294, 194}};
    boolean[] use = new boolean[48];
    HashMap encMap = new HashMap();
    static Encoder pnEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                String s = (String)src;
                return s.substring(0, 1) + DMAnon.randString(s.length() - 1);
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Encoder uidEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                String s = (String)src;
                return UidGenerator.newInstanceUID();
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Encoder strEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                String s = (String)src;
                return DMAnon.randString(s.length() - 1);
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Encoder timeEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                SimpleDateFormat tfmt = new SimpleDateFormat("HHmmss");
                String now = tfmt.format(Calendar.getInstance().getTime());
                return now;
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Encoder dateEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                SimpleDateFormat dfmt = new SimpleDateFormat("yyyyMMdd");
                String today = dfmt.format(Calendar.getInstance().getTime());
                return today;
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Encoder ageEncode = new Encoder(){

        @Override
        public Object encode(Object src) {
            if (src instanceof String) {
                return "001D";
            }
            throw new RuntimeException("\"" + src + "\" not a string");
        }
    };
    static Random r = new Random();

    public DMAnon() {
        for (int i = 0; i < this.use.length; ++i) {
            this.use[i] = true;
        }
        this.encMap.put("str", strEncode);
        this.encMap.put("pn", pnEncode);
        this.encMap.put("UID", uidEncode);
        this.encMap.put("date", dateEncode);
        this.encMap.put("time", timeEncode);
        this.encMap.put("age", ageEncode);
    }

    public void deIdentify(DMObject o, ProgressListener notify) {
        String anonTempDir = System.getProperty("ANON_DIR", System.getProperty("java.io.tmpdir") + File.separator + "tapanon");
        File tmpdir = new File(anonTempDir = anonTempDir + File.separator + System.currentTimeMillis());
        if (!tmpdir.exists()) {
            tmpdir.mkdirs();
        }
        DMComposite[] dmc = o.getComposites();
        DicomComposite dcmobj = new DicomComposite();
        int count = 0;
        for (int i = 0; i < this.use.length; ++i) {
            if (!this.use[i]) continue;
            ++count;
        }
        DMElement[] dme = new DMElement[count];
        String[] type = new String[count];
        count = 0;
        for (int i = 0; i < this.use.length; ++i) {
            if (!this.use[i]) continue;
            type[count] = this.titles[i * 2 + 1];
            dme[count++] = new DMElement(this.tags[i][0], this.tags[i][1]);
        }
        HashMap map = new HashMap();
        ArrayList<DMElement> al = new ArrayList<DMElement>(dme.length);
        System.out.println("anon begin");
        for (int i = 0; i < dmc.length; ++i) {
            boolean cont;
            int k;
            for (k = 0; k < dme.length; ++k) {
                dme[k].value = null;
            }
            dmc[i].getValues(dme);
            al.clear();
            for (k = 0; k < dme.length; ++k) {
                if (dme[k].value == null) continue;
                Object crypt = map.get(dme[k].value + type[k]);
                if (crypt == null) {
                    crypt = ((Encoder)this.encMap.get(type[k])).encode(dme[k].value);
                    map.put(dme[k].value + type[k], crypt);
                }
                dme[k].value = crypt;
                al.add(dme[k]);
            }
            DMElement[] dmeToSet = al.toArray(new DMElement[al.size()]);
            try {
                FileInputStream f = new FileInputStream(dmc[i].getFilePath());
                dcmobj.read(f);
                f.close();
                dcmobj.setValues(dmeToSet);
                FileOutputStream fos = new FileOutputStream(anonTempDir + File.separator + (String)dcmobj.getValue(8, 24));
                dcmobj.write(fos, true);
                fos.close();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            if (notify == null || (cont = notify.progress(i + 1, dmc.length, dmc[i].getID()))) continue;
            SimpleUtilities.deleteFilesRecursively(tmpdir);
            return;
        }
        try {
            DMSession mainSession = o.getSession();
            File[] files = tmpdir.listFiles();
            mainSession.installFiles(files, true);
            SimpleUtilities.deleteFilesRecursively(tmpdir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String randString(int len) {
        if (len < 1) {
            return "";
        }
        byte[] buff = new byte[len];
        r.nextBytes(buff);
        int i = 0;
        while (i < buff.length) {
            int n = i++;
            buff[n] = (byte)(buff[n] & 0x7F);
        }
        return new String(buff).replaceAll("\\W", "A");
    }

    static interface Encoder {
        public Object encode(Object var1);
    }

    public static interface ProgressListener
    extends EventListener {
        public boolean progress(int var1, int var2, String var3);
    }
}

