/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.sql.SqlComposite;
import com.ge.med.terra.tap.dm.sql.SqlImageObject;
import com.ge.med.terra.tap.dm.sql.SqlObject;
import com.ge.med.terra.tap.dm.sql.SqlPatientObject;
import com.ge.med.terra.tap.dm.sql.SqlSeriesObject;
import com.ge.med.terra.tap.dm.sql.SqlStudyObject;
import com.ge.med.terra.tap.dm.sql.SqlUtils;
import com.ge.med.terra.tap.util.SimpleUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class SqlSession
implements DMiSession {
    private final int MAX_SIZE = 200000;
    protected String dbDriver = "org.postgresql.Driver";
    protected String dbUrl = "jdbc:postgresql://localhost/ctmr_sdc_db";
    protected Properties dbProps;
    protected String imageDir = "/export/home1/sdc_image_pool/images";
    protected String importDir = "/export/home/sdc/import";
    protected Map compcache;
    protected Connection con;
    protected File rootDir;
    protected PreparedStatement patientByIdStmt;
    protected PreparedStatement studyByIdStmt;
    protected PreparedStatement seriesByIdStmt;
    protected PreparedStatement imageCountStmt;
    protected PreparedStatement patientCompositesStmt;
    protected PreparedStatement aPatientCompositeStmt;
    protected PreparedStatement studyCompositesStmt;
    protected PreparedStatement aStudyCompositeStmt;
    protected DMTag[] sortCritiria = new DMTag[4];
    private static int unique = 0;
    private Vector listeners = new Vector();

    public SqlSession() {
        this.dbProps = new Properties();
        this.dbProps.setProperty("user", "postgres");
        this.dbProps.setProperty("password", "");
        this.compcache = new LinkedHashMap(200000){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 200000;
            }
        };
        this.rootDir = new File(this.imageDir);
    }

    @Override
    public void init(String session, String[] args) {
        try {
            Class.forName(this.dbDriver).newInstance();
            this.con = DriverManager.getConnection(this.dbUrl, this.dbProps);
            this.patientByIdStmt = this.con.prepareStatement("SELECT * FROM patient_folder WHERE patient_id = ?");
            this.studyByIdStmt = this.con.prepareStatement("SELECT * FROM examination_folder WHERE folder_id = ?");
            this.seriesByIdStmt = this.con.prepareStatement("SELECT * FROM series_environment WHERE series_id = ?");
            this.imageCountStmt = this.con.prepareStatement("SELECT object_counter FROM objects_counter WHERE object_type = 'i'");
            this.patientCompositesStmt = this.con.prepareStatement("SELECT series_id, image_table FROM series_environment WHERE folder_id in (SELECT folder_id FROM examination_folder WHERE patient_id = ?)");
            this.aPatientCompositeStmt = this.con.prepareStatement("SELECT series_id, image_table FROM series_environment WHERE folder_id = (SELECT folder_id FROM examination_folder WHERE patient_id = ? LIMIT 1) LIMIT 1");
            this.studyCompositesStmt = this.con.prepareStatement("SELECT series_id, image_table FROM series_environment WHERE folder_id = ?");
            this.aStudyCompositeStmt = this.con.prepareStatement("SELECT series_id, image_table FROM series_environment WHERE folder_id = ? LIMIT 1");
            this.sortCritiria[0] = new DMTag(16, 16);
            this.sortCritiria[1] = new DMTag(16, 16);
            this.sortCritiria[2] = new DMTag(32, 17);
            this.sortCritiria[3] = new DMTag(32, 19);
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.getRelated(SqlUtils.LEVELS[0], q, cb);
    }

    @Override
    public DMiComposite getComposite(String id) {
        SqlComposite composite = null;
        if (id != null && id.indexOf(124) > 0) {
            WeakReference ref;
            if (this.compcache.containsKey(id) && (ref = (WeakReference)this.compcache.get(id)) != null) {
                composite = (SqlComposite)ref.get();
            }
            if (composite == null) {
                String tableName = SqlUtils.getImageTableName(id);
                String imageId = SqlUtils.getImageKey(id);
                String multiframe = SqlUtils.getMultiframeColumn(tableName);
                try {
                    String sql = "SELECT local_path" + multiframe + " FROM " + tableName + " WHERE " + "object_id = '" + imageId + "';";
                    ResultSet rs = this.con.createStatement().executeQuery(sql);
                    if (rs.next()) {
                        int numberOfFrames = multiframe.length() > 0 ? rs.getInt(2) : 1;
                        composite = this.makeNewSqlComposite(rs.getString(1), id, numberOfFrames);
                    }
                    rs.close();
                }
                catch (SQLException e) {
                    throw new DMException(e);
                }
            }
        }
        return composite;
    }

    @Override
    public DMiComposite[] getComposites() {
        List list = this.getCompositeList();
        return list.toArray(new SqlComposite[list.size()]);
    }

    @Override
    public int getNumberOfComposites() {
        int count = 0;
        try {
            ResultSet rs = this.imageCountStmt.executeQuery();
            if (rs.next()) {
                count = rs.getInt(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return count;
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated(SqlUtils.LEVELS[0], q);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[list.size()]);
    }

    @Override
    public void getRelated(String type, DMQuery q, DMiObjectReceiver cb) {
        int level = SqlUtils.getLevelIndex(type);
        switch (level) {
            case 0: {
                this.getRelatedObjects(q, cb, "patient_folder", level, SqlPatientObject.tagToColumnMap);
                break;
            }
            case 1: {
                this.getRelatedObjects(q, cb, "examination_folder", level, SqlStudyObject.tagToColumnMap);
                break;
            }
            case 2: {
                this.getRelatedObjects(q, cb, "series_environment", level, SqlSeriesObject.tagToColumnMap);
                break;
            }
            case 3: {
                for (int i = 0; i < SqlImageObject.TABLES.length; ++i) {
                    this.getRelatedObjects(q, cb, SqlImageObject.TABLES[i], level, SqlImageObject.columnToTagMap);
                }
                break;
            }
        }
    }

    private void getRelatedObjects(DMQuery q, DMiObjectReceiver cb, String tableName, int level, Map cache) {
        try {
            String query;
            String str = SqlUtils.getSqlString(q, cache);
            String sort = (String)cache.get(this.getSortTag(level));
            String string = sort = sort == null ? "" : " ORDER BY " + sort;
            if (level == 1) {
                query = "SELECT examination_folder.*, patient_folder.patient_name, patient_folder.orgl_patient_id, patient_folder.birthdate FROM examination_folder, patient_folder WHERE examination_folder.patient_id = patient_folder.patient_id";
                str = str.length() > 0 ? " AND " + str : str;
            } else {
                str = str.length() > 0 ? " WHERE " + str : str;
                query = "SELECT * FROM " + tableName;
            }
            query = query + str + sort + ";";
            ResultSet rs = this.con.createStatement().executeQuery(query);
            while (rs.next()) {
                SqlObject o;
                switch (level) {
                    case 0: {
                        o = new SqlPatientObject(this, rs);
                        break;
                    }
                    case 1: {
                        o = new SqlStudyObject(this, rs);
                        break;
                    }
                    case 2: {
                        o = new SqlSeriesObject(this, rs);
                        break;
                    }
                    default: {
                        o = new SqlImageObject(this, rs, tableName);
                    }
                }
                if (q != null && !q.valid(o) || cb.gotOne(o)) continue;
                rs.close();
                return;
            }
            rs.close();
        }
        catch (SQLException ex) {
            throw new DMException(ex);
        }
    }

    @Override
    public void save(DMiObject dmo, Hashtable prop) {
        DMiComposite[] dmc = dmo.getComposites(null);
        for (int i = 0; i < dmc.length; ++i) {
            this.save(dmc[i], prop);
        }
    }

    @Override
    public void save(DMiObject[] dmo, Hashtable prop) {
        for (int i = 0; i < dmo.length; ++i) {
            this.save(dmo[i], prop);
        }
    }

    @Override
    public void save(DMiComposite dmc, Hashtable prop) {
        try {
            this.installFiles(new File[]{new File(dmc.getFilePath())}, false);
        }
        catch (Exception e) {
            throw new DMException(e);
        }
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        if (eventType == 1) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws IOException, FileNotFoundException {
        File installDir = new File(this.importDir + File.separator + ((long)Math.abs(this.hashCode()) + System.currentTimeMillis() + (long)(++unique)));
        installDir.mkdir();
        for (int i = 0; i < files.length; ++i) {
            File installFile = new File(installDir.getAbsolutePath() + File.separator + files[i].getName());
            String sourcePath = files[i].getAbsolutePath();
            boolean renamed = files[i].renameTo(installFile);
            if (!renamed) {
                SimpleUtilities.copyFile(sourcePath, installFile.getAbsolutePath());
                if (destroy) {
                    files[i].delete();
                }
            }
            this.fireEvent(new DMEvent(1, "install: " + sourcePath, sourcePath));
        }
        installDir.renameTo(new File(installDir.getAbsolutePath() + ".sdcopen"));
    }

    @Override
    public void install(InputStream is) throws IOException {
        File installFile = new File(this.importDir + File.separator + ((long)Math.abs(this.hashCode()) + System.currentTimeMillis() + (long)(++unique)));
        SimpleUtilities.copyFile(is, installFile.getAbsolutePath());
        this.installFiles(new File[]{installFile}, true);
    }

    protected DMTag parseTag(String name, String str) {
        int[][] tags;
        DMTag tag2 = null;
        if (str.startsWith(name) && (tags = new DMQuery(str.substring(name.length())).getTags()) != null && tags.length > 0) {
            tag2 = new DMTag(tags[0][0], tags[0][1]);
        }
        return tag2;
    }

    protected DMQuery parseDMQuery(String name, String str) {
        DMQuery query = null;
        if (str.startsWith(name)) {
            query = new DMQuery(str.substring(name.length()));
        }
        return query;
    }

    @Override
    public String[] send(String str) {
        String[] sort = new String[]{"PSORT=", "ESORT=", "SSORT=", "ISORT="};
        for (int i = 0; i < sort.length; ++i) {
            DMTag tag2 = this.parseTag(sort[i], str);
            if (tag2 == null) continue;
            this.sortCritiria[i] = tag2;
            return null;
        }
        if (str.startsWith("IMPORTDIR")) {
            return new String[]{this.importDir};
        }
        return null;
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method SqlSesson:asynSend() not implemented.");
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        SqlObject dmo = null;
        try {
            switch (SqlUtils.getLevelIndex(type)) {
                case 0: {
                    ResultSet rs = this.getPatient(id);
                    if (rs.next()) {
                        dmo = new SqlPatientObject(this, rs);
                    }
                    rs.close();
                    break;
                }
                case 1: {
                    ResultSet rs = this.getStudy(id);
                    if (rs.next()) {
                        dmo = new SqlStudyObject(this, rs);
                    }
                    rs.close();
                    break;
                }
                case 2: {
                    ResultSet rs = this.getSeries(id);
                    if (rs.next()) {
                        dmo = new SqlSeriesObject(this, rs);
                    }
                    rs.close();
                    break;
                }
                case 3: {
                    ResultSet rs = this.getImage(id);
                    if (rs.next()) {
                        dmo = new SqlImageObject(this, rs, SqlUtils.getImageTableName(id));
                    }
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return dmo;
    }

    @Override
    public void ClearCache() {
        this.compcache.clear();
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method SqlSession:getJobs() not implemented.");
    }

    @Override
    public void close() {
        try {
            if (this.con != null && !this.con.isClosed()) {
                this.con.close();
            }
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
    }

    private List getCompositeList() {
        ArrayList<SqlComposite> list = new ArrayList<SqlComposite>();
        try {
            for (int i = 0; i < SqlImageObject.TABLES.length; ++i) {
                String tableName = SqlImageObject.TABLES[i];
                String multiframe = SqlUtils.getMultiframeColumn(tableName);
                String sql = "SELECT object_id, local_path" + multiframe + " FROM " + tableName + ";";
                ResultSet rs = this.con.createStatement().executeQuery(sql);
                while (rs.next()) {
                    String id = tableName + '|' + rs.getString(1);
                    int numberOfFrames = multiframe.length() > 0 ? rs.getInt(3) : 1;
                    list.add(this.makeNewSqlComposite(rs.getString(2), id, numberOfFrames));
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return list;
    }

    SqlComposite makeNewSqlComposite(String path, String id, int numberOfFrames) {
        SqlComposite composite = null;
        WeakReference ref = (WeakReference)this.compcache.get(id);
        if (ref != null) {
            composite = (SqlComposite)ref.get();
        }
        if (composite == null) {
            composite = new SqlComposite(this, path, id, numberOfFrames);
            this.compcache.put(id, new WeakReference<SqlComposite>(composite));
        }
        return composite;
    }

    protected ResultSet getPatient(String id) throws SQLException {
        this.patientByIdStmt.setString(1, id);
        return this.patientByIdStmt.executeQuery();
    }

    protected ResultSet getStudy(String id) throws SQLException {
        this.studyByIdStmt.setString(1, id);
        return this.studyByIdStmt.executeQuery();
    }

    protected ResultSet getSeries(String id) throws SQLException {
        this.seriesByIdStmt.setString(1, id);
        return this.seriesByIdStmt.executeQuery();
    }

    protected ResultSet getImage(String id) throws SQLException {
        ResultSet rs = null;
        String key = SqlUtils.getImageKey(id);
        String table = SqlUtils.getImageTableName(id);
        try {
            String query = "SELECT * FROM " + table + " WHERE " + "object_id = '" + key + "';";
            rs = this.con.createStatement().executeQuery(query);
        }
        catch (SQLException e) {
            throw new DMException(e);
        }
        return rs;
    }

    protected ResultSet getStudyComponents(String studyId) throws SQLException {
        this.studyCompositesStmt.setString(1, studyId);
        return this.studyCompositesStmt.executeQuery();
    }

    protected ResultSet getAStudyComposite(String studyId) throws SQLException {
        this.aStudyCompositeStmt.setString(1, studyId);
        return this.aStudyCompositeStmt.executeQuery();
    }

    protected ResultSet getPatientComposites(String patientId) throws SQLException {
        this.patientCompositesStmt.setString(1, patientId);
        return this.patientCompositesStmt.executeQuery();
    }

    protected ResultSet getAPatientComposite(String patientId) throws SQLException {
        this.aPatientCompositeStmt.setString(1, patientId);
        return this.aPatientCompositeStmt.executeQuery();
    }

    DMTag getSortTag(int level) {
        return this.sortCritiria[level];
    }

    protected DMEventListener[] getDMEventListeners() {
        return this.listeners.toArray(new DMEventListener[this.listeners.size()]);
    }

    protected void fireEvent(DMEvent event) {
        DMEventListener[] eventListeners = this.getDMEventListeners();
        for (int i = 0; i < eventListeners.length; ++i) {
            eventListeners[i].actionPerformed(event);
        }
    }
}

