/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sql;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.dicomImageGen;
import com.ge.med.terra.tap.dm.sessionFile.fileSequence;
import com.ge.med.terra.tap.dm.sql.SqlImage;
import com.ge.med.terra.tap.dm.sql.SqlSession;
import com.ge.med.terra.tap.util.dicom.dicomParser;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class SqlComposite
implements DMiComposite,
DMTagValueInterface {
    protected static dicomParser parser = new dicomParser();
    protected SqlSession session;
    protected File file;
    protected String id;
    protected int numberOfFrames;
    private HashMap<DMTag, tagValue> elemCache = new HashMap();

    public SqlComposite(SqlSession session, String path, String id, int numberOfFrames) {
        this.session = session;
        this.file = new File(session.imageDir + File.separator + path);
        this.id = id;
        this.numberOfFrames = numberOfFrames;
    }

    @Override
    public Object getValue(DMTag tag2) {
        if (this.elemCache.containsKey(tag2)) {
            return this.elemCache.get((Object)tag2).value;
        }
        try {
            parser.setFile(this.getFilePath());
            tagValue tv = new tagValue(tag2.getGroup(), tag2.getElement());
            parser.fill(new tagValue[]{tv});
            if (tv.vrep == 21329) {
                tv.value = new fileSequence(tv);
            }
            if (tag2.getGroup() < 200) {
                this.elemCache.put(new DMTag(tag2.getGroup(), tag2.getElement()), tv);
            }
            Object object = tv.value;
            return object;
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
        finally {
            parser.clearFile();
        }
    }

    @Override
    public void getValues(DMElement[] elements) {
        int size = elements.length;
        boolean[] isFilled = new boolean[size];
        ArrayList<DMElement> tagsToFill = new ArrayList<DMElement>();
        for (int i = 0; i < elements.length; ++i) {
            DMTag tag2 = new DMTag(elements[i].group, elements[i].element);
            if (this.elemCache.containsKey(tag2)) {
                tagValue tv = this.elemCache.get(tag2);
                tagValue.copyFillData(tv, elements[i]);
                isFilled[i] = true;
                continue;
            }
            isFilled[i] = false;
            tagsToFill.add(elements[i]);
        }
        if (!tagsToFill.isEmpty()) {
            try {
                parser.setFile(this.getFilePath());
                Object[] tgs = tagsToFill.toArray(new DMElement[tagsToFill.size()]);
                Arrays.sort(tgs);
                parser.fill((tagValue[])tgs);
                int oldg = -1;
                int olde = -1;
                for (int i = 0; i < tgs.length; ++i) {
                    if (((DMElement)tgs[i]).vrep == 21329) {
                        ((DMElement)tgs[i]).value = new fileSequence((tagValue)tgs[i]);
                    }
                    if (oldg != ((DMElement)tgs[i]).group || olde != ((DMElement)tgs[i]).element) {
                        DMTag tag3 = new DMTag(((DMElement)tgs[i]).group, ((DMElement)tgs[i]).element);
                        this.elemCache.put(tag3, new tagValue((tagValue)tgs[i]));
                    }
                    oldg = ((DMElement)tgs[i]).group;
                    olde = ((DMElement)tgs[i]).element;
                }
            }
            catch (FileNotFoundException ex) {
                throw new DMException(ex);
            }
            finally {
                parser.clearFile();
            }
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        throw new UnsupportedOperationException("SqlObject:setValues() is not supported");
    }

    @Override
    public String getType() {
        return "composite";
    }

    @Override
    public DMTag[] getTags() {
        try {
            parser.setFile(this.getFilePath());
        }
        catch (Exception ex) {
            throw new DMException(ex);
        }
        tagValue[] tv = parser.getTags();
        parser.clearFile();
        DMTag[] tag2 = new DMTag[tv.length];
        for (int i = 0; i < tv.length; ++i) {
            tag2[i] = new DMTag(tv[i].group, tv[i].element, tv[i].vrString());
        }
        return tag2;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("SqlComposite:delete() is not supported");
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        try {
            parser.setFile(this.getFilePath());
        }
        catch (FileNotFoundException ex) {
            throw new DMException(ex);
        }
        BufferedImage[] bims = dicomImageGen.getImages(parser, tags);
        parser.clearFile();
        return bims;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (IOException e) {
            throw new DMException(e);
        }
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        DMiImage[] dmi = new SqlImage[this.numberOfFrames];
        for (int i = 0; i < dmi.length; ++i) {
            dmi[i] = new SqlImage(this, i);
        }
        return dmi;
    }

    @Override
    public String getFilePath() {
        return this.file.getAbsolutePath();
    }
}

