/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.sessionFile;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.sessionFile.State;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class fileImageManager {
    Vector list = new Vector();
    Thread loader;
    int maxMemory = 80000000;
    int minMemory = 60000000;
    int currentMemory;
    private boolean pause = true;
    private static fileImageManager mgr = null;
    boolean sleep = true;
    Object lock = new Object();
    int accessCount = 0;

    private fileImageManager(int maxMemory) {
        this.maxMemory = maxMemory * 0x100000;
        this.minMemory = this.maxMemory * 3 / 4;
        this.loader = new Thread(){

            @Override
            public void run() {
                fileImageManager.this.imageLoader();
            }
        };
        this.loader.setName("fileImageManager Image Loader");
        this.loader.setDaemon(true);
        this.loader.setPriority(1);
        this.loader.start();
    }

    public static fileImageManager getInstance() {
        if (mgr == null || !fileImageManager.mgr.loader.isAlive()) {
            if (mgr != null) {
                Tap.log.warning("Image loader died restarting");
            }
            String mem = "20";
            try {
                mem = Tap.getProperty("tap.dm.ImageMemory", "20");
            }
            catch (Exception ex) {
                // empty catch block
            }
            int size = Integer.parseInt(mem);
            mgr = new fileImageManager(size);
        }
        return mgr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageLoader() {
        try {
            Thread.sleep(10L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        int k = 0;
        while (true) {
            this.currentMemory = this.calcMemory();
            if ((k = (k + 1) % 5) == 0) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        if (!this.sleep) {
                            Thread.sleep(1L);
                        }
                        while (this.sleep) {
                            try {
                                this.lock.wait();
                            }
                            catch (InterruptedException ex) {
                                Tap.log.warning("Image loader wait interrupted");
                            }
                        }
                        this.sleep = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            DMiImage max = this.maxUnLoaded();
            DMiImage min = this.minLoaded();
            if (max != null) {
                if (this.minMemory > this.currentMemory || this.maxMemory > this.currentMemory && State.isMustLoad(max)) {
                    max.loadImage();
                    if (State.isMustLoad(max)) {
                        this.access(max);
                    }
                    State.setLoad(max);
                    this.sleep = false;
                    continue;
                }
                if (!State.isMustLoad(max)) continue;
                if (min != null) {
                    min.unloadImage();
                    State.setUnload(min);
                }
                max.loadImage();
                this.access(max);
                State.setLoad(max);
                this.sleep = false;
                continue;
            }
            if (min == null || this.maxMemory >= this.currentMemory) continue;
            min.unloadImage();
            State.setUnload(min);
            this.sleep = false;
        }
    }

    private DMiImage maxUnLoaded() {
        int max = 0;
        DMiImage maxFi = null;
        int i = 0;
        while (i < this.list.size()) {
            WeakReference w = (WeakReference)this.list.get(i);
            DMiImage fi = (DMiImage)w.get();
            if (fi == null) {
                this.list.remove(i);
                continue;
            }
            if (fi.getState() > max || fi.getState() == max && null != maxFi && fi.getAccess() < maxFi.getAccess()) {
                max = fi.getState();
                maxFi = fi;
            }
            ++i;
        }
        return maxFi;
    }

    private DMiImage minLoaded() {
        int min = 0;
        DMiImage minFi = null;
        int i = 0;
        while (i < this.list.size()) {
            WeakReference w = (WeakReference)this.list.get(i);
            DMiImage fi = (DMiImage)w.get();
            if (fi == null) {
                this.list.remove(i);
                continue;
            }
            if (fi.getState() < min || fi.getState() == min && null != minFi && fi.getAccess() < minFi.getAccess()) {
                min = fi.getState();
                minFi = fi;
            }
            ++i;
        }
        return minFi;
    }

    public void addImage(DMiImage fi) {
        State.setInitalState(fi);
        this.list.add(new WeakReference<DMiImage>(fi));
        this.wake();
    }

    public void access(DMiImage fi) {
        ++this.accessCount;
        fi.setAccess(this.accessCount);
    }

    public void setPreLoad(DMiImage fi) {
        State.setPreLoad(fi);
        this.access(fi);
    }

    public void setPreUnload(DMiImage fi) {
        State.setPreUnload(fi);
        this.access(fi);
    }

    public void startLoading() {
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wake() {
        if (this.pause) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.sleep = false;
            this.lock.notifyAll();
        }
    }

    private int calcMemory() {
        return this.calcMemory(this.list);
    }

    private int calcMemory(Vector list) {
        int total = 0;
        for (int i = 0; i < list.size(); ++i) {
            WeakReference w = (WeakReference)list.get(i);
            DMiImage fi = (DMiImage)w.get();
            if (fi == null) {
                list.remove(i);
                continue;
            }
            total += fi.memorySize();
        }
        return total;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean pause) {
        this.pause = pause;
        if (!pause) {
            this.startLoading();
        }
    }
}

