/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.rm;

import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.rm.RmAuxObjectBase;
import com.ge.med.terra.tap.dm.rm.RmObject;
import com.ge.med.terra.tap.dm.rm.RmQueryPacket;
import com.ge.med.terra.tap.dm.rm.RmService;
import com.ge.med.terra.tap.dm.rm.RmSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RmAuxObject
extends RmAuxObjectBase
implements DMAuxObject {
    protected RmObject parent;
    protected RmSession session;
    protected Class converterClass;
    protected String filename;
    protected String type;
    protected Properties info;

    public RmAuxObject(RmObject parent, String type, Properties info) {
        this.parent = parent;
        this.type = type;
        this.info = info;
        this.session = parent.session;
    }

    @Override
    public Class getConverterClass() {
        if (this.converterClass == null) {
            // empty if block
        }
        return this.converterClass;
    }

    @Override
    public String getFileName() {
        if (this.filename == null) {
            File f;
            try {
                f = File.createTempFile(this.type, ".jpg");
            }
            catch (IOException e) {
                throw new DMException(e);
            }
            f.deleteOnExit();
            this.filename = f.getAbsolutePath();
            try {
                int len;
                InputStream is = this.getInputStream();
                byte[] buf = new byte[32768];
                FileOutputStream os = new FileOutputStream(f);
                while ((len = is.read(buf)) >= 0) {
                    os.write(buf, 0, len);
                }
                os.close();
                is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new DMException(ex);
            }
        }
        return this.filename;
    }

    @Override
    public InputStream getInputStream() {
        RmQueryPacket qp = new RmQueryPacket(3, this.parent.getID(), this.parent.level, this.info, this.type);
        int tid = RmService.newTid();
        this.session.com.sendMsg((byte)71, tid, qp);
        byte[] bytes = (byte[])this.session.com.waitForResponse(-71, tid);
        return new ByteArrayInputStream(bytes);
    }

    @Override
    public Properties getProperties() {
        return this.info;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void putFile(String path) {
        throw new UnsupportedOperationException("RmAuxObject:putFile() is not implemented");
    }
}

