/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.ram;

import com.ge.med.terra.tap.dm.DMImage;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.ram.RAMImageDB;
import com.ge.med.terra.tap.dm.ram.RAMSessionFactory;
import java.util.logging.Logger;

public class RamImageInstaller {
    private static final Logger LOGGER = Logger.getLogger(RamImageInstaller.class.getName());
    private static RamImageInstaller installer = new RamImageInstaller();
    private RAMImageDB ramImgDB;

    private RamImageInstaller() {
    }

    public static RamImageInstaller getInstance() {
        return installer;
    }

    public void installImage(String ramDB) {
        LOGGER.info("ramDB = " + ramDB);
        String dbName = "";
        String dbPath = "";
        String[] ramDbSplit = ramDB.split(",");
        if (ramDbSplit.length == 2 && ramDbSplit[0].length() > 0 && ramDbSplit[1].length() > 0) {
            dbName = ramDbSplit[0].trim();
            dbPath = ramDbSplit[1].trim();
            LOGGER.info("Ram DB : " + dbName + "  [" + dbPath + "]");
        } else {
            LOGGER.info("Invalid argument for ram.db . Use argument as ram.db,'Location of images to be installed in RamDB. \n See documentation for install API in RamImageInstaller' ");
        }
        this.ramImgDB = new RAMImageDB(dbName);
        DMSession.insertSession("ram", new RAMSessionFactory());
        DMSession fileSession2 = new DMSession(new String[]{"file", dbPath});
        DMObject[] patDmos = fileSession2.getRelated("series");
        for (int j = 0; j < patDmos.length; ++j) {
            DMImage[] imgs = patDmos[j].getImages(null);
            for (int i = 0; i < imgs.length; ++i) {
                this.ramImgDB.install(imgs[i]);
            }
        }
    }
}

