/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.ram;

import com.ge.med.idc.XjTagValue;
import java.util.logging.Logger;

public class RAMUtility {
    private static final Logger LOGGER = Logger.getLogger(RAMUtility.class.getName());
    private static int[][] patientTags = new int[][]{{16, 16}, {16, 32}, {16, 48}, {16, 64}, {16, 50}, {16, 16384}};
    private static int[][] studyTags = new int[][]{{16, 16}, {16, 32}, {16, 48}, {16, 64}, {16, 50}, {16, 16384}, {32, 13}, {8, 32}, {8, 48}, {8, 144}, {32, 16}, {8, 80}, {8, 4144}, {16, 4112}, {16, 4128}};
    private static int[][] seriesTags = new int[][]{{16, 16}, {16, 32}, {16, 48}, {16, 64}, {16, 50}, {16, 16384}, {32, 13}, {8, 32}, {8, 48}, {8, 144}, {32, 16}, {8, 80}, {8, 4144}, {16, 4112}, {16, 4128}, {8, 96}, {32, 14}, {32, 17}, {32, 96}, {8, 33}, {8, 49}, {8, 4176}, {24, 4144}, {8, 4158}, {24, 21}, {24, 20736}, {8, 104}};
    private static int[][] imageTags = new int[][]{{16, 16}, {16, 32}, {16, 48}, {16, 64}, {16, 50}, {16, 16384}, {32, 13}, {8, 24}, {8, 32}, {8, 48}, {8, 144}, {32, 16}, {8, 80}, {8, 4144}, {16, 4112}, {16, 4128}, {8, 96}, {32, 14}, {32, 17}, {32, 96}, {8, 33}, {8, 49}, {8, 4176}, {24, 4144}, {8, 4158}, {24, 21}, {24, 20736}, {8, 104}, {8, 112}, {8, 128}, {8, 4112}, {32, 19}, {32, 32}, {8, 35}, {8, 51}, {8, 8}, {32, 18}, {8, 34}, {8, 50}, {8, 42}, {32, 16384}, {40, 769}, {40, 16}, {40, 17}, {40, 259}, {32736, 16}, {8272, 32}, {24, 96}, {64, 770}, {64, 33538}, {24, 4433}, {24, 33105}, {40, 4176}, {40, 4177}};

    public RAMUtility() {
        System.out.println("RAMUtility.RAMUtility()");
    }

    private static XjTagValue[] getPatientTagList() {
        int numPat = patientTags.length;
        XjTagValue[] tagValues = new XjTagValue[numPat];
        for (int i = 0; i < numPat; ++i) {
            tagValues[i] = new XjTagValue(patientTags[i][0], patientTags[i][1]);
        }
        return tagValues;
    }

    private static XjTagValue[] getStudyTagList() {
        int numStudy = studyTags.length;
        XjTagValue[] tagValues = new XjTagValue[numStudy];
        for (int i = 0; i < numStudy; ++i) {
            tagValues[i] = new XjTagValue(studyTags[i][0], studyTags[i][1]);
        }
        return tagValues;
    }

    private static XjTagValue[] getSeriesTagList() {
        int numSeries = seriesTags.length;
        XjTagValue[] tagValues = new XjTagValue[numSeries];
        for (int i = 0; i < numSeries; ++i) {
            tagValues[i] = new XjTagValue(seriesTags[i][0], seriesTags[i][1]);
        }
        return tagValues;
    }

    private static XjTagValue[] getImageTagList() {
        int numImageTags = imageTags.length;
        XjTagValue[] tagValues = new XjTagValue[numImageTags];
        for (int i = 0; i < numImageTags; ++i) {
            tagValues[i] = new XjTagValue(imageTags[i][0], imageTags[i][1]);
        }
        return tagValues;
    }

    public static XjTagValue[] getTagList(String type) {
        if (type.equalsIgnoreCase("patient")) {
            return RAMUtility.getPatientTagList();
        }
        if (type.equalsIgnoreCase("study")) {
            return RAMUtility.getStudyTagList();
        }
        if (type.equalsIgnoreCase("series")) {
            return RAMUtility.getSeriesTagList();
        }
        if (type.equalsIgnoreCase("image")) {
            return RAMUtility.getImageTagList();
        }
        LOGGER.warning("Unsupported type, returning NULL");
        return null;
    }

    public static void main(String[] args) {
        System.out.println("RAMUtility.main()");
        RAMUtility obj = new RAMUtility();
        XjTagValue[] tagValues = RAMUtility.getTagList("patient");
        System.out.println("tag value = " + tagValues.length);
    }
}

