/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.ram;

import com.ge.med.idc.XjImage;
import com.ge.med.idc.XjTagValue;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dm.ram.RAMImageDB;
import com.ge.med.terra.tap.dm.ram.RAMObject;
import com.ge.med.terra.tap.dm.ram.RAMUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RAMSession
implements DMiSession {
    private static final Logger LOGGER = Logger.getLogger(RAMSession.class.getName());
    private static final Map<String, Integer> ieLevelMap = new HashMap<String, Integer>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("patient", 0);
            this.put("study", 1);
            this.put("series", 2);
            this.put("image", 3);
        }
    };
    private RAMImageDB imageDB = null;

    public RAMSession() {
        LOGGER.info("RAMSession.RAMSession()");
    }

    @Override
    public void init(String dbname, String[] args) {
        LOGGER.info("dbname = " + dbname);
        this.imageDB = RAMImageDB.getRAMDb(dbname);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery query) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, query, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    @Override
    public void getRelated(String type, DMQuery query, DMiObjectReceiver cb) {
        LOGGER.info("RAMSession.getRelated(): IEType = " + type);
        XjImage img = null;
        Set<String> keySet = this.imageDB.getKeys(type);
        for (String key : keySet) {
            XjTagValue[] tagValues = RAMUtility.getTagList(type);
            img = this.imageDB.getRepresentativeImage(type, key);
            img.getValues(tagValues);
            RAMObject ramObj = new RAMObject(this, key, type, tagValues);
            if (query != null && !query.valid(ramObj)) continue;
            cb.gotOne(ramObj);
        }
    }

    @Override
    public DMiObject[] getChildren(DMQuery query) {
        return this.getRelated("patient", query);
    }

    @Override
    public void getChildren(DMQuery query, DMiObjectReceiver cb) {
        this.getRelated("patient", query, cb);
    }

    @Override
    public int getNumberOfComposites() {
        return this.imageDB.getKeys("image").size();
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        XjTagValue[] tags = RAMUtility.getTagList(type);
        XjImage im = this.imageDB.getRepresentativeImage(type, id);
        im.getValues(tags);
        return new RAMObject(this, id, type, tags);
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException("Not supported");
    }

    public void getRelated(RAMObject ro, String reqIEType, DMQuery query, DMiObjectReceiver cb) {
        String uid = "";
        String type = ro.getType();
        if (type.equalsIgnoreCase(reqIEType)) {
            cb.gotOne(ro);
            return;
        }
        int roLevel = ieLevelMap.get(type);
        int reqIELevel = ieLevelMap.get(reqIEType);
        if (reqIELevel < roLevel) {
            if (reqIEType.equalsIgnoreCase("patient")) {
                String patientID = ("" + ro.getValue(new DMTag(16, 32))).trim();
                String patientName = ("" + ro.getValue(new DMTag(16, 16))).trim();
                uid = patientID + patientName;
            } else if (reqIEType.equalsIgnoreCase("study")) {
                uid = ("" + ro.getValue(new DMTag(32, 13))).trim();
            } else if (reqIEType.equalsIgnoreCase("series")) {
                uid = ("" + ro.getValue(new DMTag(32, 14))).trim();
            }
            RAMObject obj = new RAMObject(this, uid, reqIEType, ro.getXjTags());
            if (query == null || query != null && query.valid(obj)) {
                cb.gotOne(obj);
            }
        } else {
            Set<String> children = this.imageDB.getChildRecords(type, ro.getID(), reqIEType);
            XjTagValue[] tags = RAMUtility.getTagList(reqIEType);
            for (String id : children) {
                XjImage im = this.imageDB.getRepresentativeImage(reqIEType, id);
                im.getValues(tags);
                RAMObject ramo = new RAMObject(this, id, reqIEType, tags);
                if (query != null && (query == null || !query.valid(ramo))) continue;
                cb.gotOne(ramo);
            }
        }
    }

    @Override
    public void ClearCache() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void addDMEventListener(int arg0, int arg1, DMEventListener arg2) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DMiJob asynSend(String arg0) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DMiComposite getComposite(String arg0) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DMiComposite[] getComposites() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void install(InputStream arg0) throws IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void installFiles(File[] arg0, boolean arg1) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void removeDMEventListener(DMEventListener arg0) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void save(DMiObject arg0, Hashtable arg1) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public String[] send(String arg0) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        throw new UnsupportedOperationException("Not supported");
    }

    protected DMiImage[] getImages(String ieType, String id, DMTag[] arg0) {
        LOGGER.info("RAMSession.getImages()");
        return this.imageDB.getImagesList(ieType, id);
    }
}

