/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.ram;

import com.ge.med.idc.XjImage;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.ram.RAMImage;
import com.ge.med.terra.tap.dm.ram.RAMImageDBIf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class RAMImageDB
implements RAMImageDBIf {
    private static final Logger LOGGER = Logger.getLogger(RAMImageDB.class.getName());
    private static Map<String, RAMImageDB> mydbs = new HashMap<String, RAMImageDB>();
    private Map<String, Set<String>> patientMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> studyMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> seriesMap = new HashMap<String, Set<String>>();
    private Map<String, XjImage> imageMap = new HashMap<String, XjImage>();
    private String dbname = "";

    public RAMImageDB(String dbName) {
        this.dbname = dbName;
        mydbs.put(dbName, this);
    }

    public static RAMImageDB getRAMDb(String dbname) {
        return mydbs.get(dbname);
    }

    @Override
    public void install(XjImage img) {
        this.updateDB(img);
    }

    @Override
    public void clearDB() {
        this.patientMap.clear();
        this.studyMap.clear();
        this.seriesMap.clear();
        this.imageMap.clear();
    }

    private void updateDB(XjImage img) {
        String patientID = "";
        String patientName = "";
        String studyUID = null;
        String seriesUID = null;
        String sopUID = null;
        if (img.getValue(16, 32) != null) {
            patientID = img.getValue(16, 32).toString().trim();
        }
        if (img.getValue(16, 16) != null) {
            patientName = img.getValue(16, 16).toString().trim();
        }
        String patientKey = patientID + patientName;
        if (img.getValue(32, 13) != null) {
            studyUID = img.getValue(32, 13).toString().trim();
        }
        if (img.getValue(32, 14) != null) {
            seriesUID = img.getValue(32, 14).toString().trim();
        }
        if (img.getValue(8, 24) != null) {
            sopUID = img.getValue(8, 24).toString().trim();
        }
        if (sopUID != null) {
            this.imageMap.put(sopUID, img);
        }
        this.updateSeriesMap(sopUID, seriesUID, studyUID);
        this.updatePatientMap(patientKey, studyUID);
    }

    private void updatePatientMap(String patientKey, String studyUID) {
        if (patientKey != "" && studyUID != null) {
            Set<String> studies = this.patientMap.get(patientKey);
            if (studies == null) {
                studies = new HashSet<String>();
                this.patientMap.put(patientKey, studies);
            }
            studies.add(studyUID);
        } else {
            LOGGER.warning("RAMImageDB.updatePatientMap(): patientID/studyUID missing, not updating patientMap");
        }
    }

    private void updateSeriesMap(String sopUID, String seriesUID, String studyUID) {
        if (seriesUID != null && studyUID != null) {
            Set<String> imgs = this.seriesMap.get(seriesUID);
            if (imgs == null) {
                imgs = new HashSet<String>();
                this.seriesMap.put(seriesUID, imgs);
            }
            imgs.add(sopUID);
            this.updateStudyMap(studyUID, seriesUID);
        } else {
            LOGGER.warning("RAMSESSION: RAMImageDB.updateSeriesMap() : Did not find SERIES_UID/STUDY_UID");
        }
    }

    private void updateStudyMap(String study_ID, String series_UID) {
        Set<String> series = this.studyMap.get(study_ID);
        if (series == null) {
            series = new HashSet<String>();
            this.studyMap.put(study_ID, series);
        }
        series.add(series_UID);
    }

    public Set<String> getKeys(String type) {
        if (type.equalsIgnoreCase("patient")) {
            return this.patientMap.keySet();
        }
        if (type.equalsIgnoreCase("study")) {
            return this.studyMap.keySet();
        }
        if (type.equalsIgnoreCase("series")) {
            return this.seriesMap.keySet();
        }
        if (type.equalsIgnoreCase("image")) {
            return this.imageMap.keySet();
        }
        return null;
    }

    public XjImage getRepresentativeImage(String type, String id) {
        String uid = null;
        if (type.equalsIgnoreCase("patient")) {
            Iterator<String> iter = this.patientMap.get(id).iterator();
            uid = iter.next().toString();
            return this.getRepresentativeImage("study", uid);
        }
        if (type.equalsIgnoreCase("study")) {
            Iterator<String> iter = this.studyMap.get(id).iterator();
            uid = iter.next().toString();
            return this.getRepresentativeImage("series", uid);
        }
        if (type.equalsIgnoreCase("series")) {
            Iterator<String> iter = this.seriesMap.get(id).iterator();
            uid = iter.next().toString();
            return this.getRepresentativeImage("image", uid);
        }
        if (type.equalsIgnoreCase("image")) {
            return this.imageMap.get(id);
        }
        return null;
    }

    public Set<String> getChildRecords(String parentType, final String parentId, String childType) {
        if (parentType.equalsIgnoreCase(childType)) {
            HashSet<String> imgSet = new HashSet<String>(){
                {
                    this.add(parentId);
                }
            };
            return imgSet;
        }
        if (childType.equalsIgnoreCase("study")) {
            return this.patientMap.get(parentId);
        }
        if (childType.equalsIgnoreCase("series")) {
            HashSet<String> seriesRes = new HashSet<String>();
            if (parentType.equalsIgnoreCase("patient")) {
                Set<String> studies = this.getChildRecords("patient", parentId, "study");
                for (String study : studies) {
                    seriesRes.addAll((Collection<String>)this.studyMap.get(study));
                }
                return seriesRes;
            }
            return this.studyMap.get(parentId);
        }
        if (childType.equalsIgnoreCase("image")) {
            HashSet<String> imageRes = new HashSet<String>();
            if (parentType.equalsIgnoreCase("patient")) {
                Set<String> studies = this.getChildRecords("patient", parentId, "study");
                for (String study : studies) {
                    Set<String> series = this.getChildRecords("study", study, "series");
                    for (String ser : series) {
                        imageRes.addAll((Collection<String>)this.seriesMap.get(ser));
                    }
                }
                return imageRes;
            }
            if (parentType.equalsIgnoreCase("study")) {
                Set<String> series = this.getChildRecords("study", parentId, "series");
                for (String ser : series) {
                    imageRes.addAll((Collection<String>)this.seriesMap.get(ser));
                }
                return imageRes;
            }
            if (parentType.equalsIgnoreCase("series")) {
                return this.seriesMap.get(parentId);
            }
        }
        return null;
    }

    public String getDBName() {
        return this.dbname;
    }

    public void printStudySeriesMaps() {
        System.out.println("RAMSESSION: RAMImageDB.printStudySeriesMaps() patientMap = " + this.patientMap);
        System.out.println("RAMSESSION: RAMImageDB.printStudySeriesMaps() studyMap = " + this.studyMap);
        System.out.println("RAMSESSION: RAMImageDB.printStudySeriesMaps() seriesMap = " + this.seriesMap);
        System.out.println("RAMSESSION: RAMImageDB.printStudySeriesMaps() imageMap = " + this.imageMap);
    }

    protected DMiImage[] getImageList(String ieType, String id) {
        if (ieType.equalsIgnoreCase("patient")) {
            Set<String> studies = this.patientMap.get(id);
            Iterator<String> i$ = studies.iterator();
            if (i$.hasNext()) {
                String study = i$.next();
                return this.getImageList("study", study);
            }
        } else if (ieType.equalsIgnoreCase("study")) {
            Set<String> series = this.studyMap.get(id);
            Iterator<String> i$ = series.iterator();
            if (i$.hasNext()) {
                String seriesId = i$.next();
                return this.getImageList("series", seriesId);
            }
        } else if (ieType.equalsIgnoreCase("series")) {
            Set<String> images = this.seriesMap.get(id);
            Iterator<String> i$ = images.iterator();
            if (i$.hasNext()) {
                String imageId = i$.next();
                return this.getImageList("image", imageId);
            }
        } else if (ieType.equalsIgnoreCase("image")) {
            XjImage img = this.imageMap.get(id);
            return new RAMImage[]{new RAMImage(img)};
        }
        return null;
    }

    protected DMiImage[] getImagesList(String ieType, String id) {
        Set<String> images = this.getChildRecords(ieType, id, "image");
        ArrayList<RAMImage> ramImgList = new ArrayList<RAMImage>();
        for (String img : images) {
            XjImage xjImg = this.imageMap.get(img);
            ramImgList.add(new RAMImage(xjImg));
        }
        return ramImgList.toArray(new DMiImage[ramImgList.size()]);
    }

    public int getRecordCount(String type) {
        if (type.equalsIgnoreCase("patient")) {
            return this.patientMap.keySet().size();
        }
        if (type.equalsIgnoreCase("study")) {
            return this.studyMap.keySet().size();
        }
        if (type.equalsIgnoreCase("series")) {
            return this.seriesMap.keySet().size();
        }
        if (type.equalsIgnoreCase("image")) {
            return this.imageMap.keySet().size();
        }
        return -1;
    }
}

