/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.pesi;

import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.peer.DMAuxObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectExt1;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.pesi.PesiComposite;
import com.ge.med.terra.tap.dm.pesi.PesiObjectBase;
import com.ge.med.terra.tap.dm.pesi.PesiSession;
import com.ge.med.terra.tap.dm.pesi.VheadersAuxObject;
import com.ge.med.terra.tap.dm.sessionFile.fileImage;
import com.ge.med.terra.tap.dm.sessionFile.fileImageManager;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.DicomComposite;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class PesiObject
extends PesiObjectBase
implements DMiObjectExt1,
DMTagValueInterface {
    File path;
    protected int level;
    protected PesiComposite repComposite = null;
    protected PesiSession session = null;
    public static final int TYPE_IMAGE = 0;
    public static final int TYPE_SERIES = 1;
    public static final int TYPE_STUDY = 2;
    public static final int TYPE_PATIENT = 3;
    static AuxTag imgCount = new AuxTag(){

        @Override
        public Object getValue(PesiObject obj) {
            return new Integer(obj.getNumberOfComposites(null));
        }
    };
    static HashMap auxTagCalc = new HashMap();
    public static final String[] levels;

    public PesiObject(String type, File path, PesiSession ses) {
        if (type == null || path == null) {
            throw new DMException("Illegal arguments to PesiObject Constructor");
        }
        this.level = PesiObject.getLevelNumber(type);
        this.path = path;
        this.session = ses;
    }

    private PesiComposite getRepCompExists() {
        if (this.repComposite == null || !this.repComposite.path.exists()) {
            if (this.level == 0) {
                this.repComposite = this.session.makeNewPesiComposite(this.path);
            } else {
                this.repComposite = this.session.findAComposite(this.path);
                if (this.repComposite == null) {
                    throw new DMException("No composites found under: " + this.path.getAbsolutePath());
                }
            }
        }
        return this.repComposite;
    }

    @Override
    public String getType() {
        return levels[this.level];
    }

    @Override
    public Object getValue(DMTag t) {
        if (t.getGroup() == 1 && auxTagCalc.containsKey(t)) {
            HashMap map;
            if (!this.session.auxCache.containsKey(t)) {
                this.session.auxCache.put(t, new HashMap());
            }
            if ((map = (HashMap)this.session.auxCache.get(t)).containsKey(this.path)) {
                return map.get(this.path);
            }
            AuxTag at = (AuxTag)auxTagCalc.get(t);
            Object o = at.getValue(this);
            map.put(this.path, o);
            return o;
        }
        PesiComposite pc = this.getRepCompExists();
        return pc.getValue(t);
    }

    @Override
    public void getValues(DMElement[] elements) {
        this.getRepCompExists().getValues(elements);
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i].group != 1) continue;
            elements[i].value = this.getValue(new DMTag(1, elements[i].element));
        }
    }

    @Override
    public void setValues(DMElement[] elements) {
        try {
            this.setValuesWork(elements);
        }
        catch (Exception e) {
            throw new DMException("Update failed ... someone else may be updating =" + e.getLocalizedMessage());
        }
        if (this.repComposite != null) {
            PesiObject.clearTags(this.repComposite, elements);
        }
        if (this.session.useER) {
            PesiSession.er.sendEvent("DMEvent.GENERAL_EVENT", "update " + this.getID());
        }
    }

    private static void clearTags(PesiComposite p, DMElement[] elements) {
        p.clearCache();
    }

    private void setValuesWork(DMElement[] elements) throws IOException {
        File f;
        int i;
        File modifiedDir = new File(this.session.rootDir.getParentFile(), "update");
        modifiedDir.mkdir();
        PesiComposite[] comps = (PesiComposite[])this.getComposites(null);
        String[] source = new String[comps.length];
        File[] tmps = new File[comps.length];
        for (i = 0; i < comps.length; ++i) {
            source[i] = comps[i].getFilePath();
            tmps[i] = File.createTempFile("UPDATE", ".DCM", modifiedDir);
        }
        for (i = 0; i < comps.length; ++i) {
            try {
                DicomComposite data = new DicomComposite();
                InputStream fis = comps[i].getInputStream();
                data.read(fis);
                fis.close();
                data.setValues(elements);
                f = tmps[i];
                FileOutputStream fos = new FileOutputStream(f);
                data.write(fos, true);
                fos.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i2 = 0; i2 < comps.length; ++i2) {
            File orig = new File(source[i2]);
            f = File.createTempFile("DELETE", ".DCM", modifiedDir);
            f.delete();
            boolean ret = orig.renameTo(f);
            if (!ret) {
                throw new RuntimeException("unable to rename \"" + source[i2] + "\" to \"" + f + "\"");
            }
            ret = tmps[i2].renameTo(new File(source[i2]));
            if (!ret) {
                System.err.println("unable to rename \"" + tmps[i2] + "\" to \"" + source[i2] + "\" ");
            } else {
                ret = f.delete();
                if (!ret) {
                    System.err.println("unable to delete \"" + f + "\" someone might still have file open");
                }
            }
            PesiObject.clearTags(comps[i2], elements);
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q) {
        if (this.level == 0 && (q == null || q.valid(this.getRepCompExists()))) {
            return new PesiComposite[]{this.getRepCompExists()};
        }
        ArrayList list = new ArrayList();
        this.session.recursivelyFindComposites(this.path, list);
        if (q != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (q.valid((PesiComposite)list.get(i))) continue;
                list.remove(i);
                --i;
            }
        }
        return list.toArray(new PesiComposite[list.size()]);
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Method getLock() not yet implemented.");
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        return this.countFiles(this.path);
    }

    public int countFiles(File f) {
        if (f.isDirectory()) {
            File[] all = f.listFiles(this.session.ffilter);
            int sum = 0;
            for (int i = 0; i < all.length; ++i) {
                if (all[i].isDirectory()) {
                    sum += this.countFiles(all[i]);
                    continue;
                }
                ++sum;
            }
            return sum;
        }
        return 1;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                list.add(ob);
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        return list.toArray(new DMiObject[0]);
    }

    private static int getLevelNumber(String levelString) {
        for (int i = 0; i < levels.length; ++i) {
            if (!levels[i].equalsIgnoreCase(levelString)) continue;
            return i;
        }
        return -1;
    }

    protected void recursivelyFindImages(File root, DMQuery q, DMiObjectReceiver cb) {
        File[] children = root.listFiles();
        for (int i = 0; i < children.length; ++i) {
            boolean b;
            if (children[i].isDirectory()) {
                this.recursivelyFindImages(children[i], q, cb);
                continue;
            }
            if (!children[i].getName().startsWith("i")) continue;
            PesiObject obj = this.makePesiObject("image", children[i], this.session);
            if (q != null && !q.valid(obj) || (b = cb.gotOne(obj))) continue;
            return;
        }
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver cb) {
        if (this.session.checkSOPQuery(ieType, q, cb)) {
            return;
        }
        int delta = PesiObject.getLevelNumber(this.getType()) - PesiObject.getLevelNumber(ieType);
        if (delta == 0) {
            if (q == null || q.valid(this)) {
                cb.gotOne(this);
            }
        } else if (delta < 0) {
            if (q != null && !q.valid(this)) {
                return;
            }
            File f = this.path;
            for (int i = 0; i < -delta; ++i) {
                f = f.getParentFile();
            }
            cb.gotOne(this.makePesiObject(ieType, f, this.session));
        } else {
            this.buildListAtN(this.path, ieType, q, cb, delta);
        }
    }

    private void buildListAtN(File f, String ieType, DMQuery q, DMiObjectReceiver cb, int n) {
        if (n == 0) {
            PesiObject po = this.makePesiObject(ieType, f, this.session);
            if (q == null || q.valid(po)) {
                cb.gotOne(po);
            }
        } else {
            if (f.isFile()) {
                return;
            }
            File[] list = f.listFiles(this.session.ffilter);
            for (int i = 0; i < list.length; ++i) {
                this.buildListAtN(list[i], ieType, q, cb, n - 1);
            }
        }
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    @Override
    public void delete() {
        File f = this.path.getParentFile();
        SimpleUtilities.deleteFilesRecursively(this.path);
        this.cleanup(f);
        this.session.fireEvent(new DMEvent(2, this.path.getAbsolutePath()));
    }

    private void cleanup(File f) {
        while (!f.equals(this.session.rootDir) && f.list().length <= 0) {
            File p = f.getParentFile();
            f.delete();
            f = p;
        }
    }

    @Override
    public DMTag[] getTags() {
        return this.getRepCompExists().getTags();
    }

    @Override
    public void attach() {
    }

    @Override
    public void detach() {
    }

    @Override
    public String getID() {
        return this.path.getAbsolutePath();
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        fileImageManager.getInstance().setPause(true);
        DMiComposite[] comp = this.getComposites(null);
        ArrayList<fileImage> al = new ArrayList<fileImage>(comp.length);
        for (int i = 0; i < comp.length; ++i) {
            fileImage[] imgs = fileImage.getImages(comp[i], tags);
            if (imgs == null) continue;
            for (int k = 0; k < imgs.length; ++k) {
                al.add(imgs[k]);
            }
        }
        fileImageManager.getInstance().setPause(false);
        return al.toArray(new DMiImage[al.size()]);
    }

    protected PesiObject makePesiObject(String type, File path, PesiSession session) {
        return new PesiObject(type, path, session);
    }

    @Override
    public DMAuxObject getAuxObject(String type, Properties info) {
        if ("vheader".equals(type) && VheadersAuxObject.viable(this.level, this.path)) {
            try {
                return new VheadersAuxObject(this.path);
            }
            catch (FileNotFoundException e) {
                throw new DMException(e);
            }
        }
        return null;
    }

    @Override
    public Object send(String[] str) {
        return null;
    }

    static {
        auxTagCalc.put(new DMTag(1, 1280), imgCount);
        auxTagCalc.put(new DMTag(1, 1536), imgCount);
        levels = new String[]{"image", "series", "study", "patient"};
    }

    static interface AuxTag {
        public Object getValue(PesiObject var1);
    }
}

