/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.network.AETitle;
import com.ge.med.terra.tap.dm.network.DefaultSocketHandler;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.ScpSocketHandler;
import com.ge.med.terra.tap.util.dicom.SOPClassUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

@Deprecated
public class scp
extends Thread {
    static final int icommPort = 4921;
    static String cstoreDir;
    static Hashtable sessionTable;
    static String[] QLEVELS;
    private static DMSession session;
    boolean debug;
    String title;
    int[] sops = new int[]{4097, 4119, 4121, 4194, 4195, 4118, 4131, 4158, 4151, 4153, 4165, 4148, 4100, 4130, 4128, 4129, 4142, 4144};
    int[] allowedTS = new int[]{8193, 8195, 8194};
    int localFileTS;
    int maxPduSize = 0;
    private boolean stayUp = true;
    private int port;
    private ServerSocket externalSocket;
    private String sshName;
    private Class sshClass;
    private HashMap services = new HashMap();
    private HashMap serviceNames = new HashMap();
    private HashMap aelist = null;
    private Properties props = null;

    public scp(String title, int port, String cstoreDir) throws IOException {
        this(title, port, cstoreDir, Tap.getProperties());
    }

    public scp(String title, int port, String cstoreDir, Properties props) throws IOException {
        this.props = props;
        this.title = title;
        this.port = port;
        scp.cstoreDir = cstoreDir;
        session = null;
        this.externalSocket = new ServerSocket(port);
        this.debug = this.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.sshName = this.getProperty("tap.nw.ScpSocketHandler", "com.ge.med.terra.tap.dm.nw.DefaultSocketHandler");
        this.maxPduSize = Integer.parseInt(this.getProperty("tap.dm.scp.maxPduSize", "32000"));
        try {
            this.sshClass = Class.forName(this.sshName);
        }
        catch (ClassNotFoundException ex) {
            Tap.log.log(Level.WARNING, "Failed to create SCP. Class not found: {0}", this.sshName);
            throw new DMException(ex);
        }
        this.setupScpServices();
        int[] arr = SOPClassUtil.parseSOPClasses(this.getProperty("tap.dm.scp.SOPClasses"));
        if (arr != null) {
            this.sops = arr;
        }
        if ((arr = SOPClassUtil.parseSOPClasses(this.getProperty("tap.dm.scp.allowedTS"))) != null) {
            this.allowedTS = arr;
        }
        if ((arr = SOPClassUtil.parseSOPClasses(this.getProperty("tap.dm.scp.localFileTS"))) != null) {
            this.localFileTS = arr[0];
        }
        try {
            this.setAETitleList(props);
        }
        catch (Exception ex) {
            Tap.log.warning("Failed initializing default AE titles!");
        }
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String def) {
        String prop = null;
        if (this.props != null) {
            prop = this.props.getProperty(name);
        }
        if (prop == null) {
            prop = Tap.getProperty(name, def);
        }
        return prop;
    }

    private void setupScpServices() {
        String sstr = this.getProperty("tap.nw.ScpServices");
        String[] sarr = sstr.split("\\,");
        if (Tap.logLevel >= Tap.LEVEL_FINE) {
            Tap.log.fine("Services:" + this.services);
        }
        for (int i = 0; i < sarr.length; ++i) {
            String serv = sarr[i].trim();
            ScpService ss = this.getService(serv);
            int[] cmds = ss.getSupportedCommands();
            if (cmds == null) continue;
            for (int j = 0; j < cmds.length; ++j) {
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("Command: <" + cmds[j] + ">, Service: <" + serv + ">");
                }
                this.services.put(new Integer(cmds[j]), ss);
            }
        }
    }

    public ScpService getService(String name) {
        ScpService serv = (ScpService)this.serviceNames.get(name);
        if (serv == null) {
            try {
                Class<?> c = Class.forName(name);
                serv = (ScpService)c.newInstance();
                serv.init(this, this.props);
                this.serviceNames.put(name, serv);
            }
            catch (Exception ex) {
                Tap.log.severe("Failed to initialize service: " + name);
                DMException t = new DMException(ex);
                Tap.log.throwing(this.getName(), "getService", t);
                throw t;
            }
        }
        return serv;
    }

    public ScpService getService(int command2) {
        return (ScpService)this.services.get(new Integer(command2));
    }

    public static DMSession getSession(String aeTitle) {
        return (DMSession)sessionTable.get(aeTitle);
    }

    public static void setSession(String aeTitle, DMSession s) {
        sessionTable.put(aeTitle, s);
    }

    public static DMSession getSession() {
        return session;
    }

    public static void setSession(DMSession s) {
        session = s;
    }

    @Override
    public void run() {
        if (cstoreDir != null) {
            new File(cstoreDir).mkdir();
        }
        if (Tap.logLevel <= Tap.LEVEL_FINE) {
            Tap.log.log(Level.FINE, "Port# = {0}", this.port);
            Tap.log.log(Level.FINE, "AE Title = {0}", this.title);
            Tap.log.log(Level.FINE, "C-STORE Location = {0}", cstoreDir);
            if (session != null) {
                StringBuffer buffer = new StringBuffer("Database= ");
                buffer.append(session.getProperty(DMUtils.PROPERTY_SESSION_TYPE));
                buffer.append("|");
                buffer.append(session.getProperty(DMUtils.PROPERTY_SESSION_REP));
                String[] sessionArgs = (String[])session.getProperty(DMUtils.PROPERTY_SESSION_ARGS);
                for (int i = 0; sessionArgs != null && i < sessionArgs.length; ++i) {
                    buffer.append("|");
                    buffer.append(sessionArgs[i]);
                }
                Tap.log.fine(buffer.toString());
            }
            Tap.log.fine("scp up ...");
        }
        while (this.stayUp) {
            try {
                Socket external = this.externalSocket.accept();
                Tap.log.fine("externalSocket.accept() .. creating new ExternalSocketHandler");
                ScpSocketHandler ssh = null;
                try {
                    ssh = (ScpSocketHandler)this.sshClass.newInstance();
                }
                catch (Exception ex) {
                    Tap.log.log(Level.WARNING, "Failed to instantiate ScpSocketHandler: <{0}>, will use DefaultSocketHandler", this.sshClass);
                }
                if (ssh == null) {
                    ssh = new DefaultSocketHandler();
                }
                ssh.init(this.title, external, this);
                ssh.start();
            }
            catch (IOException e) {
                Tap.log.info("SCP external socket going down...");
            }
        }
        Tap.log.info("SCP stopped handling requests");
    }

    public void end() {
        try {
            this.stayUp = false;
            this.externalSocket.close();
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Exception caught during end(): ", e);
        }
    }

    public void setAETitleList(HashMap aelist) {
        this.aelist = aelist;
    }

    public HashMap getAETitleList() {
        return this.aelist;
    }

    public void setAETitleList(Properties props) {
        if (null == props) {
            return;
        }
        int numae = Integer.parseInt(props.getProperty("numAETitles", "0"));
        if (numae == 0) {
            return;
        }
        Tap.log.log(Level.FINE, "numAETitles: {0}", numae);
        this.aelist = new HashMap();
        for (int i = 0; i < numae; ++i) {
            String ae = props.getProperty("AETitle_" + (i + 1));
            if (ae == null) continue;
            String[] vals = ae.split("\\,");
            try {
                AETitle aeo = new AETitle(vals[0].trim(), vals[1].trim(), Integer.parseInt(vals[2].trim()));
                this.aelist.put(vals[0], aeo);
                if (!this.debug) continue;
                Tap.log.info(aeo.toString());
                continue;
            }
            catch (Exception ex) {
                Tap.log.log(Level.WARNING, "Failed parsing AE titles configuration: <" + ae + ">: ", ex);
            }
        }
    }

    public static void usage() {
        System.err.println("com.ge.med.terra.tap.dm.network.scp <PortNum> <StorageDir> <terra|directory>");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            String[] stringArray;
            String aeTitle;
            if (args.length < 3) {
                scp.usage();
            }
            if ((aeTitle = InetAddress.getLocalHost().getHostName()).indexOf(46) != -1) {
                aeTitle = new StringTokenizer(aeTitle, ".").nextToken();
            }
            scp scpServer = new scp(aeTitle, Integer.parseInt(args[0]), args[1]);
            if (args[2].equals("terra")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "terra";
                stringArray2[1] = "terradb";
                stringArray = stringArray2;
                stringArray2[2] = "localhost";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "file";
                stringArray = stringArray3;
                stringArray3[1] = args[2];
            }
            String[] sessionArgs = stringArray;
            scp.setSession(new DMSession(sessionArgs));
            scpServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    static {
        sessionTable = new Hashtable();
        QLEVELS = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    }
}

