/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.network.NWUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Random;

@Deprecated
public class ncreate {
    public static int OK = 0;
    public static int NOT_OK = 1;
    Random rand = new Random();
    int range = 100;
    Association as;
    int pContext = 4142;
    int[] tsids = new int[]{8193, 8195, 8194};
    String called;
    String calling;
    String host;
    int port;
    private Socket socket;

    public ncreate(String calledTitle, String calledHost, int port, String callingTitle) throws Exception {
        this.called = calledTitle;
        this.calling = callingTitle;
        this.host = calledHost;
        this.port = port;
    }

    public static boolean debug() {
        return Tap.getProperty("tap.dm.nw.debug", "false").equalsIgnoreCase("true");
    }

    public int makeAssociation() throws DMException, Exception {
        this.socket = new Socket(this.host, this.port);
        this.as = NWUtils.createAssociation(this.socket);
        Request request = new Request();
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        request.setMaxPduSize(16352);
        request.addPresentationContext(this.pContext, this.tsids);
        if (ncreate.debug()) {
            request.toString();
        }
        this.as.sendAssociateRequest(request);
        Response response = this.as.receiveAssociateResponse();
        if (ncreate.debug()) {
            response.toString();
        }
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    return OK;
                }
                case 3: {
                    System.out.println("abstract syntax not supported");
                    throw new DMException("abstract syntax not supported" + result);
                }
                case 4: {
                    System.out.println("transfer syntaxes not supported");
                    throw new DMException("transfer syntaxes not supported" + result);
                }
                case 1: {
                    System.out.println("user rejection of presentation context");
                    throw new DMException("user rejection of presentation context" + result);
                }
                case 2: {
                    System.out.println("presentation context refused, no reason given");
                    throw new DMException("presentation context refused, no reason given" + result);
                }
            }
            System.out.println("Unknown Result for Abstract Syntax");
            throw new DMException("Unknown Result for Abstract Syntax" + result);
        }
        if (response instanceof Reject) {
            System.out.println("association rejected: " + response);
            throw new DMException("association rejected: " + response);
        }
        if (response instanceof Abort) {
            System.out.println("association aborted: " + response);
            throw new DMException("association aborted: " + response);
        }
        System.out.println("unknown error");
        throw new DMException("unknown error" + response);
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doNCreate(DicomObject dataSet) throws DMException, Exception {
        int commandfield;
        DicomObject req = DimseUtil.createCreateRequest(new Integer(this.rand.nextInt(this.range)), new Integer(this.pContext), (String)dataSet.get(63), true);
        if (ncreate.debug()) {
            req.dumpVRs(System.out);
            dataSet.dumpVRs(System.out);
        }
        this.as.send(this.pContext, req, dataSet);
        DicomObject res = this.as.receiveCommand();
        if (ncreate.debug()) {
            res.dumpVRs(System.out);
        }
        if ((commandfield = res.getI(3)) != 33088) {
            System.out.println("No N-CREATE RESPONSE command field : " + Integer.toHexString(commandfield));
            this.abortAssociation();
            throw new DMException("No N-CREATE RESPONSE command field : " + Integer.toHexString(commandfield));
        }
        String sopclass = res.getS(1);
        if (sopclass != null && UID.getUIDEntry(sopclass).getConstant() != this.pContext) {
            System.out.println("Affected SOP Class UID in N-CREATE RESPONSE wrong: " + sopclass);
            this.abortAssociation();
            throw new DMException("Affected SOP Class UID in N-CREATE RESPONSE wrong: " + sopclass);
        }
        int status = res.getI(9);
        if (status == 0) {
            return OK;
        }
        throw new DMException("N-CREATE status return not OK" + status);
    }

    public static void main(String[] args) {
        if (args.length < 5) {
            System.out.println("Usage: com.ge.med.terra.tap.dm.network.cstore calledAE calledHost calledPort callingAE file");
            return;
        }
        try {
            ncreate cm = new ncreate(args[0], args[1], Integer.parseInt(args[2]), args[3]);
            if (cm.makeAssociation() == OK) {
                DicomObject dataSet = new DicomObject();
                FileInputStream fis = new FileInputStream(args[4]);
                dataSet.read(fis);
                fis.close();
                dataSet.set(1207, "COMPLETED");
                dataSet.set(63, "1.2.40.0.13.0.192.168.0.3.4779445.1033855674290.9999");
                if (cm.doNCreate(dataSet) == OK) {
                    System.out.println("N-CREATE Successful");
                    cm.releaseAssociation();
                } else {
                    System.out.println("N-CREATE Failed");
                    cm.abortAssociation();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

