/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.network.NWUtils;
import com.ge.med.terra.tap.dm.network.networkSession;
import com.ge.med.terra.tap.util.dicom.FixedStream;
import com.ge.med.terra.tap.util.dicom.SOPClassUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.Random;

@Deprecated
public class cstore {
    public static int OK = 0;
    public static int NOT_OK = 1;
    Random rand = new Random();
    int range = 100;
    Association as;
    int associationTransferSyntax = -1;
    int maxPduSize = Integer.parseInt(Tap.getProperty("tap.dm.scu.cstoreMaxPduSize", "16352"));
    boolean debug = Tap.getProperty("tap.dm.nw.debug", "false").equalsIgnoreCase("true");
    int pContext;
    int[] tsids = new int[]{8195, 8194, 8193};
    private int socketTmo = Integer.parseInt(Tap.getProperty("tap.dm.nw.socketTmo", "0"));
    String called;
    String calling;
    String host;
    int port;
    private Socket socket;

    public cstore(String calledTitle, String calledHost, int port, String callingTitle) throws Exception {
        this(calledTitle, calledHost, port, callingTitle, null);
    }

    public cstore(String calledTitle, String calledHost, int port, String callingTitle, Properties props) throws Exception {
        int[] arr;
        this.called = calledTitle;
        this.calling = callingTitle;
        this.host = calledHost;
        this.port = port;
        String tp = null;
        if (props != null && (tp = props.getProperty("TransferParams")) != null) {
            this.tsids = networkSession.parseTransferParams(tp);
        }
        if ((props == null || tp == null) && (arr = SOPClassUtil.parseSOPClasses(Tap.getProperty("tap.dm.scu.cstoreTS"))) != null) {
            this.tsids = arr;
        }
    }

    public int makeAssociation(String SOPClassUID2) throws Exception {
        try {
            if (this.debug) {
                System.out.println("looking for: " + SOPClassUID2);
            }
            this.pContext = UID.getUIDEntry(SOPClassUID2).getConstant();
        }
        catch (UnknownUIDException e) {
            e.printStackTrace();
            this.pContext = 0;
        }
        System.out.println("cstore: connecting to: " + this.host + ":" + this.port);
        this.socket = new Socket(this.host, this.port);
        this.as = NWUtils.createAssociation(this.socket);
        Request request = new Request();
        System.out.println("Making association: calledAE= \"" + this.called + "\", callingAE= \"" + this.calling + "\" SOPClassUID=\"" + SOPClassUID2 + "\"");
        request.setCalledTitle(this.called);
        request.setCallingTitle(this.calling);
        request.setMaxPduSize(this.maxPduSize);
        request.addPresentationContext(this.pContext, this.tsids);
        this.as.sendAssociateRequest(request);
        this.socket.setSoTimeout(this.socketTmo);
        Response response = this.as.receiveAssociateResponse();
        if (response instanceof Acknowledge) {
            Acknowledge ack = (Acknowledge)response;
            if (this.debug) {
                System.out.println("TS[0]= " + ack.getTransferSyntax(0).getName());
            }
            this.associationTransferSyntax = ack.getTransferSyntax(0).getConstant();
            int result = ResponsePolicy.getResultForAbstractSyntax(request, ack, this.pContext);
            switch (result) {
                case 0: {
                    return OK;
                }
                case 3: {
                    throw new DMException("abstract syntax not supported");
                }
                case 4: {
                    throw new DMException("transfer syntaxes not supported");
                }
                case 1: {
                    throw new DMException("user rejection of presentation context");
                }
                case 2: {
                    throw new DMException("presentation context refused, no reason given");
                }
            }
            throw new DMException("Unknown Result for Abstract Syntax");
        }
        if (response instanceof Reject) {
            throw new DMException("association rejected: " + response);
        }
        if (response instanceof Abort) {
            throw new DMException("association aborted: " + response);
        }
        throw new DMException("unknown error when making association");
    }

    public void releaseAssociation() throws IOException, IllegalValueException {
        if (this.socket != null && this.as != null) {
            this.as.sendReleaseRequest();
            this.as.receiveReleaseResponse();
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public void abortAssociation() throws IOException {
        if (this.socket != null && this.as != null) {
            this.as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
            this.socket.close();
            this.as = null;
            this.socket = null;
        }
    }

    public int doStore(DicomObject dataSet) {
        try {
            int commandfield;
            Integer i1 = new Integer(this.rand.nextInt(this.range));
            Integer i2 = new Integer(UID.getUIDEntry((String)dataSet.get(62)).getConstant());
            Integer i3 = new Integer(0);
            DicomObject req = DimseUtil.createStoreRequest(i1, i2, i3, (String)dataSet.get(63), this.calling, "0");
            this.as.send(i2, req, dataSet);
            DicomObject res = this.as.receiveCommand();
            if (this.debug) {
                System.out.println("cstore: request response:");
                res.dumpVRs(System.out);
            }
            if ((commandfield = res.getI(3)) != 32769) {
                System.out.println("No C-STORE RESPONSE command field : " + Integer.toHexString(commandfield));
                this.abortAssociation();
                throw new DMException("No C-STORE RESPONSE command field : " + Integer.toHexString(commandfield));
            }
            String sopclass = res.getS(1);
            if (sopclass != null && UID.getUIDEntry(sopclass).getConstant() != i2.intValue()) {
                System.out.println("Affected SOP Class UID in C-STORE RESPONSE wrong: " + sopclass);
                this.abortAssociation();
                throw new DMException("Affected SOP Class UID in C-STORE RESPONSE wrong: " + sopclass);
            }
            int status = res.getI(9);
            if (status == 0) {
                return OK;
            }
            return NOT_OK;
        }
        catch (Exception e) {
            throw new DMException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileInputStream fis = null;
        try {
            if (args.length < 5) {
                System.out.println("Usage: com.ge.med.terra.tap.dm.network.cstore calledAE calledHost calledPort callingAE file");
                return;
            }
            fis = new FileInputStream(args[4]);
            Tap.getProperty("");
            cstore cs = new cstore(args[0], args[1], Integer.parseInt(args[2]), args[3]);
            DicomObject dataSet = new DicomObject();
            dataSet.read(new FixedStream(fis));
            if (cs.makeAssociation((String)dataSet.get(62)) == OK) {
                if (cs.doStore(dataSet) == OK) {
                    System.out.println("C-STORE Successful");
                    cs.releaseAssociation();
                } else {
                    System.out.println("C-STORE Failed");
                    cs.abortAssociation();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                }
            }
        }
    }
}

