/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.scp;
import java.io.FileOutputStream;
import java.util.Properties;

@Deprecated
public class ScpSet
implements ScpService {
    boolean init = false;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{288};
    int[] sops = new int[]{4142};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 288) {
            return this.doSet(as, dcm, response);
        }
        return false;
    }

    public boolean doSet(Association as, DicomObject dcm, Response response) {
        try {
            String pps_sopclass = UID.getUIDEntry(4142).getValue();
            String sopclass = dcm.getS(2);
            if (!sopclass.equals(pps_sopclass)) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("wrong sop class in N-SET REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            Integer messageid = (Integer)dcm.get(4);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("message ID missing from N-SET REQUEST, aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            int dataSetType = dcm.getI(8);
            if (dataSetType == 257) {
                if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                    Tap.log.warning("No Data Set present as per Data Set Type tag, Aborting C-Store");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.INVALID_PDU_PARAMETER_VALUE);
                return false;
            }
            int associationTS = -1;
            if (response instanceof Acknowledge) {
                associationTS = ((Acknowledge)response).getTransferSyntax(0).getConstant();
            }
            DicomObject data = as.receiveData();
            DicomObject meta = new DicomObject();
            meta.set(28, new byte[]{0, 1});
            meta.set(29, pps_sopclass);
            meta.set(30, dcm.get(14));
            meta.set(31, UID.getUIDEntry(associationTS).getValue());
            meta.set(33, "GSP_TAP");
            data.setFileMetaInformation(meta);
            FileOutputStream fout = new FileOutputStream(scp.cstoreDir + "/" + dcm.get(14));
            data.write(fout, true);
            fout.close();
            DicomObject responsedcm = new DicomObject();
            responsedcm.set(3, new Integer(33056));
            responsedcm.set(5, messageid);
            responsedcm.set(8, new Integer(257));
            responsedcm.set(9, new Integer(0));
            as.send(4142, responsedcm, null);
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("sent N-SET RESPONSE");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

