/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomObject;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.UID;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.DimseUtil;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMComposite;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.network.AETitle;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.cfind;
import com.ge.med.terra.tap.dm.network.cstore;
import com.ge.med.terra.tap.dm.network.scp;
import com.ge.med.terra.tap.util.dicom.DicomData;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

@Deprecated
public class ScpMove
implements ScpService {
    boolean init = false;
    scp scp;
    Properties props = null;
    boolean debug = false;
    int[] cmds = new int[]{33};
    int[] sops = new int[]{4133, 4136, 4139};

    @Override
    public void init(scp scp2, Properties props) {
        this.debug = Tap.getProperty("tap.dm.scp.debug", "false").equalsIgnoreCase("true");
        this.scp = scp2;
        this.props = props;
        this.init = true;
    }

    @Override
    public int[] getSupportedSOPClass() {
        return this.sops;
    }

    @Override
    public int[] getSupportedCommands() {
        return this.cmds;
    }

    @Override
    public boolean doCommand(int command2, Association as, DicomObject dcm, Request request, Response response) {
        if (command2 == 33) {
            return this.doMove(as, dcm, request);
        }
        return false;
    }

    public boolean doMove(Association as, DicomObject dcm, Request request) {
        DicomObject rdcm = new DicomObject();
        String caller = request.getCallingTitle();
        try {
            String sopclass = dcm.getS(1);
            int supportedSOPClass = -1;
            for (int i = 0; i < this.sops.length; ++i) {
                if (!sopclass.equals(UID.getUIDEntry(this.sops[i]).getValue())) continue;
                supportedSOPClass = i;
                break;
            }
            if (supportedSOPClass == -1) {
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("wrong sop class in C-MOVE REQUEST: " + sopclass + " , aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            Integer messageid = (Integer)dcm.get(4);
            if (messageid == null) {
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("message ID missing from C-MOVE REQUEST, aborting");
                }
                as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                return false;
            }
            DicomObject qdcm = as.receiveData();
            if (this.debug) {
                System.out.println("C-MOVE query object: ");
                qdcm.dumpVRs(System.out);
            }
            String level = (String)qdcm.get(78);
            qdcm.set(78, null);
            rdcm.set(78, level);
            Enumeration elements = qdcm.enumerateVRs(true);
            Vector<TagValue> tags = new Vector<TagValue>();
            while (elements.hasMoreElements()) {
                TagValue vr2 = (TagValue)elements.nextElement();
                if (vr2.getElement() == 0 || vr2.getGroup() == 8 && vr2.getElement() == 82) {
                    if (!elements.hasMoreElements()) break;
                    vr2 = (TagValue)elements.nextElement();
                }
                tags.add(vr2);
            }
            tags.add(new TagValue());
            DMSession ses = com.ge.med.terra.tap.dm.network.scp.getSession();
            if (ses == null) {
                ses = (DMSession)com.ge.med.terra.tap.dm.network.scp.sessionTable.get(caller);
            }
            if (ses == null) {
                new File(com.ge.med.terra.tap.dm.network.scp.cstoreDir + File.separatorChar + caller).mkdir();
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("Making new DMSession: " + com.ge.med.terra.tap.dm.network.scp.cstoreDir + File.separatorChar + caller);
                }
                ses = new DMSession("file", com.ge.med.terra.tap.dm.network.scp.cstoreDir + File.separatorChar + caller, null);
                com.ge.med.terra.tap.dm.network.scp.sessionTable.put(caller, ses);
            }
            DMQuery q = new DMQuery(new DicomData(qdcm));
            if (this.debug) {
                System.out.println("DMquery: " + q.toString());
            }
            String pid = (String)qdcm.get(148);
            DMObject[] objs = null;
            if (pid != null) {
                objs = ses.getRelated("patient", new DMQuery("(0x0010, 0x0020) = " + pid));
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("patient level PRE getRelated(): " + (objs == null ? 0 : objs.length));
                }
            }
            for (int l = 0; l < com.ge.med.terra.tap.dm.network.scp.QLEVELS.length; ++l) {
                if (!level.equalsIgnoreCase(com.ge.med.terra.tap.dm.network.scp.QLEVELS[l])) continue;
                DMObject[] dMObjectArray = objs = objs == null || objs.length == 0 ? ses.getRelated(level, q) : objs[0].getRelated(level, q);
                if (Tap.logLevel < Tap.LEVEL_FINE) break;
                Tap.log.fine(level + " level getRelated(): " + (objs == null ? 0 : objs.length));
                break;
            }
            DMComposite[][] comps = new DMComposite[objs == null ? 0 : objs.length][];
            int tot_comps = 0;
            if (objs != null) {
                for (int i = 0; i < objs.length; ++i) {
                    comps[i] = objs[i].getComposites();
                    tot_comps += comps[i].length;
                }
            }
            if (Tap.logLevel >= Tap.LEVEL_FINE) {
                Tap.log.fine("tot_comps:" + tot_comps);
            }
            if (tot_comps > 0) {
                int remaining = tot_comps;
                int completed = 0;
                int failed = 0;
                int warning = 0;
                DicomObject cmd = DimseUtil.createMoveResponse(messageid, new Integer(this.sops[supportedSOPClass]), true, new Integer(65280), new Integer(remaining), new Integer(completed), new Integer(failed), new Integer(warning));
                HashMap aelist = this.scp.getAETitleList();
                AETitle aeo = null;
                if (aelist != null) {
                    String aename = (String)dcm.get(6);
                    if (Tap.logLevel >= Tap.LEVEL_FINE) {
                        Tap.log.fine("Looking for AE:" + aename);
                    }
                    if ((aeo = (AETitle)aelist.get(aename)) == null) {
                        if (Tap.logLevel >= Tap.LEVEL_WARNING) {
                            Tap.log.warning("Cannot locate configuration of destination AE tilte: <" + aename + ">");
                        }
                        as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.UNEXPECTED_PDU_PARAMETER);
                        return false;
                    }
                }
                for (int o = 0; o < comps.length; ++o) {
                    for (int c = 0; c < comps[o].length; ++c) {
                        DMComposite comp = comps[o][c];
                        String sopClassUID = (String)comp.getValue(8, 24);
                        cstore cs = new cstore(aeo.getTitle(), aeo.getHost(), aeo.getPort(), this.scp.title, null);
                        DicomObject dataset = new DicomObject();
                        dataset.read(comp.getInputStream());
                        if (cs.makeAssociation((String)dataset.get(62)) == cstore.OK) {
                            if (cs.doStore(dataset) == cstore.OK) {
                                ++completed;
                                cs.releaseAssociation();
                                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                                    Tap.log.fine("C-STORE Succeeded");
                                }
                            } else {
                                ++failed;
                                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                                    Tap.log.fine("C-STORE Failed");
                                }
                                cs.abortAssociation();
                            }
                            --remaining;
                        }
                        cmd.set(19, new Integer(remaining));
                        cmd.set(20, new Integer(completed));
                        cmd.set(21, new Integer(failed));
                        cmd.set(22, new Integer(warning));
                        cmd.set(8, cfind.NO_DATA);
                        if (this.debug) {
                            System.out.println("sending C-MOVE RESPONSE: " + completed);
                            cmd.dumpVRs(System.out);
                        }
                        as.send(this.sops[supportedSOPClass], cmd, null);
                    }
                }
                cmd.set(9, new Integer(0));
                cmd.set(8, cfind.NO_DATA);
                if (Tap.logLevel >= Tap.LEVEL_FINE) {
                    Tap.log.fine("sending C-MOVE RESPONSE: COMPLETED");
                }
                as.send(this.sops[supportedSOPClass], cmd, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

