/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.network;

import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.IllegalValueException;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.network.Abort;
import com.archimed.dicom.network.Acknowledge;
import com.archimed.dicom.network.Association;
import com.archimed.dicom.network.Reject;
import com.archimed.dicom.network.Request;
import com.archimed.dicom.network.Response;
import com.archimed.dicom.network.ResponsePolicy;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.network.NWUtils;
import com.ge.med.terra.tap.dm.network.ScpService;
import com.ge.med.terra.tap.dm.network.ScpSocketHandler;
import com.ge.med.terra.tap.dm.network.scp;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;

@Deprecated
public class DefaultSocketHandler
implements ScpSocketHandler {
    private Socket s;
    private String title;
    private int[] sops;
    private int[] allowedTS;
    private int maxPduSize;
    private boolean debug = false;
    private scp scp;

    @Override
    public void init(String title, Socket s, scp scp2) {
        this.s = s;
        this.title = title;
        this.sops = scp2.sops;
        this.allowedTS = scp2.allowedTS;
        this.debug = scp2.debug;
        this.maxPduSize = scp2.maxPduSize;
        this.scp = scp2;
    }

    @Override
    public void start() {
        new Thread(){

            @Override
            public void run() {
                DefaultSocketHandler.this.go();
            }
        }.start();
    }

    public void go() {
        Association as = null;
        try {
            as = NWUtils.createAssociation(this.s);
            Request request = as.receiveAssociateRequest();
            if (this.debug) {
                Tap.log.info("********* SCP received request from: " + request.getCallingTitle());
            }
            Response response = ResponsePolicy.prepareResponse(request, this.title, null, this.sops, this.allowedTS, false);
            String caller = request.getCallingTitle();
            if (response instanceof Acknowledge) {
                ((Acknowledge)response).setMaxPduSize(this.maxPduSize);
                if (this.debug) {
                    Tap.log.info("Setting scp MaxPduSize: " + this.maxPduSize);
                }
            }
            if (this.debug) {
                Tap.log.info("********* SCP sending response: " + (response instanceof Acknowledge ? "Acknowledge" : "Reject"));
            }
            as.sendAssociateResponse(response);
            if (response instanceof Reject) {
                Tap.log.warning("Association request from " + caller + " rejected");
                Tap.log.warning("Reason: " + ((Reject)response).toString());
                this.s.close();
                return;
            }
            if (response instanceof Acknowledge) {
                while (true) {
                    int result;
                    if ((result = as.peek()) == 10) {
                        int command2;
                        ScpService serv;
                        if (this.debug) {
                            Tap.log.info("result == Association.PDATA_PDU");
                        }
                        DicomObject dcm = as.receiveCommand();
                        if (this.debug) {
                            dcm.dumpVRs(System.err);
                        }
                        if ((serv = this.scp.getService(command2 = dcm.getI(3))) != null) {
                            serv.doCommand(command2, as, dcm, request, response);
                            continue;
                        }
                        Tap.log.warning("Unsupported command received: " + command2 + ", aborting");
                        as.sendAbort(Abort.DICOM_UL_SERVICE_USER, Abort.REASON_NOT_SPECIFIED);
                        break;
                    }
                    if (result == 11) {
                        if (this.debug) {
                            Tap.log.info("result == Association.RELEASE_REQUEST");
                        }
                        try {
                            as.receiveReleaseRequest();
                            as.sendReleaseResponse();
                        }
                        catch (SocketException se) {
                            Tap.log.warning("peer/socket disappeared before I could handle Association Release Request");
                        }
                        break;
                    }
                    if (result == 12) {
                        if (this.debug) {
                            Tap.log.info("result == Association.ABORT");
                        }
                        try {
                            Abort abort = as.receiveAbort();
                            Tap.log.info(abort.toString());
                        }
                        catch (SocketException se) {
                            Tap.log.warning("peer/socket disappeared before I could receive Association Abort");
                        }
                        break;
                    }
                    if (!this.debug) continue;
                    Tap.log.info("result == <" + result + ">");
                }
                Tap.log.info("Closing SCP socket handler");
                this.s.close();
                return;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            try {
                this.s.close();
            }
            catch (Exception ex) {
                Tap.log.warning("Failed closing socket: ");
                ex.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IllegalValueException e) {
            e.printStackTrace();
        }
        catch (DicomException e) {
            e.printStackTrace();
        }
        catch (UnknownUIDException e) {
            e.printStackTrace();
        }
    }
}

