/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.mwl;

import com.archimed.dicom.DicomObject;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMUtils;
import com.ge.med.terra.tap.dm.mwl.CEcho;
import com.ge.med.terra.tap.dm.mwl.CFind;
import com.ge.med.terra.tap.dm.mwl.MwlObject;
import com.ge.med.terra.tap.dm.mwl.MwlUtils;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.util.dicom.DicomData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

@Deprecated
public class MwlSession
implements DMiSession {
    protected static final String TRANSFER_PARAMS = "TransferParams";
    private static final String[] MWL_PARAMS = new String[]{DMUtils.NW_INIT_CALLED_AE, DMUtils.NW_INIT_CALLED_HOST, DMUtils.NW_INIT_CALLED_PORT, DMUtils.NW_INIT_CALLING_AE, DMUtils.NW_INIT_IMPL_CLASS_UID, "TransferParams"};
    private static final Set<String> SUPPORTED_PARAMS = new HashSet<String>(MWL_PARAMS.length);
    private static final String[] TS_PARAMS = new String[]{"ImplicitVRLittleEndian", "ExplicitVRLittleEndian", "ExplicitVRBigEndian"};
    private static final int[] TS_VALUES = new int[]{8193, 8194, 8195};
    private static final Map<String, Integer> TS_MAP = new HashMap<String, Integer>(TS_PARAMS.length);
    protected CFind cf;
    protected Map<String, MwlObject> studyCache = new HashMap<String, MwlObject>();
    protected Map<String, MwlObject> patientCache = new HashMap<String, MwlObject>();
    private Properties props = null;
    private String repType;
    private String calledAE;
    private String callingAE;
    private String calledHost;
    private int calledPort;

    @Override
    public void init(String repType, String[] args) {
        this.repType = repType;
        if (args[0].indexOf("=") == -1) {
            this.calledAE = args[0];
            this.callingAE = args[1];
            this.calledHost = args[2];
            this.calledPort = Integer.parseInt(args[3].trim());
        } else {
            this.parseNamedParams(args);
            this.calledAE = this.props.getProperty(DMUtils.NW_INIT_CALLED_AE).trim();
            this.calledHost = this.props.getProperty(DMUtils.NW_INIT_CALLED_HOST).trim();
            this.calledPort = Integer.parseInt(this.props.getProperty(DMUtils.NW_INIT_CALLED_PORT).trim());
            this.callingAE = this.props.getProperty(DMUtils.NW_INIT_CALLING_AE).trim();
            String implclassuid = this.props.getProperty(DMUtils.NW_INIT_IMPL_CLASS_UID);
            if (null != implclassuid) {
                MwlUtils.setImplementationClassUID(implclassuid);
            }
        }
        try {
            this.cf = new CFind(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.props);
            this.cf.makeAssociation();
        }
        catch (Exception ex) {
            Tap.log.warning("Unable to establish C-FIND association");
            this.close();
            throw new RuntimeException(ex);
        }
    }

    public static boolean debug() {
        return Tap.getProperty("tap.dm.mwl.debug", "false").equalsIgnoreCase("true");
    }

    @Override
    public DMiComposite getComposite(String id) {
        throw new UnsupportedOperationException("Method getComposite() not supported by MWL sessions.");
    }

    @Override
    public DMiComposite[] getComposites() {
        throw new UnsupportedOperationException("Method getComposites() not supported by MWL sessions.");
    }

    @Override
    public int getNumberOfComposites() {
        throw new UnsupportedOperationException("Method getNumberOfComposites() not supported by MWL sessions.");
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated("patient", q);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver callback) {
        DMiObject[] objs = this.getChildren(q);
        for (int i = 0; i < objs.length && callback.gotOne(objs[i]); ++i) {
        }
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        DMiObject[] mwlobjs = null;
        ArrayList<MwlObject> mwlList = new ArrayList<MwlObject>();
        if (ieType.equalsIgnoreCase("patient") || ieType.equalsIgnoreCase("study") || ieType.equalsIgnoreCase("exam")) {
            try {
                if (0 == this.cf.makeAssociation()) {
                    DicomObject dataSet = MwlSession.tapToDicomMwlQuery(q);
                    this.cf.doFind(dataSet);
                    DicomObject[] objs = this.cf.getObjects();
                    this.buildMwlHierarchy(objs);
                    Collection<MwlObject> values = ieType.equalsIgnoreCase("patient") ? this.patientCache.values() : this.studyCache.values();
                    for (MwlObject mwlobj : values) {
                        if (null != q && !Boolean.getBoolean("tap.mwlsession.skipMWLQueryValidation") && !q.valid(mwlobj)) continue;
                        mwlList.add(mwlobj);
                    }
                }
                Tap.log.fine("Failed to make C-FIND association in getRelated()");
            }
            catch (Exception ex) {
                throw new DMException(ex.getMessage());
            }
        } else {
            throw new DMException("Invalid IE type: " + ieType);
        }
        mwlobjs = mwlList.toArray(new MwlObject[mwlList.size()]);
        return mwlobjs;
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver callback) {
        DMiObject[] objs = this.getRelated(ieType, q);
        for (int i = 0; i < objs.length && callback.gotOne(objs[i]); ++i) {
        }
    }

    protected void buildMwlHierarchy(DicomObject[] objs) {
        this.studyCache.clear();
        this.patientCache.clear();
        for (int i = 0; i < objs.length; ++i) {
            MwlObject patient2;
            String patientID = MwlObject.getPatientID(objs[i]);
            String studyID = MwlObject.getStudyID(objs[i]);
            MwlObject study = this.studyCache.get(studyID);
            if (null == study) {
                study = new MwlObject("study", this, objs[i]);
                this.studyCache.put(studyID, study);
            }
            if (null == (patient2 = this.patientCache.get(patientID))) {
                patient2 = new MwlObject("patient", this, objs[i]);
                this.patientCache.put(patientID, patient2);
            }
            study.ref.add(patient2);
            patient2.ref.add(study);
        }
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        throw new UnsupportedOperationException("Method save() not supported by MWL sessions.");
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        for (int i = 0; i < o.length; ++i) {
            this.save(o[i], prop);
        }
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        throw new UnsupportedOperationException("Method save() not supported by MWL sessions.");
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
    }

    @Override
    public void install(InputStream is) throws DMException {
        throw new UnsupportedOperationException("Method install() not supported by MWL sessions.");
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        throw new UnsupportedOperationException("Method installFiles() not supported by MWL sessions.");
    }

    @Override
    public String[] send(String str) {
        if (str.equals(DMUtils.MSG_PING_REMOTE_SCP)) {
            return new String[]{Boolean.toString(this.pingRemote()).toString()};
        }
        return null;
    }

    @Override
    public DMiJob asynSend(String str) {
        throw new UnsupportedOperationException("Method asynSend() not supported by MWL sessions.");
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        throw new UnsupportedOperationException("Method getDMiObject() not supported by MWL sessions.");
    }

    @Override
    public void ClearCache() {
    }

    @Override
    public DMiJob[] getJobs() {
        throw new UnsupportedOperationException("Method getJobs() not supported by MWL sessions.");
    }

    private void parseNamedParams(String[] args) {
        this.props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            String param = args[i];
            int ind = param.indexOf("=");
            if (ind == -1) {
                throw new RuntimeException("Wrong parameter syntax: " + param);
            }
            String pname = param.substring(0, ind);
            String pvalue = param.substring(ind + 1);
            if (pname.equals(TRANSFER_PARAMS)) {
                try {
                    MwlSession.parseTransferParams(pvalue);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unknown transfer syntax: " + param);
                }
            }
            this.props.setProperty(pname, pvalue);
            if (SUPPORTED_PARAMS.contains(pname)) continue;
            Tap.log.log(Level.WARNING, "Non MwlSession Parameter: {0}", pname);
        }
    }

    public static int[] parseTransferParams(String tp) {
        String[] p = tp.split("\\,");
        int[] tsids = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            tsids[i] = TS_MAP.get(p[i].trim());
        }
        return tsids;
    }

    public String getProperty(String name) {
        return this.getProperty(name, null);
    }

    public String getProperty(String name, String def) {
        String prop = null;
        if (this.props != null) {
            prop = this.props.getProperty(name);
        }
        if (prop == null) {
            prop = Tap.getProperty(name, def);
        }
        return prop != null ? prop.trim() : null;
    }

    public static DicomObject tapToDicomMwlQuery(DMQuery q) {
        DicomObject dataSet = new DicomObject();
        try {
            dataSet.set(57, null);
            DicomObject spsSeq = new DicomObject();
            dataSet.set(587, spsSeq);
            spsSeq.set(574, null);
            spsSeq.set(575, null);
            spsSeq.set(576, null);
            spsSeq.set(81, null);
            spsSeq.set(579, null);
            spsSeq.set(580, null);
            spsSeq.set(581, null);
            spsSeq.set(582, null);
            dataSet.set(547, null);
            dataSet.set(548, null);
            dataSet.set(589, null);
            dataSet.set(425, null);
            dataSet.set(107, null);
            dataSet.set(77, null);
            dataSet.set(88, null);
            dataSet.set(147, "*");
            dataSet.set(148, null);
            dataSet.set(150, null);
            dataSet.set(152, null);
            dataSet.set(571, null);
            dataSet.set(173, null);
            dataSet.set(174, null);
            dataSet.set(165, null);
            dataSet.set(166, null);
            dataSet.set(568, null);
            if (q != null) {
                DicomData dc = new DicomData(dataSet);
                q.writeDicom(dc);
            }
        }
        catch (Exception ex) {
            Tap.log.log(Level.WARNING, "Error converting TAP query to DICOM stream: ", ex);
            return null;
        }
        return dataSet;
    }

    public boolean pingRemote() {
        try {
            CEcho ce = new CEcho(this.calledAE, this.calledHost, this.calledPort, this.callingAE, this.props);
            return ce.doEcho() == 0;
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Exception caught in pingRemote: ", e);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            this.cf.releaseAssociation();
        }
        catch (Throwable ex) {
            Tap.log.log(Level.WARNING, "Exception caught in close: ", ex);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    static {
        for (int i = 0; i < TS_PARAMS.length; ++i) {
            TS_MAP.put(TS_PARAMS[i], new Integer(TS_VALUES[i]));
        }
        SUPPORTED_PARAMS.addAll(Arrays.asList(MWL_PARAMS));
    }
}

