/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.hyperpesi;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.hyperpesi.HpAuxTag;
import com.ge.med.terra.tap.dm.hyperpesi.HyperPesiObject;
import com.ge.med.terra.tap.dm.hyperpesi.HyperPesiObjectStore;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.pesi.PesiComposite;
import com.ge.med.terra.tap.dm.pesi.PesiObject;
import com.ge.med.terra.tap.dm.pesi.PesiSession;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

public class HyperPesiSession
extends PesiSession {
    public static String REP_CONFIG_FILE = "HPConfig.properties";
    public static String INTERNAL_CONFIG_FILE = "cacheLevel.properties";
    protected Properties imgProps = new Properties();
    private tagValue[][] tv = new tagValue[4][];
    static final String[] LEVELS = new String[]{"patient", "study", "series", "image"};
    Properties config = new Properties();
    private static DMTag sopTag = new DMTag(8, 24);
    ArrayList<String> auxKeys = new ArrayList();
    private File globalImgCacheFile;
    protected static ThreadGroup reconGroup = new ThreadGroup("allReconcile");
    private Hashtable<Object, DMiComposite> deleted = new Hashtable();
    HpAuxTag[][] auxtags = new HpAuxTag[4][];
    HashMap<String, WeakReference<HyperPesiObjectStore>> objCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String session, String[] args) {
        String sess = session;
        File hyper = new File(sess);
        File hp = new File(hyper, "pesi");
        if (hp.exists()) {
            sess = hp.getAbsolutePath();
        }
        super.init(sess, args);
        File pbase = new File(sess).getParentFile();
        if (!pbase.exists()) {
            return;
        }
        File pdb = new File(pbase, "pdb");
        if (!pdb.exists()) {
            return;
        }
        System.out.println("found pdb: ");
        OutputStreamWriter fw = null;
        InputStreamReader fr = null;
        InputStreamReader frPbase = null;
        try {
            File cfgFile = new File(pdb, REP_CONFIG_FILE);
            if (!cfgFile.exists()) {
                cfgFile.createNewFile();
                this.config.load(HyperPesiSession.class.getResourceAsStream(INTERNAL_CONFIG_FILE));
                fw = new FileWriter(cfgFile);
                this.config.store(fw, "From default internal template");
                fw.close();
            } else {
                fr = new FileReader(cfgFile);
                this.config.load(fr);
                fr.close();
            }
            pbase = new File(pdb, "GlobalImgCache");
            if (!pbase.exists()) {
                pbase.createNewFile();
            } else {
                frPbase = new FileReader(pbase);
                this.imgProps.load(frPbase);
            }
            this.globalImgCacheFile = pbase;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != fr) {
                try {
                    fr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (null != frPbase) {
                try {
                    frPbase.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.initTags();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected HyperPesiObject makeHPesiObject(String type, File path) {
        return new HyperPesiObject(type, path, this);
    }

    @Override
    protected PesiObject makePesiObject(String type, File path) {
        return new HyperPesiObject(type, path, this);
    }

    @Override
    public PesiComposite findAComposite(File root) {
        return super.findAComposite(root);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        super.getChildren(q, cb);
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.getRelated("patient", q);
    }

    @Override
    public DMiComposite getComposite(String id) {
        return super.getComposite(id);
    }

    @Override
    public DMiComposite[] getComposites() {
        return super.getComposites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fireEvent(DMEvent e) {
        FileWriter fw = null;
        for (tagValue t : this.imageTags) {
            if (t.group != 8 || t.element != 24) continue;
            this.imgProps.put(t.value.toString(), e.getSource());
            try {
                fw = new FileWriter(this.globalImgCacheFile, true);
                String toWrite = t.value.toString() + "=" + e.getSource();
                fw.write(toWrite + "\n");
                fw.close();
                break;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                break;
            }
            finally {
                if (null != fw) {
                    try {
                        fw.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        if (e.getID() == 1) {
            this.updateDeltaCacheOnInstall((String)e.getSource());
        }
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        return super.getDMiObject(type, id);
    }

    @Override
    public DMiJob[] getJobs() {
        return super.getJobs();
    }

    @Override
    public PesiObject getMatiching(PesiObject parent, String id) {
        return super.getMatiching(parent, id);
    }

    @Override
    public int getNumberOfComposites() {
        return super.getNumberOfComposites();
    }

    private void updateDeltaCacheOnInstall(String dir) {
        File f = new File(dir);
        for (int i = 3; i >= 0; --i) {
            tagValue[] tags = this.tv[i];
            HyperPesiObject hpo = (HyperPesiObject)this.makePesiObject(LEVELS[i], f);
            for (int j = 0; j < tags.length; ++j) {
                hpo.setCacheValue(this.tv[i][j]);
            }
            this.updateAuxTags(hpo, i);
            f = f.getParentFile();
        }
    }

    protected void setUPAuxTags() {
        ArrayList<HpAuxTag> l_p = new ArrayList<HpAuxTag>();
        ArrayList<HpAuxTag> l_e = new ArrayList<HpAuxTag>();
        ArrayList<HpAuxTag> l_s = new ArrayList<HpAuxTag>();
        ArrayList<HpAuxTag> l_i = new ArrayList<HpAuxTag>();
        for (String key : this.auxKeys) {
            String auxClass = this.config.getProperty(key);
            String[] arr = auxClass.split(",");
            String[] arr2 = key.split("\\.");
            arr2 = arr2[1].split("\\_");
            int grp = Integer.parseInt(arr2[0], 16);
            int elem = Integer.parseInt(arr2[1], 16);
            try {
                HpAuxTag atag = (HpAuxTag)Class.forName(arr[1]).newInstance();
                atag.setTag(grp, elem);
                if (arr[0].contains("p")) {
                    l_p.add(atag);
                }
                if (arr[0].contains("e")) {
                    l_e.add(atag);
                }
                if (arr[0].contains("s")) {
                    l_s.add(atag);
                }
                if (!arr[0].contains("i")) continue;
                l_i.add(atag);
            }
            catch (Exception ex) {}
        }
        this.auxtags[0] = l_p.toArray(new HpAuxTag[l_p.size()]);
        this.auxtags[1] = l_e.toArray(new HpAuxTag[l_e.size()]);
        this.auxtags[2] = l_s.toArray(new HpAuxTag[l_s.size()]);
        this.auxtags[3] = l_i.toArray(new HpAuxTag[l_i.size()]);
    }

    private void updateAuxTags(HyperPesiObject obj, int level) {
        for (int i = 0; i < this.auxtags[level].length; ++i) {
            this.auxtags[level][i].updateAuxTags(obj);
        }
    }

    protected String buildTag(int group, int element) {
        return "0x" + Integer.toHexString(group) + "_0x" + Integer.toHexString(element);
    }

    private void initTags() throws IOException {
        int j;
        int i;
        this.config.list(System.out);
        System.out.println("===================== ");
        Enumeration<Object> keys = this.config.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.indexOf("aux") <= -1) continue;
            this.auxKeys.add(key);
        }
        String[] tags = new String[]{this.config.getProperty("cache_patient"), this.config.getProperty("cache_study"), this.config.getProperty("cache_series"), this.config.getProperty("cache_image")};
        ArrayList<tagValue> toget = new ArrayList<tagValue>(10);
        for (i = 0; i < tags.length; ++i) {
            StringTokenizer toks = new StringTokenizer(tags[i], "+");
            this.tv[i] = new tagValue[toks.countTokens()];
            for (int j2 = 0; j2 < this.tv[i].length; ++j2) {
                String str = toks.nextToken();
                String[] ge = str.split(",");
                this.tv[i][j2] = new tagValue(Integer.parseInt(ge[0].substring(2), 16), Integer.parseInt(ge[1].substring(2), 16));
                toget.add(this.tv[i][j2]);
            }
        }
        for (i = 0; i < this.otherTags.length; ++i) {
            toget.add(this.otherTags[i]);
        }
        for (j = 0; j < this.tv[0].length; ++j) {
            if (this.tv[0][j].group != 16 || this.tv[0][j].element != 32) continue;
            this.patientTags = new tagValue[]{this.tv[0][j]};
        }
        for (j = 0; j < this.tv[1].length; ++j) {
            if (this.tv[1][j].group != 32 || this.tv[1][j].element != 13) continue;
            this.examTags = new tagValue[]{this.tv[1][j]};
        }
        for (j = 0; j < this.tv[2].length; ++j) {
            if (this.tv[2][j].group != 32 || this.tv[2][j].element != 14) continue;
            this.seriesTags = new tagValue[]{this.tv[2][j]};
        }
        for (j = 0; j < this.tv[3].length; ++j) {
            if (this.tv[3][j].group != 8 || this.tv[3][j].element != 24) continue;
            this.imageTags = new tagValue[]{this.tv[3][j]};
        }
        this.tagsToGet = toget.toArray(new tagValue[toget.size()]);
        Arrays.sort(this.tagsToGet);
        this.setUPAuxTags();
    }

    public HyperPesiObjectStore makeObjectStore(String path) {
        HyperPesiObjectStore ret;
        WeakReference<HyperPesiObjectStore> w = this.objCache.get(path);
        HyperPesiObjectStore hyperPesiObjectStore = ret = w == null ? null : (HyperPesiObjectStore)w.get();
        if (ret == null) {
            ret = new HyperPesiObjectStore(path);
            this.objCache.put(path, new WeakReference<HyperPesiObjectStore>(ret));
        }
        return ret;
    }

    @Override
    public void getRelated(String type, DMQuery q, final DMiObjectReceiver cb) {
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                if (!HyperPesiSession.this.isDeleted(ob)) {
                    return cb.gotOne(ob);
                }
                return true;
            }
        };
        super.getRelated(type, q, rcvr);
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        return super.getRelated(ieType, q);
    }

    @Override
    public void install(InputStream is) throws IOException {
        super.install(is);
    }

    @Override
    public void installFiles(File[] files, boolean destroy) throws FileNotFoundException, IOException {
        super.installFiles(files, destroy);
    }

    @Override
    protected PesiComposite makeNewPesiComposite(File path) {
        return super.makeNewPesiComposite(path);
    }

    @Override
    protected void recursivelyFindComposites(File root, ArrayList comps) {
        super.recursivelyFindComposites(root, comps);
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        super.removeDMEventListener(listener);
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        super.save(o, prop);
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        super.save(o, prop);
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        super.save(o, prop);
    }

    @Override
    public String[] send(String str) {
        return super.send(str);
    }

    @Override
    protected void setupEvents() {
        super.setupEvents();
    }

    private boolean isDeleted(DMiObject dmo) {
        return this.deleted.containsKey(dmo.getValue(sopTag));
    }

    public void delete(DMiObject dmo) {
        DMiComposite[] comps = dmo.getComposites(null);
        for (int i = 0; i < comps.length; ++i) {
            DMiComposite comp = comps[i];
            this.deleted.put(comp.getValue(sopTag), comp);
            this.fireEvent(new DMEvent(2, "delete: " + comp.getFilePath(), comp.getFilePath()));
        }
    }

    private void cleanUp(File parent) {
        File parentDir = parent;
        if (parentDir.isDirectory()) {
            File[] files = parentDir.listFiles();
            boolean containsFiles = false;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (f.isDirectory()) continue;
                containsFiles = true;
            }
            if (!containsFiles) {
                SimpleUtilities.deleteFilesRecursively(parentDir);
            }
        }
        if ((parentDir = parentDir.getParentFile()).listFiles().length == 0) {
            parentDir.delete();
            parentDir = parentDir.getParentFile();
            if (parentDir.listFiles().length == 0) {
                parentDir.delete();
            }
        }
    }

    public static void recursiveDirTraversal(File root, FileFilter f) {
        for (File file : root.listFiles()) {
            if (!file.isDirectory()) continue;
            HyperPesiSession.recursiveDirTraversal(file, f);
            f.accept(file);
        }
    }

    @Override
    public void close() {
        HyperPesiSession.recursiveDirTraversal(this.rootDir, new FileFilter(){

            @Override
            public boolean accept(File f) {
                HyperPesiSession.this.makeObjectStore(f.getAbsolutePath());
                return false;
            }
        });
        Enumeration<Object> keys = this.deleted.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            DMiComposite comp = this.deleted.get(key);
            String filePath = comp.getFilePath();
            File f = new File(filePath);
            File parent = f.getParentFile();
            for (int numRetries = 0; !f.delete() || numRetries > 5; ++numRetries) {
                String message = "Calling GC to help clear weak references in fileImageManager";
                System.err.println(message);
                System.gc();
                SimpleUtilities.sleep(500L);
            }
            if (!f.exists()) {
                this.deleted.remove(key);
                this.cleanUp(parent);
                continue;
            }
            System.err.println("Could not delete file: " + f.getAbsolutePath());
        }
    }
}

