/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dmtest;

import com.ge.med.terra.tap.dm.DMEvent;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMObject;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.util.SimpleUtilities;
import com.ge.med.terra.tap.util.dicom.ImageCreator;

public class NMPerfCheck {
    long start = 0L;
    long end;
    int[] pttags = new int[]{16, 32, 8, 32, 16, 16, 9, 4123, 9, 4115, 9, 4116};
    int[] imtags = new int[]{16, 16, 16, 32, 9, 4116, 8, 32, 8, 4144, 1, 1};
    DMTag[] ptTags = new DMTag[this.pttags.length / 2];
    DMTag[] imTags = new DMTag[this.imtags.length / 2];
    DMSession ses = new DMSession(new String[]{"terra", "terradb", "localhost"});
    ImageCreator ic;

    public NMPerfCheck() {
        int i;
        for (i = 0; i < this.ptTags.length; ++i) {
            this.ptTags[i] = new DMTag(this.pttags[2 * i], this.pttags[2 * i + 1]);
        }
        for (i = 0; i < this.imTags.length; ++i) {
            this.imTags[i] = new DMTag(this.imtags[2 * i], this.imtags[2 * i + 1]);
        }
        this.ses.addDMEventListener(1, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e) {
                System.out.println(">>>>start= " + NMPerfCheck.this.start);
                if (NMPerfCheck.this.start > 0L) {
                    NMPerfCheck.this.doPatientTableQuery();
                    System.out.println("elapsed time= " + (NMPerfCheck.this.end - NMPerfCheck.this.start) + " ms");
                }
            }
        });
        this.ses.addDMEventListener(2, new DMEventListener(){

            @Override
            public void actionPerformed(DMEvent e) {
                System.out.println("General Event: " + e.getSource());
            }
        });
    }

    public void doPatientTableQuery() {
        DMObject[] studies = this.ses.getRelated("study");
        int i = 0;
        for (i = 0; i < studies.length && i < 20; ++i) {
            for (int j = 0; j < this.ptTags.length; ++j) {
                Object value = studies[i].getValue(this.ptTags[j]);
            }
        }
        System.out.println("read " + this.ptTags.length + " tags from " + i + " studies");
        this.end = System.currentTimeMillis();
    }

    public void doImageManagementQuery() {
        DMObject[] patients = this.ses.getRelated("patient");
        for (int i = 0; i < patients.length && i < 20; ++i) {
            for (int j = 0; j < this.imTags.length; ++j) {
                Object value = patients[i].getValue(this.imTags[j]);
            }
        }
        this.end = System.currentTimeMillis();
    }

    public void cleanDB() {
        DMObject[] pats = this.ses.getChildren();
        for (int i = 0; i < pats.length; ++i) {
            pats[i].delete();
        }
    }

    public void setupDB(int patientCnt, int studyCnt, int seriesCnt, int imageCnt) throws Exception {
        if (this.ic == null) {
            this.ic = new ImageCreator();
        }
        this.ic.install(patientCnt, studyCnt, seriesCnt, imageCnt, this.ses);
    }

    public static void main(String[] args) {
        NMPerfCheck nmpt = new NMPerfCheck();
        try {
            nmpt.cleanDB();
            nmpt.setupDB(1, 499, 1, 2);
            SimpleUtilities.sleep(30000L);
            nmpt.start = System.currentTimeMillis();
            nmpt.setupDB(1, 1, 1, 1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

