/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomnetwork;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMEventListener;
import com.ge.med.terra.tap.dm.DMException;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMSession;
import com.ge.med.terra.tap.dm.dicomnetwork.JobManagement.NetworkCommand;
import com.ge.med.terra.tap.dm.dicomnetwork.JobManagement.NetworkJob;
import com.ge.med.terra.tap.dm.dicomnetwork.JobManagement.NetworkJobManager;
import com.ge.med.terra.tap.dm.dicomnetwork.NetworkObject;
import com.ge.med.terra.tap.dm.dicomnetwork.scu.EchoSCU;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiJob;
import com.ge.med.terra.tap.dm.peer.DMiJob2;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.dm.peer.DMiSession;
import com.ge.med.terra.tap.dmui.DmuBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NetworkSession
implements DMiSession {
    public final int REQ_TIME_OUT = Integer.parseInt(Tap.getProperty("tap.dm.nw.scu.reqtimeout", "50000").trim());
    private String calledAE = null;
    private String calledHost = null;
    private int calledPort = 0;
    private NetworkJobManager jobMgr = null;
    private List<DMEventListener> listenerList = new ArrayList<DMEventListener>();
    private boolean isSessionTypeMwl = false;
    private boolean useSSL = false;

    @Override
    public void init(String sessType, String[] args) {
        StringBuffer str = new StringBuffer();
        str.append("Initializing the Network Session: ");
        str.append("Parameters(");
        str.append(sessType);
        for (int i = 0; i < args.length; ++i) {
            str.append(",");
            str.append(args[i]);
        }
        str.append(")");
        Tap.log.log(Level.INFO, str.toString());
        if (null != sessType && sessType.equalsIgnoreCase("mwl")) {
            this.isSessionTypeMwl = true;
        }
        this.calledAE = args[0];
        this.calledHost = args[1];
        this.calledPort = Integer.parseInt(args[2].trim());
        if (args.length >= 4) {
            this.useSSL = Boolean.parseBoolean(args[3]);
            if (this.useSSL) {
                NetworkSession.setTLSConfigurations();
            }
        }
        Tap.log.log(Level.INFO, "Initializing the Network Job Manager.");
        this.jobMgr = new NetworkJobManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTLSConfigurations() {
        String tlsFilePath = System.getProperty("TLS_CONFIG_FILE_PATH", null);
        Properties tlsProps = new Properties();
        if (tlsFilePath != null && new File(tlsFilePath).isFile()) {
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(tlsFilePath);
                tlsProps.load(fin);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                Tap.log.warning("file " + tlsFilePath + " not found. No TLS properties set, using default values in VM");
            }
            catch (IOException e) {
                e.printStackTrace();
                Tap.log.warning("properties loading failure while accessing " + tlsFilePath + ". No TLS properties set, using default values in VM");
            }
            finally {
                try {
                    if (fin != null) {
                        ((InputStream)fin).close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (tlsFilePath == null) {
            Tap.log.warning("no TLS properties set, using default values in VM");
        } else {
            Tap.log.warning("invalid TLS properties file \"" + tlsFilePath + "\", default values in VM used");
        }
        for (Map.Entry<Object, Object> entry : tlsProps.entrySet()) {
            String tlsPropKey = (String)entry.getKey();
            String tlsPropValue = (String)entry.getValue();
            System.setProperty(tlsPropKey, tlsPropValue);
        }
    }

    @Override
    public DMiJob asynSend(String inputStr) {
        Tap.log.log(Level.FINE, "The input command string to be executed: " + inputStr);
        NetworkJob nwJob = null;
        if (inputStr.startsWith("echo")) {
            nwJob = this.jobMgr.createECHOJob(inputStr);
        } else if (inputStr.startsWith("find")) {
            nwJob = this.jobMgr.createFINDJob(inputStr);
        } else if (inputStr.startsWith("retrieve")) {
            nwJob = this.jobMgr.createMOVEJob(inputStr);
        } else if (inputStr.startsWith("store")) {
            nwJob = this.jobMgr.createSTOREJob(inputStr);
        }
        return nwJob;
    }

    @Override
    public DMiJob[] getJobs() {
        Set jobList = this.jobMgr.getJobs();
        return jobList.toArray(new DMiJob[jobList.size()]);
    }

    @Override
    public void addDMEventListener(int eventType, int freq, DMEventListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeDMEventListener(DMEventListener listener) {
        this.listenerList.remove(listener);
    }

    public List<DMEventListener> getListenerList() {
        return this.listenerList;
    }

    public String getCalledAE() {
        return this.calledAE;
    }

    public String getCalledHost() {
        return this.calledHost;
    }

    public int getCalledPort() {
        return this.calledPort;
    }

    public boolean isSessionTypeMwl() {
        return this.isSessionTypeMwl;
    }

    public void executeJob(NetworkJob job) {
        this.jobMgr.executeJob(job);
    }

    @Override
    public void close() {
        this.jobMgr.close();
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        return this.sendFindRequest(ieType, q, null);
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver cb) {
        this.sendFindRequest(ieType, q, cb);
    }

    @Override
    public DMiObject[] getChildren(DMQuery q) {
        return this.sendFindRequest("PATIENT", q, null);
    }

    @Override
    public void getChildren(DMQuery q, DMiObjectReceiver cb) {
        this.sendFindRequest("PATIENT", q, cb);
    }

    @Override
    public void save(DMiObject[] o, Hashtable prop) {
        DMiComposite[] allComps = this.getAllComposites(o);
        File[] filesToSave = new File[allComps.length];
        for (int i = 0; i < allComps.length; ++i) {
            filesToSave[i] = new File(allComps[i].getFilePath());
        }
        this.installFiles(filesToSave, false);
    }

    @Override
    public void save(DMiObject o, Hashtable prop) {
        DMiObject[] dmoList = new DMiObject[]{o};
        this.save(dmoList, prop);
    }

    @Override
    public void save(DMiComposite o, Hashtable prop) {
        File[] filesToSave = new File[]{new File(o.getFilePath())};
        this.installFiles(filesToSave, false);
    }

    @Override
    public void installFiles(File[] files, boolean destroy) {
        NetworkCommand storeCmd = NetworkCommand.createNetworkCommandForSTORE((File[])files, (boolean)true);
        DMiJob storeJob = this.asynSend(storeCmd.getCommandArgString());
        while (!((Boolean)storeJob.getProperty("JOB_COMPLETE")).booleanValue()) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception ex) {
                System.out.println("Exception occured while putting the thread to sleep");
            }
        }
        Tap.log.log(Level.INFO, "C-STORE Job ID: " + storeJob.getJobHandle() + " completed with status = " + storeJob.getStatusString());
        Object val = storeJob.getProperty("RESULT");
        if (val != null) {
            Map resMap = (Map)val;
            Tap.log.log(Level.FINE, "Map of Stored StudyUID, Series UID and SopUID: " + resMap);
        }
        if (destroy) {
            for (int i = 0; i < files.length; ++i) {
                boolean del = files[i].delete();
                if (del) continue;
                System.err.println("Unable to delete the file: " + files[i].getAbsolutePath());
            }
        }
    }

    public boolean isLocalServerAlive() {
        try {
            NetworkCommand echoCmd = NetworkCommand.createNetworkCommandForECHO((boolean)false);
            EchoSCU ce = new EchoSCU(this.jobMgr.SCP_TITLE, "127.0.0.1", this.jobMgr.SCP_PORT);
            ce.setSocketFactory(this.isSSLused() ? SSLSocketFactory.getDefault() : SocketFactory.getDefault());
            int result = (Integer)ce.executeCmd(echoCmd, null);
            return result == 0;
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Exception caught in isServerAlive: ", e);
            return false;
        }
    }

    public boolean pingRemote() {
        try {
            NetworkCommand echoCmd = NetworkCommand.createNetworkCommandForECHO((boolean)false);
            EchoSCU ce = new EchoSCU(this.calledAE, this.calledHost, this.calledPort);
            int result = (Integer)ce.executeCmd(echoCmd, null);
            return result == 0;
        }
        catch (Exception e) {
            Tap.log.log(Level.WARNING, "Exception caught in pingRemote: ", e);
            return false;
        }
    }

    @Override
    public DMiObject getDMiObject(String type, String id) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public DMiComposite getComposite(String id) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public DMiComposite[] getComposites() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getNumberOfComposites() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void install(InputStream is) throws IOException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String[] send(String str) {
        System.err.println("Please use asyncSend() method instead..");
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void ClearCache() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private DMiObject[] sendFindRequest(String ieType, DMQuery q, DMiObjectReceiver cb) {
        NetworkCommand findCmd;
        DMiObject[] nwDMOs = new DMiObject[]{};
        if (!(ieType.equalsIgnoreCase("PATIENT") || ieType.equalsIgnoreCase("STUDY") || ieType.equalsIgnoreCase("EXAM") || ieType.equalsIgnoreCase("SERIES") || ieType.equalsIgnoreCase("IMAGE"))) {
            Tap.log.log(Level.WARNING, "The ieType of \"" + ieType + "\" is not supported; defaulting to \"patient\"");
            ieType = "PATIENT".toLowerCase();
        }
        NetworkSession mySession = this;
        try {
            findCmd = NetworkCommand.createNetworkCommandForFIND((String)ieType, (DMQuery)q, (boolean)this.isSessionTypeMwl, (boolean)false);
        }
        catch (Exception ex) {
            throw new DMException("could not create C-FIND job", ex);
        }
        DMiJob findJob = this.asynSend(findCmd.getCommandArgString());
        findJob.executeImmediately();
        int servicedTime = 0;
        int sleepTime = 50;
        long oldProgress = 0L;
        while (!((Boolean)findJob.getProperty("JOB_COMPLETE")).booleanValue()) {
            try {
                Thread.sleep(sleepTime);
                if (findJob instanceof DMiJob2) {
                    long newProgress = ((DMiJob2)findJob).getJobProgress();
                    if (newProgress > oldProgress) {
                        servicedTime = 0;
                        oldProgress = newProgress;
                    } else {
                        servicedTime += sleepTime;
                        oldProgress = newProgress;
                    }
                }
                if (servicedTime <= this.REQ_TIME_OUT) continue;
                throw new DMException("Request Timed out for Job ID: " + findJob.getJobHandle());
            }
            catch (Exception ex) {
                throw new DMException(ex);
            }
        }
        Object val = findJob.getProperty("RESULT");
        if (null != val) {
            nwDMOs = (DMiObject[])val;
        }
        if (cb != null) {
            for (int i = 0; i < nwDMOs.length; ++i) {
                cb.gotOne(nwDMOs[i]);
            }
        } else {
            return nwDMOs;
        }
        cb.gotOne(new NetworkObject(null, mySession, null));
        return new DMiObject[0];
    }

    private DMiComposite[] getAllComposites(DMiObject[] dmiObjects) {
        ArrayList<DMiComposite> list = new ArrayList<DMiComposite>(dmiObjects.length);
        for (int i = 0; i < dmiObjects.length; ++i) {
            DMiObject object = dmiObjects[i];
            DMiComposite[] composites = object.getComposites(null);
            for (int compositesIndex = 0; compositesIndex < composites.length; ++compositesIndex) {
                list.add(composites[compositesIndex]);
            }
        }
        return list.toArray(new DMiComposite[0]);
    }

    public static void main(String[] args) {
        String remoteAE = "crashman";
        String remoteHost = "3.70.204.104";
        String remotePort = "4006";
        String[] nwArgs = new String[]{remoteAE, remoteHost, remotePort};
        System.err.println("Creating New Network Session..");
        DMSession.insertSession("NewTapNetwork", "com.ge.med.terra.tap.dm.dicomnetwork.NetworkSession");
        DMSession tapNWS = new DMSession("NewTapNetwork", null, nwArgs);
        JFrame jf = new JFrame("Test Frame");
        JPanel jp = new JPanel(new BorderLayout());
        DmuBrowser dmu = new DmuBrowser();
        dmu.setDB(tapNWS);
        jp.add((Component)dmu, "Center");
        jf.add(jp);
        jf.setPreferredSize(new Dimension(700, 700));
        jf.pack();
        jf.setVisible(true);
        jf.setLocationRelativeTo(null);
    }

    public boolean isSSLused() {
        return this.useSSL;
    }
}

