/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomnetwork;

import com.archimed.dicom.DDate;
import com.archimed.dicom.DDateRange;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.DicomReader;
import com.archimed.dicom.Person;
import com.archimed.dicom.TagValue;
import com.archimed.dicom.charset.DicomCharset;
import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.DMElement;
import com.ge.med.terra.tap.dm.DMQuery;
import com.ge.med.terra.tap.dm.DMTag;
import com.ge.med.terra.tap.dm.DMTagValueInterface;
import com.ge.med.terra.tap.dm.dicomnetwork.NetworkComposite;
import com.ge.med.terra.tap.dm.dicomnetwork.NetworkSequence;
import com.ge.med.terra.tap.dm.dicomnetwork.NetworkSession;
import com.ge.med.terra.tap.dm.dicomnetwork.scu.DicomQueryObject;
import com.ge.med.terra.tap.dm.peer.DMiComposite;
import com.ge.med.terra.tap.dm.peer.DMiImage;
import com.ge.med.terra.tap.dm.peer.DMiObject;
import com.ge.med.terra.tap.dm.peer.DMiObjectReceiver;
import com.ge.med.terra.tap.util.dicom.DicomData;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;

public class NetworkObject
implements DMiObject,
DMTagValueInterface {
    private final String type;
    private final NetworkSession session;
    private final DicomObject dicomObject;
    private int numberOfImages = -1;
    private int refCount = 0;

    public NetworkObject(String type, NetworkSession session, DicomObject dicomObject) {
        this.type = type;
        this.session = session;
        this.dicomObject = dicomObject;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public NetworkSession getSession() {
        return this.session;
    }

    @Override
    public String getID() {
        if (this.type.equalsIgnoreCase("Patient")) {
            return "P|" + this.dicomObject.get(147) + "|" + this.dicomObject.get(148) + "|" + this.dicomObject.get(150);
        }
        if (this.type.equalsIgnoreCase("Study") || this.type.equalsIgnoreCase("Exam")) {
            return "E|" + this.dicomObject.get(425) + "|" + this.dicomObject.get(427);
        }
        if (this.type.equalsIgnoreCase("Series")) {
            return "S|" + this.dicomObject.get(426) + "|" + this.dicomObject.get(428);
        }
        if (this.type.equalsIgnoreCase("Image")) {
            return "I|" + this.dicomObject.get(63) + "|" + this.dicomObject.get(665);
        }
        return "UNKNOWN";
    }

    @Override
    public DMTag[] getTags() {
        ArrayList<DMTag> al = new ArrayList<DMTag>();
        Enumeration vrs = this.dicomObject.enumerateVRs(false);
        while (vrs.hasMoreElements()) {
            TagValue tv = (TagValue)vrs.nextElement();
            al.add(new DMTag(tv.getGroup(), tv.getElement()));
        }
        return al.toArray(new DMTag[al.size()]);
    }

    @Override
    public Object getValue(DMTag t) {
        return NetworkObject.getValueFromDicomObject(this.dicomObject, t);
    }

    @Override
    public void getValues(DMElement[] elements) {
        if (this.dicomObject != null) {
            DicomCharset[] charSets = this.dicomObject.dicomCharsets();
            if (charSets.length > 0 && charSets[0] == null) {
                charSets[0] = DicomCharset.DEFAULT;
                try {
                    String o = this.dicomObject.getString(57, 0, true);
                    if ("ISO_IR100".equals(o)) {
                        Tap.log.warning("Fixing invalid ISO_IR100 character set to use ISO_IR 100");
                        this.dicomObject.setString(57, "ISO_IR 100", 0);
                    } else {
                        Tap.log.warning("Unsupported CharacterSet = " + o + ". Using US-ASCII.");
                        this.dicomObject.setString(57, "US-ASCII", 0);
                    }
                }
                catch (DicomException e) {
                    e.printStackTrace();
                }
            }
            for (int i = 0; i < elements.length; ++i) {
                Object obj = this.dicomObject.get_ge(elements[i].group, elements[i].element);
                if (obj == null) {
                    elements[i].value = null;
                    continue;
                }
                try {
                    byte[] nativeBytes = this.dicomObject.getBytes_ge(elements[i].group, elements[i].element, 0);
                    elements[i].valueAsBytes = nativeBytes;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (obj instanceof DicomObject) {
                    elements[i].value = new NetworkSequence(this.dicomObject, elements[i].group, elements[i].element);
                    continue;
                }
                if (obj instanceof Person) {
                    elements[i].value = ((Person)obj).toDICOMString();
                    continue;
                }
                if (obj instanceof DDate) {
                    elements[i].value = ((DDate)obj).toDICOMString();
                    continue;
                }
                if (obj instanceof DDateRange) {
                    elements[i].value = ((DDateRange)obj).toDICOMString();
                    continue;
                }
                int multiplicity = this.dicomObject.getSize_ge(elements[i].group, elements[i].element);
                try {
                    if (multiplicity > 1) {
                        elements[i].value = NetworkObject.constructMultiValuedString(this.dicomObject, multiplicity, elements[i].group, elements[i].element);
                        continue;
                    }
                    int vr2 = this.dicomObject.getType_ge(elements[i].group, elements[i].element);
                    if (vr2 == 15) {
                        elements[i].value = ((Integer)obj).toString().trim();
                        continue;
                    }
                    elements[i].value = obj;
                    continue;
                }
                catch (DicomException e) {
                    Tap.log.log(Level.SEVERE, "Failed to get the tag value for: " + tagValue.atToString(elements[i].group, elements[i].element));
                }
            }
        }
    }

    public static Object getValueFromDicomObject(DicomObject dcmObj, DMTag t) {
        if (dcmObj != null) {
            Object obj = dcmObj.get_ge(t.getGroup(), t.getElement());
            if (obj == null) {
                return obj;
            }
            if (obj instanceof DicomObject) {
                return new NetworkSequence(dcmObj, t.getGroup(), t.getElement());
            }
            if (obj instanceof Person) {
                return ((Person)obj).toDICOMString();
            }
            if (obj instanceof DDate) {
                return ((DDate)obj).toDICOMString();
            }
            if (obj instanceof DDateRange) {
                return ((DDateRange)obj).toDICOMString();
            }
            int multiplicity = dcmObj.getSize_ge(t.getGroup(), t.getElement());
            try {
                if (multiplicity > 1) {
                    return NetworkObject.constructMultiValuedString(dcmObj, multiplicity, t.getGroup(), t.getElement());
                }
                int vr2 = dcmObj.getType_ge(t.getGroup(), t.getElement());
                if (vr2 == 15) {
                    return ((Integer)obj).toString().trim();
                }
                return obj;
            }
            catch (DicomException e) {
                Tap.log.log(Level.SEVERE, "Failed to get the tag value for: " + tagValue.atToString(t.getGroup(), t.getElement()));
                return null;
            }
        }
        return null;
    }

    @Override
    public void setValues(DMElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            try {
                this.dicomObject.set_ge(elements[i].group, elements[i].element, elements[i].value);
                continue;
            }
            catch (DicomException e) {
                Tap.log.log(Level.SEVERE, "Failed to set value for the Tag: " + tagValue.atToString(elements[i].group, elements[i].element));
            }
        }
    }

    @Override
    public int getNumberOfComposites(DMQuery q) {
        Tap.log.log(Level.INFO, "Query will be ignored. Total number of composites under this level will be returned");
        int imageCount = Integer.MAX_VALUE;
        try {
            if (this.type.equalsIgnoreCase("STUDY")) {
                imageCount = this.dicomObject.getI(457);
            } else if (this.type.equalsIgnoreCase("SERIES")) {
                imageCount = this.dicomObject.getI(458);
            } else if (this.type.equalsIgnoreCase("IMAGE")) {
                return 1;
            }
        }
        catch (Exception e) {
            imageCount = Integer.MAX_VALUE;
        }
        if (imageCount != Integer.MAX_VALUE) {
            return imageCount;
        }
        return this.numberOfImages;
    }

    @Override
    public DMiObject[] getRelated(String ieType, DMQuery q) {
        final ArrayList list = new ArrayList();
        DMiObjectReceiver rcvr = new DMiObjectReceiver(){

            @Override
            public boolean gotOne(DMiObject ob) {
                if (ob.getType() != null) {
                    list.add(ob);
                }
                return true;
            }
        };
        this.getRelated(ieType, q, rcvr);
        DMiObject[] obj = list.toArray(new DMiObject[0]);
        return list.toArray(new DMiObject[0]);
    }

    @Override
    public void getRelated(String ieType, DMQuery q, DMiObjectReceiver cb) {
        try {
            DicomObject dataSet = this.session.isSessionTypeMwl() ? DicomQueryObject.formMWLQuery() : DicomQueryObject.formNetworkQuery((String)ieType);
            this.setQueryFields(dataSet);
            DicomData dataSetToMatch = new DicomData(dataSet);
            if (q != null) {
                q.writeDicom(dataSetToMatch);
            }
            DMQuery dmq = new DMQuery(dataSetToMatch);
            this.session.getRelated(ieType, dmq, new NetworkObjectReceiverWrapper(cb));
        }
        catch (DicomException ex) {
            // empty catch block
        }
    }

    public void dump() {
        try {
            this.dicomObject.dumpVRs(System.out);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public DMiComposite[] getComposites(DMQuery q) {
        DMiComposite[] results = new DMiComposite[]{};
        if (!this.session.isSessionTypeMwl()) {
            DMiObject[] objects = this.getRelated("IMAGE", q);
            results = new DMiComposite[objects.length];
            for (int i = 0; i < results.length; ++i) {
                results[i] = new NetworkComposite((NetworkObject)objects[i], this.session);
            }
        }
        return results;
    }

    @Override
    public int getNumberOfRelated(String ieType, DMQuery q) {
        return this.getRelated(ieType, q).length;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public BufferedImage[] getPixelData(DMTag[] tags) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public DMiImage[] getImages(DMTag[] tags) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void setLock(int lockType) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getLock() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void attach() {
        ++this.refCount;
    }

    @Override
    public void detach() {
        --this.refCount;
    }

    private static String constructMultiValuedString(DicomObject dcmObject, int multiplicity, int group, int element) throws DicomException {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < multiplicity; ++i) {
            sb.append(dcmObject.getS_ge(group, element, i));
            if (i + 1 >= multiplicity) continue;
            sb.append("\\");
        }
        return sb.toString();
    }

    private void setQueryFields(DicomObject dataSet) throws DicomException {
        if (this.type.equalsIgnoreCase("Patient")) {
            dataSet.set(57, this.dicomObject.get(57));
            dataSet.set(147, this.dicomObject.getS(147));
            dataSet.set(148, this.dicomObject.getS(148));
            dataSet.set(150, this.dicomObject.getS(150));
        } else if (this.type.equalsIgnoreCase("Study") || this.type.equalsIgnoreCase("Exam")) {
            dataSet.set(425, this.dicomObject.getS(425));
            dataSet.set(147, this.dicomObject.getS(147));
            dataSet.set(148, this.dicomObject.getS(148));
            dataSet.set(150, this.dicomObject.getS(150));
        } else if (this.type.equalsIgnoreCase("Series")) {
            dataSet.set(426, this.dicomObject.getS(426));
            dataSet.set(425, this.dicomObject.getS(425));
            dataSet.set(147, this.dicomObject.getS(147));
            dataSet.set(148, this.dicomObject.getS(148));
            dataSet.set(150, this.dicomObject.getS(150));
        } else if (this.type.equalsIgnoreCase("Image")) {
            dataSet.set(426, this.dicomObject.getS(426));
            dataSet.set(425, this.dicomObject.getS(425));
            dataSet.set(63, this.dicomObject.getS(63));
            dataSet.set(147, this.dicomObject.getS(147));
            dataSet.set(148, this.dicomObject.getS(148));
            dataSet.set(150, this.dicomObject.getS(150));
        }
    }

    public static void main(String[] args) {
        System.out.println("NetworkObject.main");
        try {
            DicomCharset[] charSets;
            FileInputStream fin = new FileInputStream("/Users/davidpolyak/tmp/CJK-PATIENT-4.dcm");
            DicomReader dcmReader = new DicomReader();
            DicomObject dcm = dcmReader.read(fin);
            for (DicomCharset charSet : charSets = dcm.dicomCharsets()) {
                System.out.println("NetworkObject.main char set: " + charSet.getDefinedTerm());
            }
            dcm.dumpVRs(System.out, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class NetworkObjectReceiverWrapper
    implements DMiObjectReceiver {
        private DMiObjectReceiver callback = null;

        NetworkObjectReceiverWrapper(DMiObjectReceiver callback) {
            NetworkObject.this.numberOfImages = 0;
            this.callback = callback;
        }

        @Override
        public boolean gotOne(DMiObject o) {
            boolean status = this.callback.gotOne(o);
            if (NetworkObject.this.getType().equalsIgnoreCase("SERIES")) {
                NetworkObject.this.numberOfImages++;
                if (!status) {
                    NetworkObject.this.numberOfImages = -1;
                }
            }
            return status;
        }
    }
}

