/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.util.Set;
import java.util.TreeSet;

public class SeriesDirectoryRecordType
extends DirectoryRecordType {
    private static final DicomdirTagValue charSetTag = new DicomdirTagValue(8, 5, 1, true);
    private static final DicomdirTagValue modalityTag = new DicomdirTagValue(8, 96, 1, false);
    private static final DicomdirTagValue seriesInstUIDTag = new DicomdirTagValue(32, 14, 1, false);
    private static final DicomdirTagValue seriesNumberTag = new DicomdirTagValue(32, 17, 1, false);
    private static int dummySerNumber = 9998;

    public SeriesDirectoryRecordType() {
        super("SERIES");
    }

    @Override
    protected Set<tagValue> createDefaultTagList() {
        TreeSet<tagValue> tagSet = new TreeSet<tagValue>();
        tagSet.add(charSetTag);
        tagSet.add(modalityTag);
        tagSet.add(seriesInstUIDTag);
        tagSet.add(seriesNumberTag);
        return tagSet;
    }

    @Override
    protected Object getDefaultValue(DicomdirTagValue atv) {
        if (atv.getType() == 2) {
            return null;
        }
        if (atv.compareTo(seriesNumberTag) == 0) {
            return Integer.toString(++dummySerNumber);
        }
        if (atv.compareTo(seriesInstUIDTag) == 0) {
            return "9.9.9.9.9.9";
        }
        if (atv.compareTo(modalityTag) == 0) {
            throw new IllegalArgumentException("Value cannot be null for: " + tagValue.atToString(atv.group, atv.element));
        }
        throw new IllegalArgumentException("Unable to provide default value for " + atv);
    }
}

