/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.dm.dicomdir.DicomdirTagValue;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryEntityLevel;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.util.dicom.tagValue;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.TreeSet;

public class DirectoryRecord {
    private long myOffset = -1L;
    private ByteBuffer mb;
    private String dirMountPath;
    private DirectoryRecord parentDR = null;
    public Set<tagValue> tvs;
    private String id;
    private String level;
    private String type;
    private long nextSibling = -1L;
    private long firstChild = -1L;
    private int index = 0;
    private boolean hasComposite = false;
    private String repCompPath = null;

    DirectoryRecord(long offset, ByteBuffer buffer, String mountPath) {
        this.myOffset = offset;
        this.mb = buffer;
        this.dirMountPath = mountPath;
    }

    DirectoryRecord(long offset, ByteBuffer buffer, String mountPath, Set<DicomdirTagValue> tags, DirectoryRecord parent) {
        this(offset, buffer, mountPath);
        this.parentDR = parent;
        this.tvs = new TreeSet<tagValue>();
        for (DicomdirTagValue tv : tags) {
            int grp = tv.group;
            int elm = tv.element;
            if (grp == 4 && elm == 5168) {
                this.type = (String)tv.value;
                this.level = DirectoryRecordType.getLevel(this.type);
                if (null == this.level) {
                    this.level = DirectoryEntityLevel.getChildLevels(parent.level).get(0);
                }
            } else if (grp == 4 && elm == 5120) {
                this.nextSibling = (Long)tv.value;
            } else if (grp == 4 && elm == 5152) {
                this.firstChild = (Long)tv.value;
            }
            this.tvs.add(tv);
        }
        this.id = DirectoryRecord.makeDirectoryRecordID(this.type, this.tvs);
    }

    public String getId() {
        return this.id;
    }

    public long getOffset() {
        return this.myOffset;
    }

    public Set<tagValue> getTags() {
        return this.tvs;
    }

    public String getLevel() {
        return this.level;
    }

    public String getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public long getParentOffset() {
        return this.parentDR.myOffset;
    }

    public long getFirstChildOffset() {
        return this.firstChild;
    }

    public long getNextSiblingOffset() {
        return this.nextSibling;
    }

    public DirectoryRecord getParentDR() {
        return this.parentDR;
    }

    public boolean hasFilePathTag() {
        return this.hasComposite;
    }

    public String getRefFileIDPath() {
        return this.getRepCompositePath();
    }

    public String getRepCompositePath() {
        if (this.repCompPath != null) {
            return this.repCompPath;
        }
        if (null != this.tvs) {
            for (tagValue tv : this.tvs) {
                if (tv.group != 4 || tv.element != 5376) continue;
                this.hasComposite = true;
                String fileName = (String)tv.value;
                fileName = System.getProperty("os.name").startsWith("Windows") ? fileName.replace('/', File.separatorChar) : fileName.replace('\\', File.separatorChar);
                this.repCompPath = this.dirMountPath + File.separator + fileName;
                return this.repCompPath;
            }
        }
        return null;
    }

    public boolean isOffsetMatch(DirectoryRecord other) {
        return this.myOffset == other.myOffset;
    }

    public String toString() {
        String str = "[offset=" + this.myOffset + ", id=" + this.id + ", level=" + this.level + ", type=" + this.type + ", index=" + this.index + ", nextSibling=" + this.nextSibling + ", firstChild=" + this.firstChild + "]";
        return str;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected void setTags(Set<tagValue> tvs) {
        this.tvs = tvs;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void setLevel(String level) {
        this.level = level;
    }

    protected void setIndex(int index) {
        this.index = index;
    }

    protected void setRepCompositePath(String repCompPath) {
        this.repCompPath = repCompPath;
    }

    protected void setParentDR(DirectoryRecord parentDR) {
        this.parentDR = parentDR;
    }

    protected void setNextSiblingOffset(long nextSibling) {
        this.nextSibling = nextSibling;
    }

    protected void setFirstChildOffset(long firstChild) {
        this.firstChild = firstChild;
    }

    protected void writeNextSiblingOffsetToDICOMDIR(long siblingOffset) {
        this.nextSibling = siblingOffset;
        int curPos = this.mb.position();
        this.mb.position((int)this.myOffset + 16);
        this.mb.putInt((int)siblingOffset);
        this.mb.position(curPos);
    }

    protected void writeChildOffsetToDICOMDIR(long firstChildOffset) {
        this.firstChild = firstChildOffset;
        int curPos = this.mb.position();
        this.mb.position((int)this.myOffset + 38);
        this.mb.putInt((int)firstChildOffset);
        this.mb.position(curPos);
    }

    public static String makeDirectoryRecordID(String type, Set<tagValue> tvs) {
        if (type.equalsIgnoreCase("PATIENT")) {
            String namePat = null;
            String idPat = null;
            String dobPat = null;
            for (tagValue tag2 : tvs) {
                if (tag2.group == 16 && tag2.element == 16) {
                    namePat = (String)tag2.value;
                    continue;
                }
                if (tag2.group == 16 && tag2.element == 32) {
                    idPat = (String)tag2.value;
                    continue;
                }
                if (tag2.group != 16 || tag2.element != 48) continue;
                dobPat = (String)tag2.value;
            }
            return namePat + idPat + dobPat;
        }
        if (type.equalsIgnoreCase("STUDY")) {
            for (tagValue tag3 : tvs) {
                if (tag3.group != 32 || tag3.element != 13) continue;
                return (String)tag3.value;
            }
        } else if (type.equalsIgnoreCase("SERIES")) {
            for (tagValue tag4 : tvs) {
                if (tag4.group != 32 || tag4.element != 14) continue;
                return (String)tag4.value;
            }
        } else {
            for (tagValue tag5 : tvs) {
                if ((tag5.group != 4 || tag5.element != 5393) && (tag5.group != 8 || tag5.element != 24)) continue;
                return (String)tag5.value;
            }
        }
        return null;
    }

    protected void clear() {
        this.myOffset = -1L;
        this.mb = null;
        this.dirMountPath = null;
        this.parentDR = null;
        this.tvs.clear();
        this.tvs = null;
        this.id = null;
        this.level = null;
        this.type = null;
        this.nextSibling = -1L;
        this.firstChild = -1L;
        this.index = 0;
    }
}

