/*
 * Decompiled with CFR 0.152.
 */
package com.ge.med.terra.tap.dm.dicomdir;

import com.ge.med.terra.tap.Tap;
import com.ge.med.terra.tap.dm.dicomdir.Dicomdir;
import com.ge.med.terra.tap.dm.dicomdir.DirectoryRecordType;
import com.ge.med.terra.tap.dm.dicomdir.PrivateDirectoryRecordType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;

public class DirectoryEntityLevel {
    public static final String DE_FILENAME = "directory_entities.properties";
    private static final List<String> LEVEL_NAMES = Arrays.asList(Dicomdir.LEVEL_NAMES);
    private static Properties dicomdirLevelProps = null;
    private final String name;
    private final Map<String, DirectoryRecordType> drTypeInstanceMap = new HashMap<String, DirectoryRecordType>();

    public DirectoryEntityLevel(String levelName) {
        this.name = levelName;
        DirectoryEntityLevel.checkIfValidLevel(this.name);
        DirectoryEntityLevel.loadProperties();
        Set<String> drTypes = DirectoryEntityLevel.getDirectoryRecordTypeNames(this.name);
        for (String drName : drTypes) {
            this.drTypeInstanceMap.put(drName, null);
        }
    }

    private static void checkIfValidLevel(String levelName) throws IllegalArgumentException {
        if (!LEVEL_NAMES.contains(levelName)) {
            String msg = "Invalid Directory Entity Level name \"" + levelName + "\". Should be one of the following: [ ";
            for (String name : LEVEL_NAMES) {
                msg = msg + "\"" + name + "\" ";
            }
            msg = msg + "]";
            Tap.log.log(Level.WARNING, msg);
            throw new IllegalArgumentException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadProperties() {
        if (null == dicomdirLevelProps) {
            dicomdirLevelProps = new Properties();
            InputStream inStream = null;
            try {
                Tap.log.log(Level.INFO, "Loading {0}...", DE_FILENAME);
                inStream = DirectoryEntityLevel.class.getResourceAsStream(DE_FILENAME);
                dicomdirLevelProps.load(inStream);
                inStream.close();
            }
            catch (IOException ioex) {
                Tap.log.log(Level.WARNING, "Error loading directory_entities.properties: ", ioex);
            }
            catch (NullPointerException ex) {
                Tap.log.log(Level.WARNING, "File not found: directory_entities.properties");
            }
            finally {
                if (null != inStream) {
                    try {
                        inStream.close();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    private static Set<String> getDirectoryRecordTypeNames(String levelName) {
        HashSet<String> drSet;
        String stdDRTypeStr = dicomdirLevelProps.getProperty(levelName);
        String userDRTypeStr = Tap.getProperty("tap.dm.dicomdir.de." + levelName);
        if (null != userDRTypeStr) {
            stdDRTypeStr = stdDRTypeStr + "+" + userDRTypeStr;
        }
        if (null != stdDRTypeStr) {
            String[] drTypeNames = stdDRTypeStr.trim().toUpperCase(Locale.ENGLISH).split("\\+");
            drSet = new HashSet<String>(Arrays.asList(drTypeNames));
        } else {
            drSet = new HashSet<String>(0);
        }
        return drSet;
    }

    public String getName() {
        return this.name;
    }

    public static Set<String> getAllDirectoryRecordTypeNames(String levelName) {
        DirectoryEntityLevel.checkIfValidLevel(levelName);
        DirectoryEntityLevel.loadProperties();
        return DirectoryEntityLevel.getDirectoryRecordTypeNames(levelName);
    }

    public DirectoryRecordType getDirectoryRecordType(String drTypeName) {
        String drName = drTypeName.trim().toUpperCase(Locale.ENGLISH);
        DirectoryRecordType drType = this.drTypeInstanceMap.get(drName);
        if (null == drType) {
            Class<?> drTypeClass = DirectoryRecordType.drTypeClassMap.get(drName);
            try {
                drType = null == drTypeClass ? new PrivateDirectoryRecordType(drName) : (DirectoryRecordType)drTypeClass.newInstance();
                this.drTypeInstanceMap.put(drName, drType);
                Tap.log.log(Level.INFO, "Created Instance of Directory Record Type: \"" + drName);
            }
            catch (Exception ex) {
                String msg = "Unable to create Directory Record Type: \"" + drName + "\"";
                Tap.log.log(Level.SEVERE, msg);
                ex.printStackTrace();
                throw new IllegalArgumentException(msg, ex);
            }
        }
        return drType;
    }

    public static List<String> getParentLevels(String levelName) {
        DirectoryEntityLevel.checkIfValidLevel(levelName);
        int level = LEVEL_NAMES.indexOf(levelName);
        return LEVEL_NAMES.subList(0, level);
    }

    public static List<String> getChildLevels(String levelName) {
        DirectoryEntityLevel.checkIfValidLevel(levelName);
        int level = LEVEL_NAMES.indexOf(levelName);
        return LEVEL_NAMES.subList(level + 1, LEVEL_NAMES.size());
    }

    public static int getIndex(String levelName) {
        DirectoryEntityLevel.checkIfValidLevel(levelName);
        return LEVEL_NAMES.indexOf(levelName);
    }

    public String toString() {
        String str = "[level name=\"" + this.name + "\", # Directory Record Types=" + this.drTypeInstanceMap.keySet().size() + "]";
        return str;
    }
}

